/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.api.common.IItemHandler;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.blockentity.SkinnableBlockEntity;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class LinkingToolItem
extends FlavouredItem
implements IItemHandler,
IItemPropertiesProvider {
    public LinkingToolItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> {
            if (ComponentAPI.has(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get())) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    @Override
    public ActionResultType useOnFirst(ItemStack itemStack, ItemUseContext context) {
        World level = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        if (level.func_201670_d() || player == null) {
            return ActionResultType.SUCCESS;
        }
        GlobalPos linkedPos = (GlobalPos)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
        SkinnableBlockEntity blockEntity = this.getTitleEntity(level, context.func_195995_a());
        if (blockEntity != null && player.func_226563_dT_()) {
            blockEntity.setLinkedPos(null);
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.clear", new Object[0]));
            return ActionResultType.SUCCESS;
        }
        if (linkedPos != null) {
            if (Objects.equals(level.func_234923_W_(), linkedPos.func_239646_a_())) {
                int maxDistance = ModConfig.Common.maxLinkDistance;
                if (maxDistance > 0 && !context.func_195995_a().func_218141_a((Vector3i)linkedPos.func_218180_b(), (double)maxDistance + 0.5)) {
                    SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.targetTooFar", new Object[0]));
                    return ActionResultType.FAIL;
                }
            } else if (!ModConfig.Common.enableLinkDimensional) {
                SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.targetWrongDimensions", new Object[0]));
                return ActionResultType.FAIL;
            }
            ComponentAPI.remove(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get());
            if (blockEntity != null) {
                blockEntity.setLinkedPos(linkedPos);
                SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.finish", new Object[0]));
                return ActionResultType.SUCCESS;
            }
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.fail", new Object[0]));
            return ActionResultType.SUCCESS;
        }
        if (blockEntity != null) {
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.linkedToSkinnable", new Object[0]));
            return ActionResultType.FAIL;
        }
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.LINKED_POS.get(), GlobalPos.func_239648_a_((RegistryKey)level.func_234923_W_(), (BlockPos)context.func_195995_a()));
        SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.linking-tool.start", new Object[0]));
        return ActionResultType.SUCCESS;
    }

    private SkinnableBlockEntity getTitleEntity(World level, BlockPos blockPos) {
        TileEntity blockEntity = level.func_175625_s(blockPos);
        if (blockEntity instanceof SkinnableBlockEntity) {
            return (SkinnableBlockEntity)blockEntity;
        }
        return null;
    }
}

