/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.holiday;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.core.AbstractSavedData;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.storage.DimensionDataStorage.DataProvider;
import moe.plushie.armourers_workshop.core.holiday.Holiday;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;

public class HolidayTracker
extends AbstractSavedData {
    private final Calendar calendar = Calendar.getInstance();
    private final HashSet<String> logs = new HashSet();

    public static HolidayTracker of(MinecraftServer server) {
        return DataProvider.computeIfAbsent(server.func_241755_D_().func_217481_x(), HolidayTracker::new, 0, "HolidayTracker");
    }

    public void add(PlayerEntity player, Holiday holiday) {
        ModLog.info("give a {} gift sack for the {}", holiday.name(), player.func_195047_I_());
        this.logs.add(this.getKey(player, holiday));
        this.setDirty();
    }

    public void remove(PlayerEntity player, Holiday holiday) {
        ModLog.info("take a {} gift sack for the {}", holiday.name(), player.func_195047_I_());
        this.logs.remove(this.getKey(player, holiday));
        this.setDirty();
    }

    public boolean has(PlayerEntity player, Holiday holiday) {
        return this.logs.contains(this.getKey(player, holiday));
    }

    @Override
    public void deserialize(IDataSerializer serializer) {
        this.logs.clear();
        String prefix = this.calendar.get(1) + ":";
        for (String log : serializer.read(CodingKeys.LOG)) {
            if (!log.startsWith(prefix)) continue;
            this.logs.add(log);
        }
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        String prefix = this.calendar.get(1) + ":";
        ArrayList<String> filteredLogs = new ArrayList<String>();
        for (String log : this.logs) {
            if (!log.startsWith(prefix)) continue;
            filteredLogs.add(log);
        }
        serializer.write(CodingKeys.LOG, filteredLogs);
    }

    private String getKey(PlayerEntity player, Holiday holiday) {
        return this.calendar.get(1) + ":" + holiday.name() + ":" + player.func_189512_bd();
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<List<String>> LOG = IDataSerializerKey.create("Logs", IDataCodec.STRING.listOf(), Collections.emptyList());

        private CodingKeys() {
        }
    }
}

