/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.core.data.action.EntityAction;

public class EntityActionSet {
    protected final BitSet flags = new BitSet(EntityAction.values().length);

    public void set(EntityAction action, boolean value) {
        if (value) {
            this.flags.set(action.ordinal());
        }
    }

    public boolean contains(EntityAction action) {
        if (action == EntityAction.IDLE) {
            return this.flags.isEmpty();
        }
        return this.flags.get(action.ordinal());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityActionSet)) {
            return false;
        }
        EntityActionSet that = (EntityActionSet)o;
        return this.flags.equals(that.flags);
    }

    public int hashCode() {
        return this.flags.hashCode();
    }

    public EntityActionSet copy() {
        EntityActionSet result = new EntityActionSet();
        result.flags.or(this.flags);
        return result;
    }

    public String toString() {
        String prefix = "";
        LinkedHashMap<String, ArrayList> lists = new LinkedHashMap<String, ArrayList>();
        StringBuilder results = new StringBuilder();
        for (EntityAction flag : EntityAction.values()) {
            if (!this.contains(flag)) continue;
            String[] parts = flag.name().toLowerCase().split("_");
            ArrayList sp = lists.computeIfAbsent(parts[0], k -> new ArrayList());
            sp.addAll(Arrays.asList(parts).subList(1, parts.length));
        }
        for (Map.Entry entry : lists.entrySet()) {
            results.append(prefix);
            results.append((String)entry.getKey());
            prefix = "; ";
            if (((ArrayList)entry.getValue()).isEmpty()) continue;
            results.append(entry.getValue());
        }
        return results.toString();
    }
}

