/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.Optional;
import moe.plushie.armourers_workshop.api.common.IEntityCapability;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobeJS;
import moe.plushie.armourers_workshop.core.client.other.BlockEntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.data.BlockEntityAnimationState;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.data.EntityAnimationState;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.EntityVariableStorageImpl;
import moe.plushie.armourers_workshop.core.utils.LazyOptional;
import moe.plushie.armourers_workshop.init.ModCapabilities;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityDataStorage {
    public static EntityImpl of(Entity entity) {
        return DataContainer.of(entity, EntityImpl::new);
    }

    public static BlockEntityImpl of(TileEntity entity) {
        return DataContainer.of(entity, BlockEntityImpl::new);
    }

    public static class EntityImpl {
        protected final LazyOptional<SkinWardrobe> wardrobe = LazyOptional.of(() -> ((IEntityCapability)ModCapabilities.ENTITY_WARDROBE.get()).get(entity));
        protected final LazyOptional<SkinWardrobeJS> wardrobeJS = LazyOptional.of(() -> this.wardrobe.resolve().map(SkinWardrobeJS::new));
        protected final LazyOptional<EntityRenderData> renderData = LazyOptional.of(() -> EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> new EntityRenderData(entity)));
        protected final LazyOptional<EntityAnimationState> animationState = LazyOptional.ofNullable(EntityAnimationState::new);
        protected final LazyOptional<EntityVariableStorageImpl> variableStorage = LazyOptional.ofNullable(EntityVariableStorageImpl::new);

        public EntityImpl(Entity entity) {
        }

        public Optional<SkinWardrobe> wardrobe() {
            return this.wardrobe.resolve();
        }

        public Optional<SkinWardrobeJS> wardrobeJS() {
            return this.wardrobeJS.resolve();
        }

        public Optional<EntityAnimationState> animationState() {
            return this.animationState.resolve();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Optional<EntityRenderData> renderData() {
            return this.renderData.resolve();
        }

        public Optional<EntityVariableStorageImpl> variableStorage() {
            return this.variableStorage.resolve();
        }
    }

    public static class BlockEntityImpl {
        protected final LazyOptional<BlockEntityRenderData> renderData = LazyOptional.of(() -> EnvironmentExecutor.callOn(EnvironmentType.CLIENT, () -> () -> new BlockEntityRenderData(entity)));
        protected final LazyOptional<BlockEntityAnimationState> animationState = LazyOptional.ofNullable(BlockEntityAnimationState::new);
        protected final LazyOptional<EntityVariableStorageImpl> variableStorage = LazyOptional.ofNullable(EntityVariableStorageImpl::new);

        public BlockEntityImpl(TileEntity entity) {
        }

        public Optional<BlockEntityAnimationState> animationState() {
            return this.animationState.resolve();
        }

        @OnlyIn(value=Dist.CLIENT)
        public Optional<BlockEntityRenderData> renderData() {
            return this.renderData.resolve();
        }

        public Optional<EntityVariableStorageImpl> variableStorage() {
            return this.variableStorage.resolve();
        }
    }
}

