/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.google.common.collect.Range;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanUse;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SkinRenderHelper {
    public static int getRenderCount(BakedSkin bakedSkin) {
        int count = 0;
        for (BakedSkinPart part : bakedSkin.parts()) {
            if (!part.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public static void apply(@Nullable Entity entity, BakedSkin bakedSkin, BakedArmature bakedArmature, SkinItemSource itemSource) {
        for (BakedSkinPart part : bakedSkin.parts()) {
            boolean shouldRender = false;
            if (bakedArmature != null && bakedArmature.transformByPart(part) != null) {
                shouldRender = true;
            }
            if (shouldRender) {
                shouldRender = SkinRenderHelper.shouldRenderPart(entity, part, bakedSkin, itemSource);
            }
            part.setShouldRender(shouldRender);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldRenderPart(@Nullable Entity entity, BakedSkinPart bakedPart, BakedSkin bakedSkin, SkinItemSource itemSource) {
        SkinPartType partType = bakedPart.type();
        if (partType == SkinPartTypes.ITEM_FISHING_HOOK) {
            return SkinRenderHelper.isHookEntity(entity);
        }
        if (partType == SkinPartTypes.ITEM_FISHING_ROD1) {
            if (!(entity instanceof PlayerEntity)) return false;
            PlayerEntity player = (PlayerEntity)entity;
            if (player.field_71104_cf == null) return false;
            return true;
        }
        if (partType == SkinPartTypes.ITEM_FISHING_ROD) {
            if (SkinRenderHelper.isHookEntity(entity)) {
                return false;
            }
            if (!(entity instanceof PlayerEntity)) return true;
            PlayerEntity player = (PlayerEntity)entity;
            if (player.field_71104_cf == null) return true;
            return false;
        }
        if (partType == SkinPartTypes.ITEM_ARROW) {
            if (SkinRenderHelper.isArrowEntity(entity)) {
                return true;
            }
            if (itemSource.displayContext() != OpenItemDisplayContext.NONE) return false;
            if (bakedPart.children().size() != 1) return false;
            return true;
        }
        if (SkinRenderHelper.isArrowEntity(entity)) {
            return false;
        }
        if (SkinRenderHelper.isHookEntity(entity)) {
            return false;
        }
        if (!(partType instanceof ICanUse)) return true;
        ICanUse canUse = (ICanUse)((Object)partType);
        if (!(entity instanceof LivingEntity)) return true;
        LivingEntity livingEntity = (LivingEntity)entity;
        int useTick = SkinRenderHelper.getUseTick(livingEntity, itemSource.item());
        Range<Integer> useRange = canUse.useRange();
        Range<Integer> tickRange = bakedSkin.useTickRange();
        return useRange.contains((Comparable)Integer.valueOf(OpenMath.clamp(useTick, (Integer)tickRange.lowerEndpoint(), (Integer)tickRange.upperEndpoint())));
    }

    private static boolean isHookEntity(@Nullable Entity entity) {
        return entity instanceof FishingBobberEntity;
    }

    private static boolean isArrowEntity(@Nullable Entity entity) {
        if (entity instanceof TridentEntity) {
            return false;
        }
        return entity instanceof AbstractArrowEntity;
    }

    public static int getUseTick(LivingEntity entity, ItemStack itemStack) {
        if (entity.func_184607_cu() == itemStack) {
            return entity.func_184612_cw();
        }
        if (CrossbowItem.func_220012_d((ItemStack)itemStack)) {
            return 100;
        }
        return 0;
    }
}

