/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.client.other.SkinItemProperties;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SkinItemSource {
    public static final SkinItemSource EMPTY = new SkinItemSource();
    private float renderPriority;
    private ItemStack itemStack;
    private SkinItemProperties itemProperties;
    private OpenVector3f itemScale;
    private OpenVector3f itemRotation;
    private OpenItemDisplayContext itemDisplayContext;

    public SkinItemSource() {
        this(0.0f, ItemStack.field_190927_a, OpenItemDisplayContext.NONE);
    }

    public SkinItemSource(float renderPriority, ItemStack itemStack, OpenItemDisplayContext itemDisplayContext) {
        this.renderPriority = renderPriority;
        this.itemStack = itemStack;
        this.itemDisplayContext = itemDisplayContext;
    }

    public static SkinItemSource create(ItemStack itemStack) {
        return SkinItemSource.create(0.0f, itemStack, OpenItemDisplayContext.NONE, null);
    }

    public static SkinItemSource create(ItemStack itemStack, OpenItemDisplayContext transformType) {
        return SkinItemSource.create(0.0f, itemStack, transformType, null);
    }

    public static SkinItemSource create(float renderPriority, ItemStack itemStack) {
        return SkinItemSource.create(renderPriority, itemStack, OpenItemDisplayContext.NONE, null);
    }

    public static SkinItemSource create(float renderPriority, ItemStack itemStack, OpenItemDisplayContext transformType) {
        return SkinItemSource.create(renderPriority, itemStack, transformType, null);
    }

    public static SkinItemSource create(float renderPriority, ItemStack itemStack, OpenItemDisplayContext transformType, @Nullable SkinItemProperties itemProperties) {
        SkinItemSource itemSource = new SkinItemSource();
        itemSource.setItem(itemStack);
        itemSource.setRenderPriority(renderPriority);
        itemSource.setDisplayContext(transformType);
        itemSource.setScale(null);
        itemSource.setRotation(null);
        itemSource.setProperties(itemProperties);
        return itemSource;
    }

    public void setItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack item() {
        return this.itemStack;
    }

    public void setRenderPriority(float renderPriority) {
        this.renderPriority = renderPriority;
    }

    public float renderPriority() {
        return this.renderPriority;
    }

    public void setRotation(OpenVector3f rotation) {
        this.itemRotation = rotation;
    }

    public OpenVector3f rotation() {
        return this.itemRotation;
    }

    public void setScale(OpenVector3f scale) {
        this.itemScale = scale;
    }

    public OpenVector3f scale() {
        return this.itemScale;
    }

    public void setDisplayContext(OpenItemDisplayContext itemDisplayContext) {
        this.itemDisplayContext = itemDisplayContext;
    }

    public OpenItemDisplayContext displayContext() {
        return this.itemDisplayContext;
    }

    public void setProperties(SkinItemProperties itemProperties) {
        this.itemProperties = itemProperties;
    }

    public SkinItemProperties properties() {
        return this.itemProperties;
    }
}

