/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenNativeImage;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class SkinDynamicTexture
extends DynamicTexture {
    private final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private SkinPaintData paintData;
    private OpenNativeImage downloadedImage;
    private OpenResourceLocation refer;
    private Texture referTexture;
    private boolean needsUpdate = true;

    public SkinDynamicTexture() {
        super(64, 64, true);
    }

    public OpenResourceLocation refer() {
        return this.refer;
    }

    public void setRefer(OpenResourceLocation refer) {
        if (!Objects.equals(this.refer, refer)) {
            this.refer = refer;
            this.referTexture = Objects.flatMap(refer, it -> this.textureManager.func_229267_b_(it.toLocation()));
            this.downloadedImage = null;
            this.setNeedsUpdate();
        }
    }

    public SkinPaintData paintData() {
        return this.paintData;
    }

    public void setPaintData(SkinPaintData paintData) {
        if (this.paintData != paintData) {
            this.paintData = paintData;
            this.setNeedsUpdate();
        }
    }

    public void func_110564_a() {
        OpenNativeImage downloadedImage = this.downloadedImage();
        OpenNativeImage mergedImage = OpenNativeImage.of(this.func_195414_e());
        if (mergedImage == null || downloadedImage == null) {
            return;
        }
        mergedImage.copyFrom(downloadedImage);
        if (this.paintData != null) {
            this.applyPaintColor(mergedImage);
        }
        super.func_110564_a();
    }

    private void setNeedsUpdate() {
        this.needsUpdate = true;
        RenderSystem.recordRenderCall(() -> {
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.func_110564_a();
            }
        });
    }

    private void applyPaintColor(OpenNativeImage mergedImage) {
        for (int iy = 0; iy < this.paintData.height(); ++iy) {
            for (int ix = 0; ix < this.paintData.width(); ++ix) {
                int color = this.paintData.getColor(ix, iy);
                if (!SkinPaintColor.isOpaque(color)) continue;
                mergedImage.setPixel(ix, iy, color);
            }
        }
    }

    private OpenNativeImage downloadedImage() {
        if (this.downloadedImage != null) {
            return this.downloadedImage;
        }
        if (this.referTexture != null) {
            GL11.glBindTexture((int)3553, (int)this.referTexture.func_110552_b());
            this.downloadedImage = OpenNativeImage.of(0, 64, 64);
        }
        return this.downloadedImage;
    }
}

