/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.core.client.other.EntitySlotsHandler;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.BlockEntityRenderPatch;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BlockEntityRenderData
extends EntitySlotsHandler<TileEntity> {
    private Object customTextureProvider;
    private BlockEntityRenderPatch<? super TileEntity> renderPatch;

    public BlockEntityRenderData(TileEntity blockEntity) {
        super(blockEntity, new EntitySlotsHandler.BlockEntityProvider(), new EntitySlotsHandler.WardrobeProvider());
        this.renderPatch = new BlockEntityRenderPatch(blockEntity);
        this.renderPatch.renderingContext().setAnimationManager(this.animationManager());
    }

    @Nullable
    public static BlockEntityRenderData of(@Nullable TileEntity entity) {
        if (entity != null) {
            return EntityDataStorage.of(entity).renderData().orElse(null);
        }
        return null;
    }

    public void tick(TileEntity blockEntity) {
        this.tick(blockEntity, null);
    }

    public BlockEntityRenderPatch<? super TileEntity> renderPatch() {
        return this.renderPatch;
    }

    public void setCustomTextureProvider(Object customTextureProvider) {
        this.customTextureProvider = customTextureProvider;
    }

    public Object customTextureProvider() {
        return this.customTextureProvider;
    }
}

