/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.blockentity;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IBlockEntityCapability;
import moe.plushie.armourers_workshop.api.common.ITickable;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.core.block.SkinnableBlock;
import moe.plushie.armourers_workshop.core.blockentity.RotableContainerBlockEntity;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.SimpleContainer;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3i;
import moe.plushie.armourers_workshop.core.math.OpenVector3d;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SkinnableBlockEntity
extends RotableContainerBlockEntity
implements ITickable {
    private static final Map<?, OpenVector3f> FACING_TO_ROT = Collections.immutableMap(it -> {
        it.put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.EAST), (Object)new OpenVector3f(180.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.NORTH), (Object)new OpenVector3f(180.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.WEST), (Object)new OpenVector3f(180.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.CEILING, (Object)Direction.SOUTH), (Object)new OpenVector3f(180.0f, 0.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.EAST), (Object)new OpenVector3f(0.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.SOUTH), (Object)new OpenVector3f(0.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.WEST), (Object)new OpenVector3f(0.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.WALL, (Object)Direction.NORTH), (Object)new OpenVector3f(0.0f, 0.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.EAST), (Object)new OpenVector3f(0.0f, 270.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.SOUTH), (Object)new OpenVector3f(0.0f, 180.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.WEST), (Object)new OpenVector3f(0.0f, 90.0f, 0.0f));
        it.put((Object)Pair.of((Object)AttachFace.FLOOR, (Object)Direction.NORTH), (Object)new OpenVector3f(0.0f, 0.0f, 0.0f));
    });
    private BlockPos reference = BlockPos.field_177992_a;
    private OpenRectangle3i collisionShape = OpenRectangle3i.ZERO;
    private SimpleContainer container;
    private List<BlockPos> refers;
    private List<SkinMarker> markers;
    private GlobalPos linkedPos = null;
    private SkinProperties properties;
    private SkinDescriptor skin = SkinDescriptor.EMPTY;
    private OpenQuaternionf renderRotations;
    private AxisAlignedBB renderBoundingBox;
    private VoxelShape cachedRenderShape = null;
    private VoxelShape cachedCollisionShape = null;
    private ItemStack droppedStack = null;
    private LinkedSnapshot lastSnapshot;
    private int callDepth = 0;
    private boolean isParent = false;

    public SkinnableBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public static OpenVector3f getRotations(BlockState state) {
        AttachFace face = state.func_235903_d_((Property)SkinnableBlock.FACE).orElse(AttachFace.FLOOR);
        Direction facing = state.func_235903_d_((Property)SkinnableBlock.field_185512_D).orElse(Direction.NORTH);
        return FACING_TO_ROT.getOrDefault(Pair.of((Object)face, (Object)facing), OpenVector3f.ZERO);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.reference = serializer.read(CodingKeys.REFERENCE);
        this.collisionShape = serializer.read(CodingKeys.SHAPE);
        this.cachedRenderShape = null;
        this.cachedCollisionShape = null;
        this.isParent = BlockPos.field_177992_a.equals((Object)this.reference);
        if (!this.isParent()) {
            return;
        }
        SkinProperties oldProperties = this.properties;
        this.refers = serializer.read(CodingKeys.REFERENCES);
        this.markers = serializer.read(CodingKeys.MARKERS);
        this.skin = serializer.read(CodingKeys.SKIN);
        this.properties = serializer.read(CodingKeys.SKIN_PROPERTIES);
        this.linkedPos = serializer.read(CodingKeys.LINKED_POS);
        if (oldProperties != null) {
            oldProperties.clear();
            oldProperties.putAll(this.properties);
            this.properties = oldProperties;
        }
        this.getOrCreateItems().deserialize(serializer);
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(CodingKeys.REFERENCE, this.reference);
        serializer.write(CodingKeys.SHAPE, this.collisionShape);
        if (!this.isParent()) {
            return;
        }
        serializer.write(CodingKeys.REFERENCES, this.refers);
        serializer.write(CodingKeys.MARKERS, this.markers);
        serializer.write(CodingKeys.SKIN, this.skin);
        serializer.write(CodingKeys.SKIN_PROPERTIES, this.properties);
        serializer.write(CodingKeys.LINKED_POS, this.linkedPos);
        this.getOrCreateItems().serialize(serializer);
    }

    @Override
    public void tick() {
        if (this.isParent()) {
            this.parentTick();
        } else {
            this.childTick();
        }
    }

    protected void parentTick() {
        LinkedSnapshot snapshot = this.makeLinkedSnapshot();
        if (!Objects.equals(this.lastSnapshot, snapshot)) {
            this.updateStateAndNeighbors();
            this.lastSnapshot = snapshot;
        }
    }

    protected void childTick() {
        World level = this.func_145831_w();
        SkinnableBlockEntity parent = this.getParent();
        if (parent == null && level != null && !level.func_201670_d()) {
            ModLog.warn("found a zombie block at {}, destroy it.", this.func_174877_v());
            this.kill();
        }
    }

    public void updateBlockStates() {
        this.func_70296_d();
        World level = this.func_145831_w();
        if (level != null && !level.func_201670_d()) {
            level.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void updateStateAndNeighbors() {
        World level = this.func_145831_w();
        if (level != null && !level.func_201670_d()) {
            level.func_175666_e(this.func_174877_v(), this.func_195044_w().func_177230_c());
            level.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
        }
    }

    public void setSkin(SkinDescriptor skin) {
        this.skin = skin;
    }

    public SkinDescriptor getSkin() {
        if (this.isParent()) {
            return this.skin;
        }
        return SkinDescriptor.EMPTY;
    }

    public VoxelShape getShape() {
        if (this.cachedRenderShape != null) {
            return this.cachedRenderShape;
        }
        this.cachedRenderShape = this.calcCollisionShape();
        return this.cachedRenderShape;
    }

    public VoxelShape getCollisionShape() {
        if (this.noCollision()) {
            return VoxelShapes.func_197880_a();
        }
        if (this.cachedCollisionShape != null) {
            return this.cachedCollisionShape;
        }
        this.cachedCollisionShape = this.calcCollisionShape();
        return this.cachedCollisionShape;
    }

    public void setLinkedPos(GlobalPos pos) {
        SkinnableBlockEntity blockEntity = this.getParent();
        if (blockEntity != null) {
            blockEntity.linkedPos = pos;
            blockEntity.updateBlockStates();
            blockEntity.updateStateAndNeighbors();
        }
    }

    public GlobalPos getLinkedPos() {
        return this.getValueFromParent(te -> te.linkedPos).orElse(null);
    }

    public void kill() {
        World level = this.func_145831_w();
        if (level != null && !level.func_201670_d()) {
            level.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    public int func_70302_i_() {
        return 81;
    }

    @Override
    protected SimpleContainer getContainer() {
        return this.getOrCreateItems();
    }

    @Nullable
    public String getInventoryName() {
        return this.getProperty(SkinProperty.ALL_CUSTOM_NAME);
    }

    @Override
    @Nullable
    public IInventory getInventory() {
        return this.getParent();
    }

    public int getAnalogOutputSignal() {
        return this.getLinkedValueFromParent((level, pos) -> level.func_180495_p(pos).func_185888_a(level, pos)).orElse(0);
    }

    public int getSignal(Direction dir) {
        return this.getLinkedValueFromParent((level, pos) -> level.func_180495_p(pos).func_185911_a((IBlockReader)level, pos, dir)).orElse(0);
    }

    public int getDirectSignal(Direction dir) {
        return this.getLinkedValueFromParent((level, pos) -> level.func_180495_p(pos).func_185893_b((IBlockReader)level, pos, dir)).orElse(0);
    }

    public Collection<BlockPos> getRefers() {
        if (this.refers == null) {
            this.refers = this.getValueFromParent(te -> te.refers).orElse(null);
        }
        if (this.refers == null) {
            return Collections.emptyList();
        }
        return this.refers;
    }

    public BlockPos getParentPos() {
        return this.func_174877_v().func_177973_b((Vector3i)this.reference);
    }

    public OpenVector3d getSeatPos() {
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        BlockPos parentPos = this.getParentPos();
        Collection<SkinMarker> markers = this.getMarkers();
        if (markers != null && !markers.isEmpty()) {
            SkinMarker marker = markers.iterator().next();
            dx = (float)marker.x / 16.0f;
            dy = (float)marker.y / 16.0f;
            dz = (float)marker.z / 16.0f;
        }
        return new OpenVector3d((float)parentPos.func_177958_n() + dx, (float)parentPos.func_177956_o() + dy, (float)parentPos.func_177952_p() + dz);
    }

    public BlockPos getBedPos() {
        BlockPos parentPos = this.getParentPos();
        Collection<SkinMarker> markers = this.getMarkers();
        if (markers == null || markers.isEmpty()) {
            Direction facing = this.func_195044_w().func_235903_d_((Property)SkinnableBlock.field_185512_D).orElse(Direction.NORTH);
            return parentPos.func_177972_a(Rotation.CLOCKWISE_180.func_185831_a(facing));
        }
        SkinMarker marker = markers.iterator().next();
        return parentPos.func_177982_a(marker.x / 16, marker.y / 16, marker.z / 16);
    }

    public Collection<SkinMarker> getMarkers() {
        if (this.markers == null) {
            this.markers = this.getValueFromParent(te -> te.markers).orElse(null);
        }
        return this.markers;
    }

    @Nullable
    public SkinProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.getValueFromParent(te -> te.properties).orElse(null);
        }
        return this.properties;
    }

    @Nullable
    public SkinnableBlockEntity getParent() {
        if (this.isParent()) {
            return this;
        }
        if (this.func_145831_w() != null) {
            return Objects.safeCast(this.func_145831_w().func_175625_s(this.getParentPos()), SkinnableBlockEntity.class);
        }
        return null;
    }

    public void setDropped(ItemStack itemStack) {
        this.droppedStack = itemStack;
    }

    public ItemStack getDropped() {
        return this.droppedStack;
    }

    public boolean isDropped() {
        return this.droppedStack != null;
    }

    public boolean isLadder() {
        return this.getProperty(SkinProperty.BLOCK_LADDER);
    }

    public boolean isEmissive() {
        return this.getProperty(SkinProperty.BLOCK_GLOWING);
    }

    public boolean isSeat() {
        return this.getProperty(SkinProperty.BLOCK_SEAT);
    }

    public boolean isBed() {
        return this.getProperty(SkinProperty.BLOCK_BED);
    }

    public boolean isLinked() {
        return this.getLinkedPos() != null;
    }

    public boolean isInventory() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY) != false || this.isEnderInventory();
    }

    public boolean isEnderInventory() {
        return this.getProperty(SkinProperty.BLOCK_ENDER_INVENTORY);
    }

    public boolean isParent() {
        return this.isParent;
    }

    public boolean noCollision() {
        return this.getProperty(SkinProperty.BLOCK_NO_COLLISION);
    }

    public int getInventoryWidth() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY_WIDTH);
    }

    public int getInventoryHeight() {
        return this.getProperty(SkinProperty.BLOCK_INVENTORY_HEIGHT);
    }

    @Override
    @Nullable
    public <T> T getCapability(IBlockEntityCapability<T> capability, @Nullable Direction dir) {
        return this.getLinkedValueFromParent((level, pos) -> {
            BlockState state = level.func_180495_p(pos);
            TileEntity entity = level.func_175625_s(pos);
            return capability.get((World)level, (BlockPos)pos, state, entity, dir);
        }).orElse(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OpenQuaternionf getRenderRotations(BlockState blockState) {
        if (this.renderRotations != null) {
            return this.renderRotations;
        }
        OpenVector3f r = SkinnableBlockEntity.getRotations(blockState);
        this.renderRotations = new OpenQuaternionf(r.x(), r.y(), r.z(), true);
        return this.renderRotations;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OpenRectangle3f getRenderShape(BlockState blockState) {
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(this.getSkin(), Tickets.TEST);
        if (bakedSkin == null) {
            return null;
        }
        float f = 0.0625f;
        OpenRectangle3f box = bakedSkin.renderBounds().copy();
        box.mul(OpenMatrix4f.createScaleMatrix(-f, -f, f));
        return box;
    }

    private SimpleContainer getOrCreateItems() {
        if (this.container == null) {
            this.container = new SimpleContainer(this.func_70302_i_());
        }
        return this.container;
    }

    public <V> Optional<V> getValueFromParent(Function<SkinnableBlockEntity, V> getter) {
        SkinnableBlockEntity blockEntity = this.getParent();
        if (blockEntity != null) {
            return Optional.ofNullable(getter.apply(blockEntity));
        }
        return Optional.empty();
    }

    public <V> Optional<V> getLinkedValueFromParent(BiFunction<World, BlockPos, V> getter) {
        GlobalPos globalPos = this.getLinkedPos();
        if (globalPos == null) {
            return Optional.empty();
        }
        World level = this.func_145831_w();
        if (level == null) {
            return Optional.empty();
        }
        if (!Objects.equals(level.func_234923_W_(), globalPos.func_239646_a_())) {
            MinecraftServer server = level.func_73046_m();
            if (server == null) {
                return Optional.empty();
            }
            level = server.func_71218_a(globalPos.func_239646_a_());
        }
        if (level == null || !level.func_195588_v(globalPos.func_218180_b()) || this.callDepth > 10) {
            return Optional.empty();
        }
        ++this.callDepth;
        V result = getter.apply(level, globalPos.func_218180_b());
        --this.callDepth;
        return Optional.ofNullable(result);
    }

    private <V> V getProperty(SkinProperty<V> property) {
        SkinProperties properties = this.getProperties();
        if (properties != null) {
            return properties.get(property);
        }
        return property.defaultValue();
    }

    private LinkedSnapshot makeLinkedSnapshot() {
        Optional<LinkedSnapshot> result = this.getLinkedValueFromParent((level, pos) -> {
            LinkedSnapshot snapshot = new LinkedSnapshot();
            BlockState state = level.func_180495_p(pos);
            if (state.func_185912_n()) {
                snapshot.analogOutputSignal = state.func_185888_a(level, pos);
            }
            for (Direction dir : Direction.values()) {
                ((LinkedSnapshot)snapshot).redstoneSignal[dir.func_176745_a()] = state.func_185911_a((IBlockReader)level, pos, dir);
                ((LinkedSnapshot)snapshot).directRedstoneSignal[dir.func_176745_a()] = state.func_185893_b((IBlockReader)level, pos, dir);
            }
            return snapshot;
        });
        return result.orElse(null);
    }

    private VoxelShape calcCollisionShape() {
        if (this.collisionShape.equals(OpenRectangle3i.ZERO)) {
            return VoxelShapes.func_197868_b();
        }
        float minX = (float)this.collisionShape.minX() / 16.0f + 0.5f;
        float minY = (float)this.collisionShape.minY() / 16.0f + 0.5f;
        float minZ = (float)this.collisionShape.minZ() / 16.0f + 0.5f;
        float maxX = (float)this.collisionShape.maxX() / 16.0f + 0.5f;
        float maxY = (float)this.collisionShape.maxY() / 16.0f + 0.5f;
        float maxZ = (float)this.collisionShape.maxZ() / 16.0f + 0.5f;
        return VoxelShapes.func_197873_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<BlockPos> REFERENCE = IDataSerializerKey.create("Refer", IDataCodec.BLOCK_POS, BlockPos.field_177992_a);
        public static final IDataSerializerKey<OpenRectangle3i> SHAPE = IDataSerializerKey.create("Shape", OpenRectangle3i.CODEC, OpenRectangle3i.ZERO);
        public static final IDataSerializerKey<GlobalPos> LINKED_POS = IDataSerializerKey.create("LinkedPos", IDataCodec.GLOBAL_POS, null);
        public static final IDataSerializerKey<SkinDescriptor> SKIN = IDataSerializerKey.create("Skin", SkinDescriptor.CODEC, SkinDescriptor.EMPTY);
        public static final IDataSerializerKey<SkinProperties> SKIN_PROPERTIES = IDataSerializerKey.create("SkinProperties", SkinProperties.CODEC, SkinProperties.EMPTY, SkinProperties.EMPTY::copy);
        public static final IDataSerializerKey<List<BlockPos>> REFERENCES = IDataSerializerKey.create("Refers", IDataCodec.BLOCK_POS.listOf(), Collections.emptyList());
        public static final IDataSerializerKey<List<SkinMarker>> MARKERS = IDataSerializerKey.create("Markers", SkinMarker.CODEC.listOf(), Collections.emptyList());

        private CodingKeys() {
        }
    }

    private static class LinkedSnapshot {
        private int analogOutputSignal = 0;
        private final int[] redstoneSignal = new int[]{0, 0, 0, 0, 0, 0};
        private final int[] directRedstoneSignal = new int[]{0, 0, 0, 0, 0, 0};

        private LinkedSnapshot() {
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinkedSnapshot)) {
                return false;
            }
            LinkedSnapshot snapshot = (LinkedSnapshot)o;
            return this.analogOutputSignal == snapshot.analogOutputSignal && Arrays.equals(this.redstoneSignal, snapshot.redstoneSignal) && Arrays.equals(this.directRedstoneSignal, snapshot.directRedstoneSignal);
        }

        public int hashCode() {
            int result = this.analogOutputSignal;
            result = 31 * result + Arrays.hashCode(this.redstoneSignal);
            result = 31 * result + Arrays.hashCode(this.directRedstoneSignal);
            return result;
        }
    }
}

