/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import moe.plushie.armourers_workshop.compatibility.client.AbstractColorBufferObject;
import moe.plushie.armourers_workshop.compatibility.client.AbstractLightBufferObject;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.client.other.VertexBufferObject;
import moe.plushie.armourers_workshop.core.client.other.VertexIndexObject;
import moe.plushie.armourers_workshop.core.client.shader.Shader;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.math.OpenPoseStack;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL15;

@OnlyIn(value=Dist.CLIENT)
public class AbstractShader
extends Shader {
    private int maxVertexCount;

    @Override
    public void begin() {
        super.begin();
        RenderSystem.enableRescaleNormal();
    }

    @Override
    public void end() {
        RenderSystem.disableRescaleNormal();
        super.end();
    }

    @Override
    protected void prepare(ShaderVertexGroup group) {
        super.prepare(group);
        ((RenderType)group.renderType().get()).func_228547_a_();
        this.maxVertexCount = group.maxVertexCount;
    }

    @Override
    protected void clean(ShaderVertexGroup group) {
        VertexIndexObject.unbind();
        VertexBufferObject.unbind();
        ((RenderType)group.renderType().get()).func_228549_b_();
        super.clean(group);
    }

    @Override
    public void render(ShaderVertexObject object) {
        VertexIndexObject indexObject;
        int count = object.total();
        OpenPoseStack poseStack = object.poseStack();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)AbstractPoseStack.convertMatrix(poseStack.last().pose()));
        RenderSystem.polygonOffset((float)0.0f, (float)(object.polygonOffset() * -1.0f));
        object.bufferObject().bind();
        object.format().setupBufferState(object.offset());
        if (object.isOutline()) {
            AbstractColorBufferObject colorBuffer = AbstractColorBufferObject.getColorBuffer(object.outlineColor() | 0xFF000000);
            colorBuffer.ensureCapacity(this.maxVertexCount);
            colorBuffer.bind();
            colorBuffer.format().setupBufferState(0L);
            object.bufferObject().bind();
        }
        if (!object.isEmissive()) {
            AbstractLightBufferObject lightBuffer = AbstractLightBufferObject.getLightBuffer(object.lightmap());
            lightBuffer.ensureCapacity(this.maxVertexCount);
            lightBuffer.bind();
            lightBuffer.format().setupBufferState(0L);
            object.bufferObject().bind();
        }
        if ((indexObject = object.indexObject()) != null) {
            indexObject.bind();
            GL15.glDrawElements((int)4, (int)indexObject.stride(count), (int)indexObject.type(), (long)0L);
        } else {
            GL15.glDrawArrays((int)4, (int)0, (int)count);
        }
        ((VertexFormat)object.format().get()).func_227895_d_();
        RenderSystem.popMatrix();
    }
}

