/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.builder.other.CubeChanges;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class CubeWrapper
implements IBlockPaintable {
    private final Consumer<CubeChanges> consumer;
    private final World level;
    private BlockPos pos;
    private Supplier<BlockState> state;
    private Supplier<TileEntity> blockEntity;
    private Supplier<IBlockPaintable> target;
    private CubeChanges changes;

    public CubeWrapper(World level, Consumer<CubeChanges> consumer) {
        this.consumer = consumer;
        this.level = level;
    }

    public boolean is(Class<?> clazz) {
        if (Block.class.isAssignableFrom(clazz)) {
            return clazz.isInstance(this.block());
        }
        return clazz.isInstance(this.blockEntity());
    }

    public boolean is(Block block) {
        return this.blockState().func_203425_a(block);
    }

    public Block block() {
        return this.blockState().func_177230_c();
    }

    public BlockState blockState() {
        if (this.state != null) {
            return this.state.get();
        }
        if (this.pos != null) {
            BlockState state = this.level.func_180495_p(this.pos);
            this.state = () -> state;
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void setBlockState(BlockState state) {
        this.lastChanges().setBlockState(state);
    }

    public void setBlockStateAndTag(BlockState state, CompoundNBT nbt) {
        this.lastChanges().setBlockState(state);
        this.lastChanges().setCompoundTag(nbt);
    }

    public void setBlockStateAndColors(BlockState state, Map<OpenDirection, SkinPaintColor> colors) {
        this.lastChanges().setBlockState(state);
        this.lastChanges().setColors(colors);
    }

    @Nullable
    public TileEntity blockEntity() {
        if (this.blockEntity != null) {
            return this.blockEntity.get();
        }
        if (this.pos != null) {
            TileEntity blockEntity = this.level.func_175625_s(this.pos);
            this.blockEntity = () -> blockEntity;
            return blockEntity;
        }
        return null;
    }

    @Nullable
    public CompoundNBT blockTag() {
        TileEntity blockEntity = this.blockEntity();
        if (blockEntity != null) {
            return StorageAPI.saveFullData(blockEntity, this.level.func_241828_r());
        }
        return null;
    }

    @Override
    public SkinPaintColor getColor(OpenDirection direction) {
        IBlockPaintable target = this.target();
        if (target != null) {
            return target.getColor(direction);
        }
        return null;
    }

    @Override
    public void setColor(OpenDirection direction, SkinPaintColor color) {
        this.lastChanges().setColor(direction, color);
    }

    @Override
    public void setColors(Map<OpenDirection, SkinPaintColor> colors) {
        this.lastChanges().setColors(colors);
    }

    @Override
    public boolean shouldChangeColor(OpenDirection direction) {
        IBlockPaintable target = this.target();
        if (target != null) {
            return target.shouldChangeColor(direction);
        }
        return false;
    }

    public BlockPos blockPos() {
        return this.pos;
    }

    public void setBlockPos(BlockPos pos) {
        if (this.pos != pos) {
            this.submit();
        }
        this.pos = pos;
    }

    private IBlockPaintable target() {
        if (this.target != null) {
            return this.target.get();
        }
        IBlockPaintable target = Objects.safeCast(this.blockEntity(), IBlockPaintable.class);
        if (target != null) {
            this.target = () -> target;
            return target;
        }
        return null;
    }

    private CubeChanges lastChanges() {
        if (this.changes == null) {
            this.changes = new CubeChanges(this.level, this.pos);
        }
        return this.changes;
    }

    private void submit() {
        if (this.changes != null) {
            this.consumer.accept(this.changes);
            this.changes = null;
        }
        this.pos = null;
        this.state = null;
        this.blockEntity = null;
        this.target = null;
    }
}

