/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import moe.plushie.armourers_workshop.api.common.ITooltipContext;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockItem;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IPaintProvider;
import moe.plushie.armourers_workshop.core.data.paint.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SkinCubeItem
extends AbstractBlockItem
implements IItemPaintable,
IPaintToolPicker {
    public SkinCubeItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public ActionResultType usePickTool(World level, BlockPos pos, OpenDirection dir, TileEntity blockEntity, ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        if (blockEntity instanceof IPaintProvider) {
            IPaintProvider provider = (IPaintProvider)blockEntity;
            this.setItemColor(itemStack, provider.color());
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    protected boolean func_195943_a(BlockPos pos, World level, @Nullable PlayerEntity player, ItemStack itemStack, BlockState blockState) {
        TileEntity blockEntity = level.func_175625_s(pos);
        CompoundNBT entityTag = (CompoundNBT)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get());
        if (entityTag != null && blockEntity != null) {
            CompoundNBT newNBT = StorageAPI.saveFullData(blockEntity, level.func_241828_r());
            OptionalAPI.getOptionalCompound(entityTag, "Color").ifPresent(color -> newNBT.func_218657_a("Color", (INBT)color));
            StorageAPI.loadFullData(blockEntity, newNBT, level.func_241828_r());
        }
        return super.func_195943_a(pos, level, player, itemStack, blockState);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, List<ITextComponent> tooltips, ITooltipContext context) {
        super.appendHoverText(itemStack, tooltips, context);
        BlockPaintColor paintColor = this.getItemColors(itemStack);
        if (paintColor != null && paintColor.isPureColor()) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor.get(OpenDirection.NORTH), true));
        }
    }

    @Override
    public void setItemColor(ItemStack itemStack, SkinPaintColor paintColor) {
        CompoundNBT entityTag = new CompoundNBT();
        CompoundNBT oldEntityTag = (CompoundNBT)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get());
        if (oldEntityTag != null) {
            entityTag.func_197643_a(oldEntityTag);
        }
        entityTag.func_74778_a("id", TypedRegistry.findKey(this.func_179223_d()).toString());
        BlockPaintColor color = new BlockPaintColor(paintColor);
        TagSerializer serializer = new TagSerializer();
        color.serialize(serializer);
        entityTag.func_218657_a("Color", (INBT)serializer.tag());
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_FLAGS.get(), 1);
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.BLOCK_ENTITY_DATA.get(), entityTag);
    }

    @Override
    public SkinPaintColor getItemColor(ItemStack itemStack) {
        return ComponentAPI.getOrDefault(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), SkinPaintColor.WHITE);
    }

    @Nullable
    public BlockPaintColor getItemColors(ItemStack itemStack) {
        return ColorUtils.getBlockColor(itemStack);
    }
}

