/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.undo.action;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.builder.data.undo.action.BlockUserAction;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SetBlockColorAction
extends BlockUserAction {
    private final Map<OpenDirection, SkinPaintColor> newValue;

    public SetBlockColorAction(World level, BlockPos pos, Map<OpenDirection, SkinPaintColor> newValue) {
        super(level, pos);
        this.newValue = new HashMap<OpenDirection, SkinPaintColor>(newValue);
    }

    @Override
    public IUserAction apply() throws RuntimeException {
        IBlockPaintable target = (IBlockPaintable)this.blockEntity();
        HashMap<OpenDirection, SkinPaintColor> oldValue = new HashMap<OpenDirection, SkinPaintColor>();
        for (OpenDirection direction : this.newValue.keySet()) {
            SkinPaintColor paintColor = target.getColor(direction);
            if (paintColor == null) {
                paintColor = SkinPaintColor.CLEAR;
            }
            oldValue.put(direction, paintColor);
        }
        SetBlockColorAction revertAction = new SetBlockColorAction(this.level, this.blockPos, oldValue);
        target.setColors(this.newValue);
        return revertAction;
    }

    @Override
    public TileEntity blockEntity() {
        TileEntity blockEntity = super.blockEntity();
        if (blockEntity instanceof IBlockPaintable) {
            return blockEntity;
        }
        return null;
    }
}

