/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.data.palette;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import moe.plushie.armourers_workshop.builder.data.palette.Palette;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import org.jetbrains.annotations.Nullable;

public class PaletteManager {
    private static final PaletteManager INSTANCE = new PaletteManager();
    private final File paletteFile;
    private final LinkedHashMap<String, Palette> paletteMap = new LinkedHashMap();
    private boolean dirty = false;
    private Palette currentPalette = null;

    public PaletteManager() {
        this.paletteFile = new File(EnvironmentManager.getRootDirectory(), "palettes.json");
        if (this.paletteFile.exists()) {
            this.loadPalettes();
        } else {
            this.createDefaultPalettes();
            this.savePalettes();
        }
    }

    public static PaletteManager getInstance() {
        return INSTANCE;
    }

    public void createDefaultPalettes() {
        ModLog.debug("Creating default palettes.", new Object[0]);
        this.putPaletteInMap(new Palette("\u2606 Minecraft", true, ColorUtils.PALETTE_MINECRAFT));
        this.putPaletteInMap(new Palette("\u2606 Shades", true, ColorUtils.PALETTE_SHADES));
        this.putPaletteInMap(new Palette("\u2606 Warm32", true, ColorUtils.PALETTE_WARM32));
        this.putPaletteInMap(new Palette("\u2606 Pastel-64 A", true, ColorUtils.PALETTE_PASTEL_64_A));
        this.putPaletteInMap(new Palette("\u2606 Pastel-64 B", true, ColorUtils.PALETTE_PASTEL_64_B));
        this.putPaletteInMap(new Palette("\u2606 SoftMilk32", true, ColorUtils.PALETTE_SOFTMILK32));
        this.putPaletteInMap(new Palette("\u2606 Endesga 32", true, ColorUtils.PALETTE_ENDESGA_32));
    }

    private void putPaletteInMap(Palette palette) {
        this.paletteMap.put(palette.name(), palette);
    }

    public Palette paletteByName(String name) {
        return this.paletteMap.get(name);
    }

    public Collection<Palette> palettes() {
        return this.paletteMap.values();
    }

    public void setCurrentPalette(@Nullable Palette palette) {
        this.currentPalette = palette;
    }

    @Nullable
    public Palette currentPalette() {
        return this.currentPalette;
    }

    public void deletePalette(String paletteName) {
        this.paletteMap.remove(paletteName);
        this.markDirty();
    }

    public Palette addPalette(String paletteName) {
        Palette palette = new Palette(paletteName);
        this.paletteMap.put(paletteName, palette);
        this.markDirty();
        return palette;
    }

    public void renamePalette(String oldName, String newName) {
        if (oldName.equals(newName)) {
            return;
        }
        Palette palette = this.paletteByName(oldName);
        palette.setName(newName);
        this.paletteMap.put(newName, palette);
        this.paletteMap.remove(oldName);
        this.markDirty();
    }

    public void save() {
        if (this.dirty) {
            this.savePalettes();
            this.dirty = false;
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void savePalettes() {
        ModLog.info("Saving palettes.", new Object[0]);
        JsonArray json = new JsonArray();
        for (Palette palette : this.paletteMap.values()) {
            JsonObject jsonPalette = new JsonObject();
            jsonPalette.addProperty("name", palette.name());
            jsonPalette.addProperty("locked", Boolean.valueOf(palette.isLocked()));
            jsonPalette.add("colours", (JsonElement)this.intToJsonArray(palette.colors()));
            json.add((JsonElement)jsonPalette);
        }
        try {
            FileUtils.forceMkdirParent(this.paletteFile);
            FileOutputStream outputStream = new FileOutputStream(this.paletteFile, false);
            String text = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
            byte[] data = text.getBytes(StandardCharsets.UTF_8);
            outputStream.write(data);
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadPalettes() {
        ModLog.info("Loading palettes.", new Object[0]);
        try {
            this.paletteMap.clear();
            String text = StreamUtils.readFileToString(this.paletteFile, StandardCharsets.UTF_8);
            JsonArray json = new JsonParser().parse(text).getAsJsonArray();
            for (int i = 0; i < json.size(); ++i) {
                JsonObject jsonPalette = json.get(i).getAsJsonObject();
                if (!(jsonPalette.has("name") & jsonPalette.has("colours"))) continue;
                String name = jsonPalette.get("name").getAsString();
                boolean locked = jsonPalette.get("locked").getAsBoolean();
                int[] colors = this.jsonToIntArray(jsonPalette.get("colours").getAsJsonArray());
                Palette palette = new Palette(name, locked, colors);
                this.paletteMap.put(palette.name(), palette);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.createDefaultPalettes();
            this.savePalettes();
        }
    }

    private JsonArray intToJsonArray(int[] intArray) {
        JsonArray jsonArray = new JsonArray();
        for (int color : intArray) {
            jsonArray.add(this.colorToHex(color));
        }
        return jsonArray;
    }

    private int[] jsonToIntArray(JsonArray jsonArray) {
        int[] intArray = new int[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            String colorHex = jsonArray.get(i).getAsString();
            if (!this.isValidHex(colorHex)) continue;
            intArray[i] = Integer.decode(colorHex);
        }
        return intArray;
    }

    private boolean isValidHex(String colorStr) {
        if (colorStr.isEmpty()) {
            return false;
        }
        String hexPatten = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
        Pattern pattern = Pattern.compile(hexPatten);
        Matcher matcher = pattern.matcher(colorStr);
        return matcher.matches();
    }

    private String colorToHex(int c) {
        if (c == 0) {
            return "";
        }
        return String.format("#%06x", c);
    }
}

