/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.block;

import moe.plushie.armourers_workshop.api.common.IBlockEntityType;
import moe.plushie.armourers_workshop.api.common.IBlockHandler;
import moe.plushie.armourers_workshop.builder.blockentity.BoundingBoxBlockEntity;
import moe.plushie.armourers_workshop.compatibility.core.AbstractBlockEntityProvider;
import moe.plushie.armourers_workshop.init.ModBlockEntityTypes;
import moe.plushie.armourers_workshop.init.ModDebugger;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class BoundingBoxBlock
extends Block
implements AbstractBlockEntityProvider,
IBlockHandler {
    public BoundingBoxBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public TileEntity createBlockEntity(IBlockReader level, BlockPos blockPos, BlockState blockState) {
        return ((IBlockEntityType)ModBlockEntityTypes.BOUNDING_BOX.get()).create(level, blockPos, blockState);
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public void func_180633_a(World level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        level.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 11);
    }

    @Override
    public ActionResultType attackBlock(World level, BlockPos blockPos, BlockState blockState, Direction direction, PlayerEntity player, Hand hand) {
        BoundingBoxBlockEntity blockEntity;
        TileEntity tileEntity = level.func_175625_s(blockPos);
        if (tileEntity instanceof BoundingBoxBlockEntity && (blockEntity = (BoundingBoxBlockEntity)tileEntity).isValid() && blockEntity.hasColors()) {
            blockEntity.clearArmourerTextureColors();
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        return ActionResultType.FAIL;
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos, ISelectionContext collisionContext) {
        BoundingBoxBlockEntity blockEntity;
        TileEntity tileEntity = blockGetter.func_175625_s(blockPos);
        if (tileEntity instanceof BoundingBoxBlockEntity && (blockEntity = (BoundingBoxBlockEntity)tileEntity).isValid()) {
            return VoxelShapes.func_197868_b();
        }
        return VoxelShapes.func_197880_a();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        if (ModDebugger.boundingBox) {
            return BlockRenderType.MODEL;
        }
        return BlockRenderType.INVISIBLE;
    }
}

