/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Arrays;
import java.util.List;

public class RenderStateManager {
    private static boolean cacheEnabled;
    private static final ean[] PENDING_CLEAR_STATES;

    public static void setupRenderStates(List<ean> renderStates) {
        if (cacheEnabled) {
            RenderStateManager.setupCached(renderStates);
            return;
        }
        renderStates.forEach(ean::a);
    }

    public static void clearRenderStates(List<ean> renderStates) {
        if (cacheEnabled) {
            RenderStateManager.clearCached(renderStates);
            return;
        }
        renderStates.forEach(ean::b);
    }

    private static void setupCached(List<ean> renderStates) {
        for (int i2 = 0; i2 < renderStates.size(); ++i2) {
            ean state = renderStates.get(i2);
            RenderStateManager.setupCached(state, i2);
        }
    }

    private static void clearCached(List<ean> renderStates) {
        for (int i2 = 0; i2 < renderStates.size(); ++i2) {
            ean state = renderStates.get(i2);
            RenderStateManager.clearCached(state, i2);
        }
    }

    private static void setupCached(ean state, int index) {
        ean pendingClearState = PENDING_CLEAR_STATES[index];
        if (pendingClearState != null) {
            if (state == pendingClearState) {
                RenderStateManager.PENDING_CLEAR_STATES[index] = null;
                return;
            }
            pendingClearState.b();
            RenderStateManager.PENDING_CLEAR_STATES[index] = null;
        }
        state.a();
    }

    private static void clearCached(ean state, int index) {
        ean pendingClearState = PENDING_CLEAR_STATES[index];
        if (pendingClearState != null) {
            pendingClearState.b();
        }
        RenderStateManager.PENDING_CLEAR_STATES[index] = state;
    }

    public static void enableCache() {
        if (cacheEnabled) {
            return;
        }
        cacheEnabled = true;
        Arrays.fill(PENDING_CLEAR_STATES, null);
    }

    public static void disableCache() {
        if (!cacheEnabled) {
            return;
        }
        cacheEnabled = false;
        for (int i2 = 0; i2 < PENDING_CLEAR_STATES.length; ++i2) {
            ean pendingClearState = PENDING_CLEAR_STATES[i2];
            if (pendingClearState == null) continue;
            pendingClearState.b();
        }
        Arrays.fill(PENDING_CLEAR_STATES, null);
    }

    static {
        PENDING_CLEAR_STATES = new ean[eao.getCountRenderStates()];
    }
}

