/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private aqa entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<fx> setLitChunkPos = new HashSet<fx>();
    private fx.a blockPosMutable = new fx.a();

    public DynamicLight(aqa entity) {
        this.entity = entity;
        this.offsetY = entity.ce();
    }

    public void update(eae renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.cD() - 0.5;
        double posY = this.entity.cE() - 0.5 + this.offsetY;
        double posZ = this.entity.cH() - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet<fx> setNewPos = new HashSet<fx>();
        if (lightLevel > 0) {
            gc dirX = (afm.c(posX) & 0xF) >= 8 ? gc.f : gc.e;
            gc dirY = (afm.c(posY) & 0xF) >= 8 ? gc.b : gc.a;
            gc dirZ = (afm.c(posZ) & 0xF) >= 8 ? gc.d : gc.c;
            fx chunkPos = new fx(posX, posY, posZ);
            ecu.c chunk = renderGlobal.getRenderChunk(chunkPos);
            fx chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            ecu.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            fx chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            ecu.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            fx chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            ecu.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            fx chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            ecu.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            fx chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            ecu.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            fx chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            ecu.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            fx chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            ecu.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private fx getChunkPos(ecu.c renderChunk, fx pos, gc facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(ecu.c renderChunk, Set<fx> setPrevPos, Set<fx> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        ecu.b compiledChunk = renderChunk.c();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        fx pos = renderChunk.e().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(eae renderGlobal) {
        for (fx posOld : this.setLitChunkPos) {
            ecu.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public aqa getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

