/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.concurrent;

import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.concurrent.ITaskExecutor;
import net.optifine.Config;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ThreadTaskExecutor<R extends Runnable>
implements ITaskExecutor<R>,
Executor {
    private final String field_213171_b;
    private static final Logger field_213172_c = LogManager.getLogger();
    private final Queue<R> field_213173_d = Queues.newConcurrentLinkedQueue();
    private int field_213174_e;

    protected ThreadTaskExecutor(String nameIn) {
        this.field_213171_b = nameIn;
    }

    protected abstract R func_212875_d_(Runnable var1);

    protected abstract boolean func_212874_c_(R var1);

    public boolean func_213162_bc() {
        return Thread.currentThread() == this.func_213170_ax();
    }

    protected abstract Thread func_213170_ax();

    protected boolean func_213164_aw() {
        return !this.func_213162_bc();
    }

    public int func_223704_be() {
        return this.field_213173_d.size();
    }

    public String func_213142_bd() {
        return this.field_213171_b;
    }

    public <V> CompletableFuture<V> func_213169_a(Supplier<V> supplier) {
        return this.func_213164_aw() ? CompletableFuture.supplyAsync(supplier, (Executor)this) : CompletableFuture.completedFuture(supplier.get());
    }

    private CompletableFuture<Void> func_213165_a(Runnable taskIn) {
        return CompletableFuture.supplyAsync(() -> {
            taskIn.run();
            return null;
        }, (Executor)this);
    }

    public CompletableFuture<Void> func_222817_e(Runnable taskIn) {
        if (this.func_213164_aw()) {
            return this.func_213165_a(taskIn);
        }
        taskIn.run();
        return CompletableFuture.completedFuture(null);
    }

    public void func_213167_f(Runnable taskIn) {
        if (!this.func_213162_bc()) {
            this.func_213165_a(taskIn).join();
        } else {
            taskIn.run();
        }
    }

    public void func_212871_a_(R taskIn) {
        this.field_213173_d.add(taskIn);
        LockSupport.unpark(this.func_213170_ax());
    }

    @Override
    public void execute(Runnable p_execute_1_) {
        if (this.func_213164_aw()) {
            this.func_212871_a_(this.func_212875_d_(p_execute_1_));
        } else {
            p_execute_1_.run();
        }
    }

    protected void func_213159_be() {
        this.field_213173_d.clear();
    }

    protected void func_213160_bf() {
        int count = Integer.MAX_VALUE;
        if (Config.isLazyChunkLoading() && this == Minecraft.func_71410_x()) {
            int queueSize = this.func_223704_be();
            int fps = Math.max(Config.getFpsAverage(), 1);
            count = Math.max(queueSize * 10 / fps, 1);
            count = Math.min(count, queueSize);
        }
        while (this.func_213168_p() && --count > 0) {
        }
    }

    protected boolean func_213168_p() {
        Runnable r2 = (Runnable)this.field_213173_d.peek();
        if (r2 == null) {
            return false;
        }
        if (this.field_213174_e == 0 && !this.func_212874_c_(r2)) {
            return false;
        }
        this.func_213166_h((Runnable)this.field_213173_d.remove());
        return true;
    }

    public void func_213161_c(BooleanSupplier isDone) {
        ++this.field_213174_e;
        try {
            while (!isDone.getAsBoolean()) {
                if (this.func_213168_p()) continue;
                this.func_223705_bi();
            }
        }
        finally {
            --this.field_213174_e;
        }
    }

    protected void func_223705_bi() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void func_213166_h(R taskIn) {
        block2: {
            try {
                taskIn.run();
            }
            catch (Exception exception) {
                field_213172_c.fatal("Error executing task on {}", (Object)this.func_213142_bd(), (Object)exception);
                if (!(exception.getCause() instanceof OutOfMemoryError)) break block2;
                OutOfMemoryError oome = (OutOfMemoryError)exception.getCause();
                throw oome;
            }
        }
    }
}

