/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.tileentity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IPosition;
import net.minecraft.tileentity.EndPortalTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.optifine.Config;
import net.optifine.shaders.ShadersRender;

public class EndPortalTileEntityRenderer<T extends EndPortalTileEntity>
extends TileEntityRenderer<T> {
    public static final ResourceLocation field_147529_c = new ResourceLocation("textures/environment/end_sky.png");
    public static final ResourceLocation field_147526_d = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random field_147527_e = new Random(31100L);
    private static final List<RenderType> field_228881_e_ = (List)IntStream.range(0, 16).mapToObj(p_228882_0_ -> RenderType.func_228630_a_((int)(p_228882_0_ + 1))).collect(ImmutableList.toImmutableList());

    public EndPortalTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void func_225616_a_(T tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (Config.isShaders() && ShadersRender.renderEndPortal(tileEntityIn, (float)partialTicks, (float)this.func_191287_c(), (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn)) {
            return;
        }
        field_147527_e.setSeed(31100L);
        double d0 = tileEntityIn.func_174877_v().func_218138_a((IPosition)this.field_228858_b_.field_217666_g.func_216785_c(), true);
        int i2 = this.func_191286_a(d0);
        float f2 = this.func_191287_c();
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        this.func_228883_a_(tileEntityIn, f2, 0.15f, matrix4f, bufferIn.getBuffer((RenderType)field_228881_e_.get(0)));
        for (int j2 = 1; j2 < i2; ++j2) {
            this.func_228883_a_(tileEntityIn, f2, 2.0f / (float)(18 - j2), matrix4f, bufferIn.getBuffer((RenderType)field_228881_e_.get(j2)));
        }
    }

    private void func_228883_a_(T tileEntityIn, float p_228883_2_, float p_228883_3_, Matrix4f p_228883_4_, IVertexBuilder p_228883_5_) {
        float f2 = (field_147527_e.nextFloat() * 0.5f + 0.1f) * p_228883_3_;
        float f1 = (field_147527_e.nextFloat() * 0.5f + 0.4f) * p_228883_3_;
        float f22 = (field_147527_e.nextFloat() * 0.5f + 0.5f) * p_228883_3_;
        this.func_228884_a_(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, f2, f1, f22, Direction.SOUTH);
        this.func_228884_a_(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f2, f1, f22, Direction.NORTH);
        this.func_228884_a_(tileEntityIn, p_228883_4_, p_228883_5_, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, f2, f1, f22, Direction.EAST);
        this.func_228884_a_(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, f2, f1, f22, Direction.WEST);
        this.func_228884_a_(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f2, f1, f22, Direction.DOWN);
        this.func_228884_a_(tileEntityIn, p_228883_4_, p_228883_5_, 0.0f, 1.0f, p_228883_2_, p_228883_2_, 1.0f, 1.0f, 0.0f, 0.0f, f2, f1, f22, Direction.UP);
    }

    private void func_228884_a_(T tileEntityIn, Matrix4f p_228884_2_, IVertexBuilder p_228884_3_, float p_228884_4_, float p_228884_5_, float p_228884_6_, float p_228884_7_, float p_228884_8_, float p_228884_9_, float p_228884_10_, float p_228884_11_, float p_228884_12_, float p_228884_13_, float p_228884_14_, Direction p_228884_15_) {
        if (tileEntityIn.func_184313_a(p_228884_15_)) {
            p_228884_3_.func_227888_a_(p_228884_2_, p_228884_4_, p_228884_6_, p_228884_8_).func_227885_a_(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).func_181675_d();
            p_228884_3_.func_227888_a_(p_228884_2_, p_228884_5_, p_228884_6_, p_228884_9_).func_227885_a_(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).func_181675_d();
            p_228884_3_.func_227888_a_(p_228884_2_, p_228884_5_, p_228884_7_, p_228884_10_).func_227885_a_(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).func_181675_d();
            p_228884_3_.func_227888_a_(p_228884_2_, p_228884_4_, p_228884_7_, p_228884_11_).func_227885_a_(p_228884_12_, p_228884_13_, p_228884_14_, 1.0f).func_181675_d();
        }
    }

    protected int func_191286_a(double p_191286_1_) {
        if (p_191286_1_ > 36864.0) {
            return 1;
        }
        if (p_191286_1_ > 25600.0) {
            return 3;
        }
        if (p_191286_1_ > 16384.0) {
            return 5;
        }
        if (p_191286_1_ > 9216.0) {
            return 7;
        }
        if (p_191286_1_ > 4096.0) {
            return 9;
        }
        if (p_191286_1_ > 1024.0) {
            return 11;
        }
        if (p_191286_1_ > 576.0) {
            return 13;
        }
        return p_191286_1_ > 256.0 ? 14 : 15;
    }

    protected float func_191287_c() {
        return 0.75f;
    }
}

