/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.optifine.Config;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.ShadersTex;

public abstract class Texture
implements AutoCloseable {
    protected int field_110553_a = -1;
    protected boolean field_174940_b;
    protected boolean field_174941_c;
    public MultiTexID multiTex;
    private boolean blurMipmapSet;
    private boolean lastBlur;
    private boolean lastMipmap;

    public void func_174937_a(boolean blurIn, boolean mipmapIn) {
        int j2;
        int i2;
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (this.blurMipmapSet && this.field_174940_b == blurIn && this.field_174941_c == mipmapIn) {
            return;
        }
        this.blurMipmapSet = true;
        this.field_174940_b = blurIn;
        this.field_174941_c = mipmapIn;
        if (blurIn) {
            i2 = mipmapIn ? 9987 : 9729;
            j2 = 9729;
        } else {
            int mipmapType = Config.getMipmapType();
            i2 = mipmapIn ? mipmapType : 9728;
            j2 = 9728;
        }
        GlStateManager.func_227760_t_((int)this.func_110552_b());
        GlStateManager.func_227677_b_((int)3553, (int)10241, (int)i2);
        GlStateManager.func_227677_b_((int)3553, (int)10240, (int)j2);
    }

    public int func_110552_b() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (this.field_110553_a == -1) {
            this.field_110553_a = TextureUtil.func_225678_a_();
        }
        return this.field_110553_a;
    }

    public void func_147631_c() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> {
                ShadersTex.deleteTextures((Texture)this, (int)this.field_110553_a);
                this.blurMipmapSet = false;
                if (this.field_110553_a != -1) {
                    TextureUtil.func_225679_a_((int)this.field_110553_a);
                    this.field_110553_a = -1;
                }
            });
        } else if (this.field_110553_a != -1) {
            ShadersTex.deleteTextures((Texture)this, (int)this.field_110553_a);
            this.blurMipmapSet = false;
            TextureUtil.func_225679_a_((int)this.field_110553_a);
            this.field_110553_a = -1;
        }
    }

    public abstract void func_195413_a(IResourceManager var1) throws IOException;

    public void func_229148_d_() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GlStateManager.func_227760_t_((int)this.func_110552_b()));
        } else {
            GlStateManager.func_227760_t_((int)this.func_110552_b());
        }
    }

    public void func_215244_a(TextureManager textureManagerIn, IResourceManager resourceManagerIn, ResourceLocation resourceLocationIn, Executor executorIn) {
        textureManagerIn.func_229263_a_(resourceLocationIn, this);
    }

    @Override
    public void close() {
    }

    public MultiTexID getMultiTexID() {
        return ShadersTex.getMultiTexID((Texture)this);
    }

    public void setBlurMipmap(boolean blur, boolean mipmap) {
        this.lastBlur = this.field_174940_b;
        this.lastMipmap = this.field_174941_c;
        this.func_174937_a(blur, mipmap);
    }

    public void restoreLastBlurMipmap() {
        this.func_174937_a(this.lastBlur, this.lastMipmap);
    }
}

