/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.optifine.EmissiveTextures;

public class RenderMaterial {
    private final ResourceLocation field_229307_a_;
    private final ResourceLocation field_229308_b_;
    @Nullable
    private RenderType field_229309_c_;

    public RenderMaterial(ResourceLocation atlasLocationIn, ResourceLocation textureLocationIn) {
        this.field_229307_a_ = atlasLocationIn;
        this.field_229308_b_ = textureLocationIn;
    }

    public ResourceLocation func_229310_a_() {
        return this.field_229307_a_;
    }

    public ResourceLocation func_229313_b_() {
        return this.field_229308_b_;
    }

    public TextureAtlasSprite func_229314_c_() {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(this.func_229310_a_()).apply(this.func_229313_b_());
        if (EmissiveTextures.isActive()) {
            sprite = EmissiveTextures.getEmissiveSprite((TextureAtlasSprite)sprite);
        }
        return sprite;
    }

    public RenderType func_229312_a_(Function<ResourceLocation, RenderType> renderTypeGetter) {
        if (this.field_229309_c_ == null) {
            this.field_229309_c_ = renderTypeGetter.apply(this.field_229307_a_);
        }
        return this.field_229309_c_;
    }

    public IVertexBuilder func_229311_a_(IRenderTypeBuffer bufferIn, Function<ResourceLocation, RenderType> renderTypeGetter) {
        TextureAtlasSprite sprite = this.func_229314_c_();
        RenderType renderType = this.func_229312_a_(renderTypeGetter);
        if (sprite.isSpriteEmissive && renderType.isEntitySolid()) {
            renderType = RenderType.func_228638_b_((ResourceLocation)this.field_229307_a_);
        }
        return sprite.func_229230_a_(bufferIn.getBuffer(renderType));
    }

    public IVertexBuilder func_241742_a_(IRenderTypeBuffer bufferIn, Function<ResourceLocation, RenderType> renderTypeGetter, boolean hasEffectIn) {
        return this.func_229314_c_().func_229230_a_(ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)this.func_229312_a_(renderTypeGetter), (boolean)true, (boolean)hasEffectIn));
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            RenderMaterial rendermaterial = (RenderMaterial)p_equals_1_;
            return this.field_229307_a_.equals((Object)rendermaterial.field_229307_a_) && this.field_229308_b_.equals((Object)rendermaterial.field_229308_b_);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.field_229307_a_, this.field_229308_b_);
    }

    public String toString() {
        return "Material{atlasLocation=" + this.field_229307_a_ + ", texture=" + this.field_229308_b_ + '}';
    }
}

