/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.CustomItems;
import net.optifine.EmissiveTextures;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemRenderer
implements IResourceManagerReloadListener {
    public static final ResourceLocation field_110798_h = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Set<Item> field_195411_c = Sets.newHashSet((Object[])new Item[]{Items.field_190931_a});
    public float field_77023_b;
    private final ItemModelMesher field_175059_m;
    private final TextureManager field_175057_n;
    private final ItemColors field_184395_f;
    public ModelManager modelManager = null;
    private static boolean renderItemGui = false;

    public ItemRenderer(TextureManager textureManagerIn, ModelManager modelManagerIn, ItemColors itemColorsIn) {
        this.field_175057_n = textureManagerIn;
        this.modelManager = modelManagerIn;
        this.field_175059_m = Reflector.ItemModelMesherForge_Constructor.exists() ? (ItemModelMesher)Reflector.newInstance(Reflector.ItemModelMesherForge_Constructor, this.modelManager) : new ItemModelMesher(modelManagerIn);
        for (Item item : Registry.field_212630_s) {
            if (field_195411_c.contains(item)) continue;
            this.field_175059_m.func_199311_a(item, new ModelResourceLocation(Registry.field_212630_s.func_177774_c((Object)item), "inventory"));
        }
        this.field_184395_f = itemColorsIn;
    }

    public ItemModelMesher func_175037_a() {
        return this.field_175059_m;
    }

    public void func_229114_a_(IBakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IVertexBuilder bufferIn) {
        if (Config.isMultiTexture()) {
            bufferIn.setRenderBlocks(true);
        }
        Random random = new Random();
        long i2 = 42L;
        for (Direction direction : Direction.field_199792_n) {
            random.setSeed(42L);
            this.func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        this.func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn);
    }

    public void func_229111_a_(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn) {
        if (!itemStackIn.func_190926_b()) {
            boolean flag;
            matrixStackIn.func_227860_a_();
            boolean bl = flag = transformTypeIn == ItemCameraTransforms.TransformType.GUI || transformTypeIn == ItemCameraTransforms.TransformType.GROUND || transformTypeIn == ItemCameraTransforms.TransformType.FIXED;
            if (itemStackIn.func_77973_b() == Items.field_203184_eO && flag) {
                modelIn = this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            if (Reflector.ForgeHooksClient_handleCameraTransforms.exists()) {
                modelIn = (IBakedModel)Reflector.ForgeHooksClient_handleCameraTransforms.call(matrixStackIn, modelIn, transformTypeIn, leftHand);
            } else {
                modelIn.func_177552_f().func_181688_b(transformTypeIn).func_228830_a_(leftHand, matrixStackIn);
            }
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (!modelIn.func_188618_c() && (itemStackIn.func_77973_b() != Items.field_203184_eO || flag)) {
                Block block;
                boolean flag1 = transformTypeIn != ItemCameraTransforms.TransformType.GUI && !transformTypeIn.func_241716_a_() && itemStackIn.func_77973_b() instanceof BlockItem ? !((block = ((BlockItem)itemStackIn.func_77973_b()).func_179223_d()) instanceof BreakableBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                if (modelIn.isLayered()) {
                    Reflector.ForgeHooksClient_drawItemLayered.call(this, modelIn, itemStackIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, flag1);
                } else {
                    IVertexBuilder ivertexbuilder;
                    RenderType rendertype = RenderTypeLookup.func_239219_a_((ItemStack)itemStackIn, (boolean)flag1);
                    if (itemStackIn.func_77973_b() == Items.field_151111_aL && itemStackIn.func_77962_s()) {
                        matrixStackIn.func_227860_a_();
                        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
                        if (transformTypeIn == ItemCameraTransforms.TransformType.GUI) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.5f);
                        } else if (transformTypeIn.func_241716_a_()) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.75f);
                        }
                        ivertexbuilder = flag1 ? ItemRenderer.func_241732_b_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (MatrixStack.Entry)matrixstack$entry) : ItemRenderer.func_241731_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (MatrixStack.Entry)matrixstack$entry);
                        matrixStackIn.func_227865_b_();
                    } else {
                        ivertexbuilder = flag1 ? ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s()) : ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s());
                    }
                    if (Config.isCustomItems()) {
                        modelIn = CustomItems.getCustomItemModel((ItemStack)itemStackIn, (IBakedModel)modelIn, (ResourceLocation)ItemOverrideList.lastModelLocation, (boolean)false);
                        ItemOverrideList.lastModelLocation = null;
                    }
                    if (EmissiveTextures.isActive()) {
                        EmissiveTextures.beginRender();
                    }
                    this.func_229114_a_(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
                    if (EmissiveTextures.isActive()) {
                        if (EmissiveTextures.hasEmissive()) {
                            EmissiveTextures.beginRenderEmissive();
                            ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)false);
                            this.func_229114_a_(modelIn, itemStackIn, LightTexture.MAX_BRIGHTNESS, combinedOverlayIn, matrixStackIn, ivertexbuilder);
                            EmissiveTextures.endRenderEmissive();
                        }
                        EmissiveTextures.endRender();
                    }
                }
            } else if (Reflector.IForgeItem_getItemStackTileEntityRenderer.exists()) {
                ItemStackTileEntityRenderer teisr = (ItemStackTileEntityRenderer)Reflector.call(itemStackIn.func_77973_b(), Reflector.IForgeItem_getItemStackTileEntityRenderer, new Object[0]);
                teisr.func_239207_a_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            } else {
                ItemStackTileEntityRenderer.field_147719_a.func_239207_a_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    public static IVertexBuilder func_239386_a_(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean hasEffectIn) {
        if (Shaders.isShadowPass) {
            hasEffectIn = false;
        }
        if (EmissiveTextures.isRenderEmissive()) {
            hasEffectIn = false;
        }
        return hasEffectIn ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)bufferIn.getBuffer(isItemIn ? RenderType.func_239270_k_() : RenderType.func_239271_l_()), (IVertexBuilder)bufferIn.getBuffer(renderTypeIn)) : bufferIn.getBuffer(renderTypeIn);
    }

    public static IVertexBuilder func_241731_a_(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, MatrixStack.Entry entryIn) {
        return VertexBuilderUtils.func_227915_a_((IVertexBuilder)new MatrixApplyingVertexBuilder(bufferIn.getBuffer(RenderType.func_228653_j_()), entryIn.func_227870_a_(), entryIn.func_227872_b_()), (IVertexBuilder)bufferIn.getBuffer(renderTypeIn));
    }

    public static IVertexBuilder func_241732_b_(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, MatrixStack.Entry entryIn) {
        return VertexBuilderUtils.func_227915_a_((IVertexBuilder)new MatrixApplyingVertexBuilder(bufferIn.getBuffer(RenderType.func_239273_n_()), entryIn.func_227870_a_(), entryIn.func_227872_b_()), (IVertexBuilder)bufferIn.getBuffer(renderTypeIn));
    }

    public static IVertexBuilder func_229113_a_(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean glintIn) {
        if (Shaders.isShadowPass) {
            glintIn = false;
        }
        if (EmissiveTextures.isRenderEmissive()) {
            glintIn = false;
        }
        if (glintIn) {
            return Minecraft.func_238218_y_() && renderTypeIn == Atlases.func_239280_i_() ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)bufferIn.getBuffer(RenderType.func_243501_m()), (IVertexBuilder)bufferIn.getBuffer(renderTypeIn)) : VertexBuilderUtils.func_227915_a_((IVertexBuilder)bufferIn.getBuffer(isItemIn ? RenderType.func_228653_j_() : RenderType.func_228655_k_()), (IVertexBuilder)bufferIn.getBuffer(renderTypeIn));
        }
        return bufferIn.getBuffer(renderTypeIn);
    }

    public static IVertexBuilder func_239391_c_(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean hasEffectIn) {
        if (Shaders.isShadowPass) {
            hasEffectIn = false;
        }
        if (EmissiveTextures.isRenderEmissive()) {
            hasEffectIn = false;
        }
        return hasEffectIn ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)bufferIn.getBuffer(isItemIn ? RenderType.func_239273_n_() : RenderType.func_239274_p_()), (IVertexBuilder)bufferIn.getBuffer(renderTypeIn)) : bufferIn.getBuffer(renderTypeIn);
    }

    private void func_229112_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, ItemStack itemStackIn, int combinedLightIn, int combinedOverlayIn) {
        boolean flag = !itemStackIn.func_190926_b();
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        boolean emissiveActive = EmissiveTextures.isActive();
        int listSize = quadsIn.size();
        for (int ix = 0; ix < listSize; ++ix) {
            BakedQuad bakedquad = quadsIn.get(ix);
            if (emissiveActive && (bakedquad = EmissiveTextures.getEmissiveQuad((BakedQuad)bakedquad)) == null) continue;
            int i2 = -1;
            if (flag && bakedquad.func_178212_b()) {
                i2 = this.field_184395_f.func_186728_a(itemStackIn, bakedquad.func_178211_c());
            }
            float f2 = (float)(i2 >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
            float f22 = (float)(i2 & 0xFF) / 255.0f;
            if (Reflector.ForgeHooksClient.exists()) {
                bufferIn.addVertexData(matrixstack$entry, bakedquad, f2, f1, f22, combinedLightIn, combinedOverlayIn, true);
                continue;
            }
            bufferIn.func_227889_a_(matrixstack$entry, bakedquad, f2, f1, f22, combinedLightIn, combinedOverlayIn);
        }
    }

    public IBakedModel func_184393_a(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entitylivingbaseIn) {
        Item item = stack.func_77973_b();
        IBakedModel ibakedmodel = item == Items.field_203184_eO ? this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory")) : this.field_175059_m.func_178089_a(stack);
        ClientWorld clientworld = worldIn instanceof ClientWorld ? (ClientWorld)worldIn : null;
        ItemOverrideList.lastModelLocation = null;
        IBakedModel ibakedmodel1 = ibakedmodel.func_188617_f().func_239290_a_(ibakedmodel, stack, clientworld, entitylivingbaseIn);
        if (Config.isCustomItems()) {
            ibakedmodel1 = CustomItems.getCustomItemModel((ItemStack)stack, (IBakedModel)ibakedmodel1, (ResourceLocation)ItemOverrideList.lastModelLocation, (boolean)true);
        }
        return ibakedmodel1 == null ? this.field_175059_m.func_178083_a().func_174951_a() : ibakedmodel1;
    }

    public void func_229110_a_(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        this.func_229109_a_((LivingEntity)null, itemStackIn, transformTypeIn, false, matrixStackIn, bufferIn, (World)null, combinedLightIn, combinedOverlayIn);
    }

    public void func_229109_a_(@Nullable LivingEntity livingEntityIn, ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, @Nullable World worldIn, int combinedLightIn, int combinedOverlayIn) {
        if (!itemStackIn.func_190926_b()) {
            IBakedModel ibakedmodel = this.func_184393_a(itemStackIn, worldIn, livingEntityIn);
            this.func_229111_a_(itemStackIn, transformTypeIn, leftHand, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ibakedmodel);
        }
    }

    public void func_175042_a(ItemStack stack, int x2, int y2) {
        this.func_191962_a(stack, x2, y2, this.func_184393_a(stack, (World)null, (LivingEntity)null));
    }

    protected void func_191962_a(ItemStack stack, int x2, int y2, IBakedModel bakedmodel) {
        boolean flag;
        renderItemGui = true;
        RenderSystem.pushMatrix();
        this.field_175057_n.func_110577_a(AtlasTexture.field_110575_b);
        this.field_175057_n.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)x2, (float)y2, (float)(100.0f + this.field_77023_b));
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !bakedmodel.func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        this.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
        renderItemGui = false;
    }

    public void func_180450_b(ItemStack stack, int xPosition, int yPosition) {
        this.func_239387_b_((LivingEntity)Minecraft.func_71410_x().field_71439_g, stack, xPosition, yPosition);
    }

    public void func_239390_c_(ItemStack itemIn, int x2, int y2) {
        this.func_239387_b_((LivingEntity)null, itemIn, x2, y2);
    }

    public void func_184391_a(LivingEntity entityIn, ItemStack itemIn, int x2, int y2) {
        this.func_239387_b_(entityIn, itemIn, x2, y2);
    }

    private void func_239387_b_(@Nullable LivingEntity entityIn, ItemStack itemIn, int x2, int y2) {
        if (!itemIn.func_190926_b()) {
            this.field_77023_b += 50.0f;
            try {
                this.func_191962_a(itemIn, x2, y2, this.func_184393_a(itemIn, (World)null, entityIn));
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Item being rendered");
                crashreportcategory.func_189529_a("Item Type", () -> String.valueOf(itemIn.func_77973_b()));
                crashreportcategory.func_189529_a("Registry Name", () -> String.valueOf(Reflector.call(itemIn.func_77973_b(), Reflector.ForgeRegistryEntry_getRegistryName, new Object[0])));
                crashreportcategory.func_189529_a("Item Damage", () -> String.valueOf(itemIn.func_77952_i()));
                crashreportcategory.func_189529_a("Item NBT", () -> String.valueOf(itemIn.func_77978_p()));
                crashreportcategory.func_189529_a("Item Foil", () -> String.valueOf(itemIn.func_77962_s()));
                throw new ReportedException(crashreport);
            }
            this.field_77023_b -= 50.0f;
        }
    }

    public void func_175030_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition) {
        this.func_180453_a(fr, stack, xPosition, yPosition, (String)null);
    }

    public void func_180453_a(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            MatrixStack matrixstack = new MatrixStack();
            if (stack.func_190916_E() != 1 || text != null) {
                String s2 = text == null ? String.valueOf(stack.func_190916_E()) : text;
                matrixstack.func_227861_a_(0.0, 0.0, (double)(this.field_77023_b + 200.0f));
                IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                fr.func_228079_a_(s2, (float)(xPosition + 19 - 2 - fr.func_78256_a(s2)), (float)(yPosition + 6 + 3), 0xFFFFFF, true, matrixstack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
                irendertypebuffer$impl.func_228461_a_();
            }
            if (ReflectorForge.isItemDamaged((ItemStack)stack)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                float f2 = stack.func_77952_i();
                float f1 = stack.func_77958_k();
                float f22 = Math.max(0.0f, (f1 - f2) / f1);
                int i2 = Math.round(13.0f - f2 * 13.0f / f1);
                int j2 = MathHelper.func_181758_c((float)(f22 / 3.0f), (float)1.0f, (float)1.0f);
                if (Reflector.IForgeItem_getDurabilityForDisplay.exists() && Reflector.IForgeItem_getRGBDurabilityForDisplay.exists()) {
                    double health = Reflector.callDouble(stack.func_77973_b(), Reflector.IForgeItem_getDurabilityForDisplay, stack);
                    int rgbfordisplay = Reflector.callInt(stack.func_77973_b(), Reflector.IForgeItem_getRGBDurabilityForDisplay, stack);
                    i2 = Math.round(13.0f - (float)health * 13.0f);
                    j2 = rgbfordisplay;
                }
                if (Config.isCustomColors()) {
                    j2 = CustomColors.getDurabilityColor(f22, j2);
                }
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                this.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 13, i2, 1, j2 >> 16 & 0xFF, j2 >> 8 & 0xFF, j2 & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f4 = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                this.func_181565_a(bufferbuilder1, xPosition, yPosition + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private void func_181565_a(BufferBuilder renderer, int x2, int y2, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_225582_a_((double)(x2 + 0), (double)(y2 + 0), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x2 + 0), (double)(y2 + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x2 + width), (double)(y2 + height), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_225582_a_((double)(x2 + width), (double)(y2 + 0), 0.0).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public void func_195410_a(IResourceManager resourceManager) {
        this.field_175059_m.func_178085_b();
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

