/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import net.optifine.reflect.Reflector;

public class BlockRendererDispatcher
implements IResourceManagerReloadListener {
    private final BlockModelShapes field_175028_a;
    private final BlockModelRenderer field_175027_c;
    private final FluidBlockRenderer field_175025_e;
    private final Random field_195476_e = new Random();
    private final BlockColors field_228790_e_;

    public BlockRendererDispatcher(BlockModelShapes shapes, BlockColors colors) {
        this.field_175028_a = shapes;
        this.field_228790_e_ = colors;
        this.field_175027_c = Reflector.ForgeBlockModelRenderer_Constructor.exists() ? (BlockModelRenderer)Reflector.newInstance(Reflector.ForgeBlockModelRenderer_Constructor, this.field_228790_e_) : new BlockModelRenderer(this.field_228790_e_);
        this.field_175025_e = new FluidBlockRenderer();
    }

    public BlockModelShapes func_175023_a() {
        return this.field_175028_a;
    }

    public void func_228792_a_(BlockState blockStateIn, BlockPos posIn, IBlockDisplayReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn) {
        this.renderBlockDamage(blockStateIn, posIn, lightReaderIn, matrixStackIn, vertexBuilderIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderBlockDamage(BlockState blockStateIn, BlockPos posIn, IBlockDisplayReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, IModelData modelData) {
        if (blockStateIn.func_185901_i() == BlockRenderType.MODEL) {
            IBakedModel ibakedmodel = this.field_175028_a.func_178125_b(blockStateIn);
            long i2 = blockStateIn.func_209533_a(posIn);
            this.field_175027_c.renderModel(lightReaderIn, ibakedmodel, blockStateIn, posIn, matrixStackIn, vertexBuilderIn, true, this.field_195476_e, i2, OverlayTexture.field_229196_a_, modelData);
        }
    }

    public boolean func_228793_a_(BlockState blockStateIn, BlockPos posIn, IBlockDisplayReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, boolean checkSides, Random rand) {
        return this.renderModel(blockStateIn, posIn, lightReaderIn, matrixStackIn, vertexBuilderIn, checkSides, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModel(BlockState blockStateIn, BlockPos posIn, IBlockDisplayReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, boolean checkSides, Random rand, IModelData modelData) {
        try {
            BlockRenderType blockrendertype = blockStateIn.func_185901_i();
            return blockrendertype != BlockRenderType.MODEL ? false : this.field_175027_c.renderModel(lightReaderIn, this.func_184389_a(blockStateIn), blockStateIn, posIn, matrixStackIn, vertexBuilderIn, checkSides, rand, blockStateIn.func_209533_a(posIn), OverlayTexture.field_229196_a_, modelData);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)posIn, (BlockState)blockStateIn);
            throw new ReportedException(crashreport);
        }
    }

    public boolean func_228794_a_(BlockPos posIn, IBlockDisplayReader lightReaderIn, IVertexBuilder vertexBuilderIn, FluidState fluidStateIn) {
        try {
            return this.field_175025_e.func_228796_a_(lightReaderIn, posIn, vertexBuilderIn, fluidStateIn);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating liquid in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)posIn, (BlockState)null);
            throw new ReportedException(crashreport);
        }
    }

    public BlockModelRenderer func_175019_b() {
        return this.field_175027_c;
    }

    public IBakedModel func_184389_a(BlockState state) {
        return this.field_175028_a.func_178125_b(state);
    }

    public void func_228791_a_(BlockState blockStateIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferTypeIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderBlock(blockStateIn, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderBlock(BlockState blockStateIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferTypeIn, int combinedLightIn, int combinedOverlayIn, IModelData modelData) {
        BlockRenderType blockrendertype = blockStateIn.func_185901_i();
        if (blockrendertype != BlockRenderType.INVISIBLE) {
            switch (1.$SwitchMap$net$minecraft$block$BlockRenderType[blockrendertype.ordinal()]) {
                case 1: {
                    IBakedModel ibakedmodel = this.func_184389_a(blockStateIn);
                    int i2 = this.field_228790_e_.func_228054_a_(blockStateIn, (IBlockDisplayReader)null, (BlockPos)null, 0);
                    float f2 = (float)(i2 >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i2 >> 8 & 0xFF) / 255.0f;
                    float f22 = (float)(i2 & 0xFF) / 255.0f;
                    this.field_175027_c.renderModel(matrixStackIn.func_227866_c_(), bufferTypeIn.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)blockStateIn, (boolean)false)), blockStateIn, ibakedmodel, f2, f1, f22, combinedLightIn, combinedOverlayIn, modelData);
                    break;
                }
                case 2: {
                    if (Reflector.IForgeItem_getItemStackTileEntityRenderer.exists()) {
                        ItemStack stack = new ItemStack((IItemProvider)blockStateIn.func_177230_c());
                        ItemStackTileEntityRenderer teisr = (ItemStackTileEntityRenderer)Reflector.call(stack.func_77973_b(), Reflector.IForgeItem_getItemStackTileEntityRenderer, new Object[0]);
                        teisr.func_239207_a_(stack, ItemCameraTransforms.TransformType.NONE, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn);
                        break;
                    }
                    ItemStackTileEntityRenderer.field_147719_a.func_239207_a_(new ItemStack((IItemProvider)blockStateIn.func_177230_c()), ItemCameraTransforms.TransformType.NONE, matrixStackIn, bufferTypeIn, combinedLightIn, combinedOverlayIn);
                }
            }
        }
    }

    public void func_195410_a(IResourceManager resourceManager) {
        this.field_175025_e.func_178268_a();
    }

    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

