/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.fonts;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.fonts.DefaultGlyph;
import net.minecraft.client.gui.fonts.EmptyGlyph;
import net.minecraft.client.gui.fonts.FontTexture;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.IGlyphInfo;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.gui.fonts.WhiteGlyph;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class Font
implements AutoCloseable {
    private static final EmptyGlyph field_212460_b = new EmptyGlyph();
    private static final IGlyph field_212461_c = () -> 4.0f;
    private static final Random field_212462_d = new Random();
    private final TextureManager field_211191_c;
    private final ResourceLocation field_211192_d;
    private TexturedGlyph field_211572_d;
    private TexturedGlyph field_228156_h_;
    private final List<IGlyphProvider> field_211194_f = Lists.newArrayList();
    private final Int2ObjectMap<TexturedGlyph> field_212463_j = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<IGlyph> field_211195_g = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<IntList> field_211196_h = new Int2ObjectOpenHashMap();
    private final List<FontTexture> field_211197_i = Lists.newArrayList();

    public Font(TextureManager textureManagerIn, ResourceLocation resourceLocationIn) {
        this.field_211191_c = textureManagerIn;
        this.field_211192_d = resourceLocationIn;
    }

    public void func_211570_a(List<IGlyphProvider> glyphProvidersIn) {
        this.func_230154_b_();
        this.func_211571_a();
        this.field_212463_j.clear();
        this.field_211195_g.clear();
        this.field_211196_h.clear();
        this.field_211572_d = this.func_211185_a((IGlyphInfo)DefaultGlyph.INSTANCE);
        this.field_228156_h_ = this.func_211185_a((IGlyphInfo)WhiteGlyph.INSTANCE);
        IntOpenHashSet intset = new IntOpenHashSet();
        for (IGlyphProvider iglyphprovider : glyphProvidersIn) {
            intset.addAll((IntCollection)iglyphprovider.func_230428_a_());
        }
        HashSet set = Sets.newHashSet();
        intset.forEach(p_238558_3_ -> {
            for (IGlyphProvider iglyphprovider1 : glyphProvidersIn) {
                Object iglyph = p_238558_3_ == 32 ? field_212461_c : iglyphprovider1.func_212248_a(p_238558_3_);
                if (iglyph == null) continue;
                set.add(iglyphprovider1);
                if (iglyph == DefaultGlyph.INSTANCE) break;
                ((IntList)this.field_211196_h.computeIfAbsent(MathHelper.func_76123_f((float)iglyph.func_223274_a_(false)), p_238563_0_ -> new IntArrayList())).add(p_238558_3_);
                break;
            }
        });
        glyphProvidersIn.stream().filter(set::contains).forEach(this.field_211194_f::add);
    }

    @Override
    public void close() {
        this.func_230154_b_();
        this.func_211571_a();
    }

    private void func_230154_b_() {
        for (IGlyphProvider iglyphprovider : this.field_211194_f) {
            iglyphprovider.close();
        }
        this.field_211194_f.clear();
    }

    private void func_211571_a() {
        for (FontTexture fonttexture : this.field_211197_i) {
            fonttexture.close();
        }
        this.field_211197_i.clear();
    }

    public IGlyph func_238557_a_(int charIn) {
        Object glyph = (IGlyph)this.field_211195_g.get(charIn);
        if (glyph == null) {
            glyph = charIn == 32 ? field_212461_c : this.func_212455_c(charIn);
            this.field_211195_g.put(charIn, glyph);
        }
        return glyph;
    }

    private IGlyphInfo func_212455_c(int charIn) {
        for (IGlyphProvider iglyphprovider : this.field_211194_f) {
            IGlyphInfo iglyphinfo = iglyphprovider.func_212248_a(charIn);
            if (iglyphinfo == null) continue;
            return iglyphinfo;
        }
        return DefaultGlyph.INSTANCE;
    }

    public TexturedGlyph func_238559_b_(int character) {
        Object texturedGlyph = (TexturedGlyph)this.field_212463_j.get(character);
        if (texturedGlyph == null) {
            texturedGlyph = character == 32 ? field_212460_b : this.func_211185_a(this.func_212455_c(character));
            this.field_212463_j.put(character, texturedGlyph);
        }
        return texturedGlyph;
    }

    private TexturedGlyph func_211185_a(IGlyphInfo glyphInfoIn) {
        for (FontTexture fonttexture : this.field_211197_i) {
            TexturedGlyph texturedglyph = fonttexture.func_211131_a(glyphInfoIn);
            if (texturedglyph == null) continue;
            return texturedglyph;
        }
        FontTexture fonttexture1 = new FontTexture(new ResourceLocation(this.field_211192_d.func_110624_b(), this.field_211192_d.func_110623_a() + "/" + this.field_211197_i.size()), glyphInfoIn.func_211579_f());
        this.field_211197_i.add(fonttexture1);
        this.field_211191_c.func_229263_a_(fonttexture1.func_211132_a(), (Texture)fonttexture1);
        TexturedGlyph texturedglyph1 = fonttexture1.func_211131_a(glyphInfoIn);
        return texturedglyph1 == null ? this.field_211572_d : texturedglyph1;
    }

    public TexturedGlyph func_211188_a(IGlyph glyph) {
        IntList intlist = (IntList)this.field_211196_h.get(MathHelper.func_76123_f((float)glyph.func_223274_a_(false)));
        return intlist != null && !intlist.isEmpty() ? this.func_238559_b_(intlist.getInt(field_212462_d.nextInt(intlist.size()))) : this.field_211572_d;
    }

    public TexturedGlyph func_228157_b_() {
        return this.field_228156_h_;
    }
}

