/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.extensions.IForgeBlockState;
import net.optifine.Config;
import net.optifine.util.BlockUtils;

public class BlockState
extends AbstractBlock.AbstractBlockState
implements IForgeBlockState {
    public static final Codec<BlockState> field_235877_b_ = BlockState.func_235897_a_((Codec)Registry.field_212618_g, Block::func_176223_P).stable();
    private int blockId = -1;
    private int metadata = -1;
    private ResourceLocation blockLocation;
    private int blockStateId = -1;
    private static final AtomicInteger blockStateIdCounter = new AtomicInteger(0);

    public int getBlockId() {
        if (this.blockId < 0) {
            this.blockId = Registry.field_212618_g.func_148757_b((Object)this.func_177230_c());
        }
        return this.blockId;
    }

    public int getMetadata() {
        if (this.metadata < 0) {
            this.metadata = BlockUtils.getMetadata((BlockState)this);
            if (this.metadata < 0) {
                Config.warn("Metadata not found, block: " + this.getBlockLocation());
                this.metadata = 0;
            }
        }
        return this.metadata;
    }

    public ResourceLocation getBlockLocation() {
        if (this.blockLocation == null) {
            this.blockLocation = Registry.field_212618_g.func_177774_c((Object)this.func_177230_c());
        }
        return this.blockLocation;
    }

    public int getBlockStateId() {
        if (this.blockStateId < 0) {
            this.blockStateId = blockStateIdCounter.incrementAndGet();
        }
        return this.blockStateId;
    }

    public int getLightValue(IBlockReader world, BlockPos pos) {
        return this.func_185906_d();
    }

    public boolean isCacheOpaqueCube() {
        return this.field_215707_c != null && this.field_215707_c.field_222499_c;
    }

    public boolean isCacheOpaqueCollisionShape() {
        return this.field_215707_c != null && this.field_215707_c.field_225494_j;
    }

    public BlockState(Block blockIn, ImmutableMap<Property<?>, Comparable<?>> propertiesIn, MapCodec<BlockState> codecIn) {
        super(blockIn, propertiesIn, codecIn);
    }

    protected BlockState func_230340_p_() {
        return this;
    }
}

