/*
 * Decompiled with CFR 0.152.
 */
package net.isaiah.zazaaddon.entities;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.protection.ProtectedArea;
import xyz.pixelatedw.mineminenomi.data.world.ProtectedAreasData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.packets.server.entities.SUpdateLightningEntity;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class TrackingLightningEntity
extends LightningEntity {
    private static final Color RED_ARROW_COLOR = new Color(100, 0, 0, 255);
    private LivingEntity target;
    private float trackingSpeed = 0.2f;
    private int trackingDuration = 80;
    private int ticksAlive = 0;
    private double maxTrackingRange = 40.0;
    private boolean isRedirectionSegment = false;
    private Vector3d originalPosition;
    private boolean useCustomRenderer = true;

    public TrackingLightningEntity(LivingEntity thrower, double posX, double posY, double posZ, LivingEntity target, float maxTravelDistance, float travelSpeed, AbilityCore<? extends IAbility> abilityCore) {
        super((Entity)thrower, posX, posY, posZ, thrower.field_70177_z, thrower.field_70125_A, maxTravelDistance, travelSpeed, abilityCore);
        this.target = target;
        this.originalPosition = new Vector3d(posX, posY, posZ);
        this.setSize(0.03f);
        this.setBranches(1);
        this.setSegments(1);
        this.setAngle(100);
        this.setBoxSizeDivision(2.0);
        this.setEnergyEffect(true);
        this.setLightningMimic(false);
        this.forceCompleteOpacity();
        if (!this.field_70170_p.field_72995_K) {
            this.sendUpdateToClients();
        }
    }

    private void forceCompleteOpacity() {
        try {
            this.setColor(RED_ARROW_COLOR);
            try {
                Field blendModeField = LightningEntity.class.getDeclaredField("blendMode");
                if (blendModeField != null) {
                    blendModeField.setAccessible(true);
                    blendModeField.setInt((Object)this, 1);
                }
            }
            catch (Exception blendModeField) {
                // empty catch block
            }
            try {
                Field alphaField = LightningEntity.class.getDeclaredField("alpha");
                if (alphaField != null) {
                    alphaField.setAccessible(true);
                    alphaField.setInt((Object)this, 255);
                }
            }
            catch (Exception alphaField) {
                // empty catch block
            }
            try {
                Field colorField = LightningEntity.class.getDeclaredField("color");
                if (colorField != null) {
                    colorField.setAccessible(true);
                    colorField.setInt((Object)this, RED_ARROW_COLOR.getRGB());
                }
            }
            catch (Exception colorField) {
                // empty catch block
            }
            try {
                Method disableFadeMethod = LightningEntity.class.getDeclaredMethod("disableFade", new Class[0]);
                if (disableFadeMethod != null) {
                    disableFadeMethod.setAccessible(true);
                    disableFadeMethod.invoke((Object)this, new Object[0]);
                }
            }
            catch (Exception disableFadeMethod) {
                // empty catch block
            }
            try {
                String[] renderLayerField = LightningEntity.class.getDeclaredField("renderLayer");
                if (renderLayerField != null) {
                    renderLayerField.setAccessible(true);
                    renderLayerField.setInt((Object)this, 0);
                }
            }
            catch (Exception renderLayerField) {
                // empty catch block
            }
            try {
                for (String fieldName : new String[]{"transparent", "translucent", "useAlpha", "useTransparency"}) {
                    try {
                        Field field = LightningEntity.class.getDeclaredField(fieldName);
                        if (field == null) continue;
                        field.setAccessible(true);
                        field.setBoolean((Object)this, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception renderLayerField) {
                // empty catch block
            }
            try {
                Field energyField = LightningEntity.class.getDeclaredField("energyEffect");
                if (energyField != null) {
                    energyField.setAccessible(true);
                    energyField.setBoolean((Object)this, true);
                }
            }
            catch (Exception energyField) {
                // empty catch block
            }
            try {
                Field specialRenderField = LightningEntity.class.getDeclaredField("requiresSpecialRender");
                if (specialRenderField != null) {
                    specialRenderField.setAccessible(true);
                    specialRenderField.setBoolean((Object)this, true);
                }
            }
            catch (Exception specialRenderField) {
                // empty catch block
            }
            try {
                Field textureBlendField = LightningEntity.class.getDeclaredField("textureBlend");
                if (textureBlendField != null) {
                    textureBlendField.setAccessible(true);
                    textureBlendField.setBoolean((Object)this, false);
                }
            }
            catch (Exception textureBlendField) {}
        }
        catch (Exception e) {
            System.err.println("Failed to set opacity: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void sendUpdateToClients() {
        if (!this.field_70170_p.field_72995_K && this.getThrower() != null) {
            WyNetwork.sendToAllTrackingAndSelf((Object)new SUpdateLightningEntity((LightningEntity)this), (Entity)this.getThrower());
        }
    }

    public void func_70071_h_() {
        double distanceToTarget;
        this.forceCompleteOpacity();
        if (this.target != null && this.target.func_70089_S() && this.ticksAlive < this.trackingDuration && (distanceToTarget = this.func_213303_ch().func_72438_d(this.target.func_213303_ch())) <= this.maxTrackingRange) {
            float yawDiff;
            Vector3d targetPos = this.target.func_213303_ch().func_72441_c(0.0, (double)(this.target.func_213302_cg() / 2.0f), 0.0);
            Vector3d currentPos = this.func_213303_ch();
            Vector3d directionToTarget = targetPos.func_178788_d(currentPos).func_72432_b();
            float newYaw = (float)Math.toDegrees(Math.atan2(-directionToTarget.field_72450_a, directionToTarget.field_72449_c));
            float newPitch = (float)Math.toDegrees(-Math.asin(directionToTarget.field_72448_b));
            float currentYaw = this.field_70177_z;
            float currentPitch = this.field_70125_A;
            for (yawDiff = newYaw - currentYaw; yawDiff > 180.0f; yawDiff -= 360.0f) {
            }
            while (yawDiff < -180.0f) {
                yawDiff += 360.0f;
            }
            float pitchDiff = newPitch - currentPitch;
            this.field_70177_z = currentYaw + yawDiff * this.trackingSpeed;
            this.field_70125_A = currentPitch + pitchDiff * this.trackingSpeed;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        super.func_70071_h_();
        this.forceCompleteOpacity();
        if (this.ticksAlive % 1 == 0 && !this.field_70170_p.field_72995_K) {
            this.sendUpdateToClients();
        }
        ++this.ticksAlive;
    }

    public void setAsRedirectionSegment(boolean isRedirectionSegment) {
        this.isRedirectionSegment = isRedirectionSegment;
    }

    public boolean isRedirectionSegment() {
        return this.isRedirectionSegment;
    }

    public Vector3d getOriginalPosition() {
        return this.originalPosition;
    }

    public int getColor() {
        return RED_ARROW_COLOR.getRGB();
    }

    public int getAlpha() {
        return 255;
    }

    public void setColor(Color color) {
        super.setColor(RED_ARROW_COLOR);
    }

    public float getTransparency() {
        return 0.0f;
    }

    public boolean isTransparent() {
        return false;
    }

    public boolean shouldRenderTransparent() {
        return false;
    }

    public boolean isTranslucent() {
        return false;
    }

    public float getAlphaMultiplier() {
        return 1.0f;
    }

    public void onEntityImpactEvent(Entity hitEntity) {
        super.onEntityImpactEvent(hitEntity);
        if (hitEntity.func_70089_S() && hitEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)hitEntity;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), 200, 1, true, true));
        }
    }

    public void onFirstImpact(BlockPos hit) {
        ProtectedArea area = ProtectedAreasData.get((World)this.field_70170_p).getProtectedArea(hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p());
        if (area == null || area.canUseAbility(super.getParent())) {
            ExplosionAbility explosion = super.createExplosion((Entity)super.getThrower(), this.field_70170_p, (double)hit.func_177958_n(), (double)hit.func_177956_o(), (double)hit.func_177952_p(), (float)this.getExplosionSize());
            explosion.immuneEntities = this.explosionTargets;
            explosion.setExplosionSound(false);
            if (!this.getCanCauseKnockback()) {
                explosion.disableExplosionKnockback();
            }
            explosion.setStaticDamage(super.getDamage() / 2.0f);
            explosion.setDamageSource((DamageSource)super.getDamageSource());
            explosion.setDamageOwner(false);
            explosion.setStaticBlockResistance(this.getExplosionBlockResistance());
            explosion.setDestroyBlocks(this.getExplosionDestroysBlocks());
            explosion.setFireAfterExplosion(false);
            explosion.setExplosionSound(false);
            explosion.setDamageEntities(true);
            explosion.doExplosion();
            this.explosionTargets.addAll(explosion.damagedEntities);
        }
    }

    private int getExplosionSize() {
        try {
            Field field = LightningEntity.class.getDeclaredField("explosionSize");
            field.setAccessible(true);
            return field.getInt((Object)this);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private boolean getCanCauseKnockback() {
        try {
            Field field = LightningEntity.class.getDeclaredField("canCauseKnockback");
            field.setAccessible(true);
            return field.getBoolean((Object)this);
        }
        catch (Exception e) {
            return true;
        }
    }

    private float getExplosionBlockResistance() {
        try {
            Field field = LightningEntity.class.getDeclaredField("explosionBlockResistance");
            field.setAccessible(true);
            return field.getFloat((Object)this);
        }
        catch (Exception e) {
            return 0.1f;
        }
    }

    private boolean getExplosionDestroysBlocks() {
        try {
            Field field = LightningEntity.class.getDeclaredField("explosionDestroysBlocks");
            field.setAccessible(true);
            return field.getBoolean((Object)this);
        }
        catch (Exception e) {
            return true;
        }
    }

    public void setTrackingSpeed(float speed) {
        this.trackingSpeed = Math.max(0.05f, Math.min(1.0f, speed));
    }

    public void setTrackingDuration(int ticks) {
        this.trackingDuration = ticks;
    }

    public void setMaxTrackingRange(double range) {
        this.maxTrackingRange = range;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setBoxSizeDivision(double division) {
        super.setBoxSizeDivision(0.8);
    }
}

