/*
 * Decompiled with CFR 0.152.
 */
package net.isaiah.zazaaddon.abilities.imu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doku.ChloroBallProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.HikenProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class StrikeAttack
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("zazaaddon", "textures/abilities/alts/motherflameburst.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("zazaaddon", "textures/abilities/alts/motherflameburst.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"zazaaddon", (String)"strike_attack", (Pair[])new Pair[]{ImmutablePair.of((Object)"Shoots out a barrage of ZaZa fist projectiles at enemies.", null)});
    private static final int COOLDOWN = 800;
    public static final AbilityCore INSTANCE = new AbilityCore.Builder("Mother Of Flame Burst", AbilityCategory.DEVIL_FRUITS, StrikeAttack::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)800.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.BLUNT}).setSourceElement(SourceElement.NONE).setIcon(DEFAULT_ICON).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final ProjectileComponent chloroBallComponent = new ProjectileComponent((IAbility)this, this::createChloroBallProjectile);
    private final ProjectileComponent hikenComponent = new ProjectileComponent((IAbility)this, this::createHikenProjectile);

    public StrikeAttack(AbilityCore<StrikeAttack> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.continuousComponent, this.repeaterComponent, this.chloroBallComponent, this.hikenComponent});
        super.addUseEvent(this::onUseEvent);
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
        super.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
        } else {
            this.continuousComponent.triggerContinuity(entity);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.repeaterComponent.start(entity, 6, 2);
        }
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail()) {
            this.repeaterComponent.stop(entity);
        } else {
            int i = 0;
            while ((double)i < WyHelper.randomWithRange((int)1, (int)3)) {
                this.chloroBallComponent.shoot(entity, 7.0f, 8.0f);
                this.hikenComponent.shoot(entity, 8.0f, 10.0f);
                ++i;
            }
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        }
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 800.0f);
    }

    private ChloroBallProjectile createChloroBallProjectile(LivingEntity entity) {
        boolean isDemonForm = true;
        ChloroBallProjectile proj = new ChloroBallProjectile(entity.field_70170_p, entity, isDemonForm);
        return proj;
    }

    private HikenProjectile createHikenProjectile(LivingEntity entity) {
        HikenProjectile proj = new HikenProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

