/*
 * Decompiled with CFR 0.152.
 */
package net.isaiah.zazaaddon.abilities.imu;

import java.util.ArrayList;
import net.isaiah.zazaaddon.init.ZaZaParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.PunkPistolProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AbyssWeaponManipulation
extends RepeaterAbility2 {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("zazaaddon", "textures/abilities/alts/abyss_circle.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("zazaaddon", "textures/abilities/alts/abyss_circle.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"zazaaddon", (String)"abyss_weapon_manipulation", (Pair[])new Pair[]{ImmutablePair.of((Object)"Summons a mystical circle in front of the user that fires abyssal projectiles.", null)});
    private static final int MAX_COOLDOWN = 450;
    private static final int MAX_PROJECTILES = 6;
    private static final int PROJECTILE_INTERVAL = 6;
    public static final AbilityCore<AbyssWeaponManipulation> INSTANCE = new AbilityCore.Builder("Abyss Weapon Manipulation", AbilityCategory.DEVIL_FRUITS, AbyssWeaponManipulation::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)450.0f)}).setSourceElement(SourceElement.METAL).setSourceHakiNature(SourceHakiNature.IMBUING).setIcon(DEFAULT_ICON).build();
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this).addOnAttackEvent(this::onDamageTaken);
    private boolean hasFallDamage = true;
    private boolean hasLaunched = false;

    public AbyssWeaponManipulation(AbilityCore<AbyssWeaponManipulation> core) {
        super(core);
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.damageTakenComponent});
        this.continuousComponent.addStartEvent(this::startContinuousEvent);
        this.continuousComponent.addEndEvent(this::endContinuousEvent);
        this.continuousComponent.addTickEvent(this::tickContinuousEvent);
        this.repeaterComponent.addTriggerEvent(this::triggerRepeaterEvent);
    }

    public void equipEvent(LivingEntity entity, RepeaterAbility2 ability) {
        super.setDisplayIcon(DEFAULT_ICON);
        if (ClientConfig.INSTANCE.isGoroBlue()) {
            super.setDisplayIcon(ALT_ICON);
        }
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        Vector3d startVec;
        boolean blockUnder;
        boolean isGrounded;
        this.hasFallDamage = false;
        this.hasLaunched = false;
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
        if (!this.hasLaunched && (isGrounded = entity.func_233570_aj_()) && (blockUnder = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec = entity.func_213303_ch(), startVec.func_72441_c(0.0, -2.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK))) {
            AbilityHelper.setDeltaMovement((Entity)entity, (double)entity.func_213322_ci().field_72450_a, (double)0.6, (double)entity.func_213322_ci().field_72449_c);
            this.hasLaunched = true;
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
    }

    private void tickContinuousEvent(LivingEntity entity, IAbility ability) {
        Vector3d startVec;
        boolean blockUnder;
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 1, false, false));
        if (!this.hasLaunched && entity.func_233570_aj_() && (blockUnder = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec = entity.func_213303_ch(), startVec.func_72441_c(0.0, -2.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK))) {
            AbilityHelper.setDeltaMovement((Entity)entity, (double)entity.func_213322_ci().field_72450_a, (double)0.6, (double)entity.func_213322_ci().field_72449_c);
            this.hasLaunched = true;
        }
        AbilityHelper.slowEntityFall((LivingEntity)entity);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        Vector3d look = entity.func_70676_i(1.0f).func_72432_b().func_186678_a(3.0);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ZaZaParticleEffects.ABYSS_CIRCLE.get()), (Entity)entity, (double)(entity.func_226277_ct_() + look.field_72450_a), (double)(entity.func_226278_cu_() + 1.0 + look.field_72448_b), (double)(entity.func_226281_cx_() + look.field_72449_c));
    }

    public int getMaxTriggers() {
        return 6;
    }

    public int getTriggerInterval() {
        return 6;
    }

    public float getRepeaterCooldown() {
        return 450.0f;
    }

    public PunkPistolProjectile getProjectileFactory(LivingEntity entity) {
        ArrayList emptyList = new ArrayList();
        PunkPistolProjectile proj = new PunkPistolProjectile(entity.field_70170_p, entity, emptyList);
        proj.setDamage(20.0f);
        proj.setMaxLife(60);
        proj.setPassThroughBlocks();
        return proj;
    }
}

