/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import noppes.npcs.controllers.data.TransportLocation;

public class TransportCategory {
    public int id = -1;
    public String title = "";
    public HashMap<Integer, TransportLocation> locations = new HashMap();

    public Vector<TransportLocation> getDefaultLocations() {
        Vector<TransportLocation> list = new Vector<TransportLocation>();
        for (TransportLocation loc : this.locations.values()) {
            if (!loc.isDefault()) continue;
            list.add(loc);
        }
        return list;
    }

    public void readNBT(CompoundNBT compound) {
        this.id = compound.func_74762_e("CategoryId");
        this.title = compound.func_74779_i("CategoryTitle");
        ListNBT locs = compound.func_150295_c("CategoryLocations", 10);
        if (locs == null || locs.size() == 0) {
            return;
        }
        for (int ii = 0; ii < locs.size(); ++ii) {
            TransportLocation location = new TransportLocation();
            location.readNBT(locs.func_150305_b(ii));
            location.category = this;
            this.locations.put(location.id, location);
        }
    }

    public void writeNBT(CompoundNBT compound) {
        compound.func_74768_a("CategoryId", this.id);
        compound.func_74778_a("CategoryTitle", this.title);
        ListNBT locs = new ListNBT();
        for (TransportLocation location : this.locations.values()) {
            locs.add((Object)location.writeNBT());
        }
        compound.func_218657_a("CategoryLocations", (INBT)locs);
    }
}

