/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.io.File;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.data.PlayerBankData;
import noppes.npcs.controllers.data.PlayerDialogData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.controllers.data.PlayerItemGiverData;
import noppes.npcs.controllers.data.PlayerMailData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.controllers.data.PlayerTransportData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.NBTJsonUtil;

public class PlayerData
implements ICapabilityProvider {
    @CapabilityInject(value=PlayerData.class)
    public static Capability<PlayerData> PLAYERDATA_CAPABILITY = null;
    public BlockPos scriptBlockPos = BlockPos.field_177992_a;
    private LazyOptional<PlayerData> instance = LazyOptional.of(() -> this);
    public PlayerDialogData dialogData = new PlayerDialogData();
    public PlayerBankData bankData = new PlayerBankData();
    public PlayerQuestData questData = new PlayerQuestData();
    public PlayerTransportData transportData = new PlayerTransportData();
    public PlayerFactionData factionData = new PlayerFactionData();
    public PlayerItemGiverData itemgiverData = new PlayerItemGiverData();
    public PlayerMailData mailData = new PlayerMailData();
    public PlayerScriptData scriptData;
    public CompoundNBT scriptStoreddata = new CompoundNBT();
    public DataTimers timers = new DataTimers(this);
    public EntityNPCInterface editingNpc;
    public CompoundNBT cloned;
    public PlayerEntity player;
    public String playername = "";
    public String uuid = "";
    private EntityNPCInterface activeCompanion = null;
    public int companionID = 0;
    public int playerLevel = 0;
    public boolean updateClient = false;
    public int dialogId = -1;
    public ItemStack prevHeldItem = ItemStack.field_190927_a;
    public Entity mounted;
    public UUID iAmStealingYourDatas = UUID.randomUUID();
    private static final ResourceLocation key = new ResourceLocation("customnpcs", "playerdata");
    private static PlayerData backup = new PlayerData();

    public void setNBT(CompoundNBT data) {
        this.dialogData.loadNBTData(data);
        this.bankData.loadNBTData(data);
        this.questData.loadNBTData(data);
        this.transportData.loadNBTData(data);
        this.factionData.loadNBTData(data);
        this.itemgiverData.loadNBTData(data);
        this.mailData.loadNBTData(data);
        this.timers.load(data);
        if (this.player != null) {
            this.playername = this.player.func_200200_C_().getString();
            this.uuid = this.player.func_110124_au().toString();
        } else {
            this.playername = data.func_74779_i("PlayerName");
            this.uuid = data.func_74779_i("UUID");
        }
        this.companionID = data.func_74762_e("PlayerCompanionId");
        if (data.func_74764_b("PlayerCompanion") && !this.hasCompanion() && this.player != null) {
            EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, this.player.field_70170_p);
            npc.func_70037_a(data.func_74775_l("PlayerCompanion"));
            npc.func_70107_b(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
            if (npc.role.getType() == 6) {
                ((RoleCompanion)npc.role).setSitting(false);
                npc.field_98038_p = true;
                this.player.field_70170_p.func_217376_c((Entity)npc);
                this.setCompanion(npc);
            }
        }
        this.scriptStoreddata = data.func_74775_l("ScriptStoreddata");
    }

    public CompoundNBT getSyncNBT() {
        CompoundNBT compound = new CompoundNBT();
        this.dialogData.saveNBTData(compound);
        this.questData.saveNBTData(compound);
        this.factionData.saveNBTData(compound);
        return compound;
    }

    public CompoundNBT getNBT() {
        CompoundNBT nbt;
        if (this.player != null) {
            this.playername = this.player.func_200200_C_().getString();
            this.uuid = this.player.func_110124_au().toString();
        }
        CompoundNBT compound = new CompoundNBT();
        this.dialogData.saveNBTData(compound);
        this.bankData.saveNBTData(compound);
        this.questData.saveNBTData(compound);
        this.transportData.saveNBTData(compound);
        this.factionData.saveNBTData(compound);
        this.itemgiverData.saveNBTData(compound);
        this.mailData.saveNBTData(compound);
        this.timers.save(compound);
        compound.func_74778_a("PlayerName", this.playername);
        compound.func_74778_a("UUID", this.uuid);
        compound.func_74768_a("PlayerCompanionId", this.companionID);
        compound.func_218657_a("ScriptStoreddata", (INBT)this.scriptStoreddata);
        if (this.hasCompanion() && this.activeCompanion.func_184198_c(nbt = new CompoundNBT())) {
            compound.func_218657_a("PlayerCompanion", (INBT)nbt);
        }
        return compound;
    }

    public boolean hasCompanion() {
        return this.activeCompanion != null && !this.activeCompanion.field_70128_L;
    }

    public void setCompanion(EntityNPCInterface npc) {
        if (npc != null && npc.role.getType() != 6) {
            return;
        }
        ++this.companionID;
        this.activeCompanion = npc;
        if (npc != null) {
            ((RoleCompanion)npc.role).companionID = this.companionID;
        }
        this.save(false);
    }

    public void updateCompanion(World level) {
        if (!this.hasCompanion() || level == this.activeCompanion.field_70170_p) {
            return;
        }
        RoleCompanion role = (RoleCompanion)this.activeCompanion.role;
        role.owner = this.player;
        if (!role.isFollowing()) {
            return;
        }
        CompoundNBT nbt = new CompoundNBT();
        this.activeCompanion.func_184198_c(nbt);
        this.activeCompanion.field_70128_L = true;
        EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, level);
        npc.func_70037_a(nbt);
        npc.func_70107_b(this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
        this.setCompanion(npc);
        ((RoleCompanion)npc.role).setSitting(false);
        npc.field_98038_p = true;
        level.func_217376_c((Entity)npc);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == PLAYERDATA_CAPABILITY) {
            return this.instance.cast();
        }
        return LazyOptional.empty();
    }

    public static void register(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(key, (ICapabilityProvider)new PlayerData());
        }
    }

    public synchronized void save(boolean update) {
        CompoundNBT compound = this.getNBT();
        String filename = this.uuid + ".json";
        CustomNPCsScheduler.runTack(() -> {
            try {
                File saveDir = CustomNpcs.getWorldSaveDirectory("playerdata");
                File file = new File(saveDir, filename + "_new");
                File file1 = new File(saveDir, filename);
                NBTJsonUtil.SaveFile(file, compound);
                if (file1.exists()) {
                    file1.delete();
                }
                file.renameTo(file1);
            }
            catch (Exception e) {
                LogWriter.except(e);
            }
        });
        if (update) {
            this.updateClient = true;
        }
    }

    public static CompoundNBT loadPlayerData(String player) {
        File saveDir = CustomNpcs.getWorldSaveDirectory("playerdata");
        String filename = player;
        if (filename.isEmpty()) {
            filename = "noplayername";
        }
        filename = filename + ".json";
        File file = null;
        try {
            file = new File(saveDir, filename);
            if (file.exists()) {
                return NBTJsonUtil.LoadFile(file);
            }
        }
        catch (Exception e) {
            LogWriter.error("Error loading: " + file.getAbsolutePath(), e);
        }
        return new CompoundNBT();
    }

    public static PlayerData get(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return CustomNpcs.proxy.getPlayerData(player);
        }
        PlayerData data = (PlayerData)player.getCapability(PLAYERDATA_CAPABILITY, null).orElse((Object)backup);
        if (data.player == null) {
            data.player = player;
            data.playerLevel = player.field_71068_ca;
            data.scriptData = new PlayerScriptData(player);
            CompoundNBT compound = PlayerData.loadPlayerData(player.func_110124_au().toString());
            data.setNBT(compound);
        }
        return data;
    }
}

