/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.ModelPartData;
import noppes.npcs.client.layer.LayerInterface;
import noppes.npcs.client.layer.LayerPreRender;
import noppes.npcs.client.model.part.legs.ModelDigitigradeLegs;
import noppes.npcs.client.model.part.legs.ModelHorseLegs;
import noppes.npcs.client.model.part.legs.ModelMermaidLegs;
import noppes.npcs.client.model.part.legs.ModelNagaLegs;
import noppes.npcs.client.model.part.legs.ModelSpiderLegs;
import noppes.npcs.client.model.part.tails.ModelCanineTail;
import noppes.npcs.client.model.part.tails.ModelDragonTail;
import noppes.npcs.client.model.part.tails.ModelFeatherTail;
import noppes.npcs.client.model.part.tails.ModelRodentTail;
import noppes.npcs.client.model.part.tails.ModelSquirrelTail;
import noppes.npcs.client.model.part.tails.ModelTailFin;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityCustomNpc;

public class LayerLegs
extends LayerInterface
implements LayerPreRender {
    private ModelSpiderLegs spiderLegs;
    private ModelHorseLegs horseLegs;
    private ModelNagaLegs naga;
    private ModelDigitigradeLegs digitigrade;
    private ModelMermaidLegs mermaid;
    private ModelRenderer tail;
    private ModelCanineTail fox;
    private ModelRenderer dragon;
    private ModelRenderer squirrel;
    private ModelRenderer horse;
    private ModelRenderer fin;
    private ModelRenderer rodent;
    private ModelRenderer feathers;
    float z;
    float y;

    public LayerLegs(LivingRenderer render) {
        super(render);
        this.createParts();
    }

    private void createParts() {
        this.spiderLegs = new ModelSpiderLegs(this.base);
        this.horseLegs = new ModelHorseLegs(this.base);
        this.naga = new ModelNagaLegs((Model)this.base);
        this.mermaid = new ModelMermaidLegs((Model)this.base);
        this.digitigrade = new ModelDigitigradeLegs(this.base);
        this.fox = new ModelCanineTail(this.base);
        this.tail = new ModelRenderer(this.base.field_78090_t, this.base.field_78089_u, 56, 21);
        this.tail.func_228300_a_(-1.0f, 0.0f, 0.0f, 2.0f, 9.0f, 2.0f);
        this.tail.func_78793_a(0.0f, 0.0f, 1.0f);
        this.setRotation(this.tail, 0.8714253f, 0.0f, 0.0f);
        this.horse = new ModelRenderer(this.base.field_78090_t, this.base.field_78089_u, 0, 0);
        this.horse.func_78787_b(32, 32);
        this.horse.func_78793_a(0.0f, -1.0f, 1.0f);
        ModelRenderer tailBase = new ModelRenderer(this.base.field_78090_t, this.base.field_78089_u, 0, 26);
        tailBase.func_78787_b(32, 32);
        tailBase.func_228300_a_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f);
        this.setRotation(tailBase, -1.134464f, 0.0f, 0.0f);
        this.horse.func_78792_a(tailBase);
        ModelRenderer tailMiddle = new ModelRenderer(this.base.field_78090_t, this.base.field_78089_u, 0, 13);
        tailMiddle.func_78787_b(32, 32);
        tailMiddle.func_228300_a_(-1.5f, -2.0f, 3.0f, 3.0f, 4.0f, 7.0f);
        this.setRotation(tailMiddle, -1.134464f, 0.0f, 0.0f);
        this.horse.func_78792_a(tailMiddle);
        ModelRenderer tailTip = new ModelRenderer(this.base.field_78090_t, this.base.field_78089_u, 0, 0);
        tailTip.func_78787_b(32, 32);
        tailTip.func_228300_a_(-1.5f, -4.5f, 9.0f, 3.0f, 4.0f, 7.0f);
        this.setRotation(tailTip, -1.40215f, 0.0f, 0.0f);
        this.horse.func_78792_a(tailTip);
        this.horse.field_78795_f = 0.5f;
        this.dragon = new ModelDragonTail(this.base);
        this.squirrel = new ModelSquirrelTail(this.base);
        this.fin = new ModelTailFin(this.base);
        this.rodent = new ModelRodentTail(this.base);
        this.feathers = new ModelFeatherTail(this.base);
    }

    @Override
    public void render(MatrixStack mStack, IRenderTypeBuffer typeBuffer, int lightmapUV, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
        this.renderLegs(mStack, typeBuffer, lightmapUV, partialTicks);
        this.renderTails(mStack, typeBuffer, lightmapUV, partialTicks);
    }

    private void renderTails(MatrixStack mStack, IRenderTypeBuffer typeBuffer, int lightmapUV, float partialTicks) {
        ModelPartData data = this.playerdata.getPartData(EnumParts.TAIL);
        if (data == null) {
            return;
        }
        mStack.func_227860_a_();
        ModelPartConfig config = this.playerdata.getPartConfig(EnumParts.LEG_LEFT);
        mStack.func_227861_a_((double)config.transX, (double)config.transY + (double)this.y * 0.064, (double)config.transZ + (double)this.z * 0.064);
        mStack.func_227861_a_(0.0, 0.0, (double)((config.scaleZ - 1.0f) * 5.0f * partialTicks));
        mStack.func_227862_a_(config.scaleX, config.scaleY, config.scaleZ);
        this.preRender(data);
        IVertexBuilder ivertex = typeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getResource(data)));
        if (data.type == 0) {
            if (data.pattern == 1) {
                this.tail.field_78800_c = -0.5f;
                this.tail.field_78796_g = (float)((double)this.tail.field_78796_g - 0.2);
                this.tail.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
                this.tail.field_78800_c += 1.0f;
                this.tail.field_78796_g = (float)((double)this.tail.field_78796_g + 0.4);
                this.tail.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
                this.tail.field_78800_c = 0.0f;
            } else {
                this.tail.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
            }
        } else if (data.type == 1) {
            this.dragon.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 2) {
            this.horse.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 3) {
            this.squirrel.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 4) {
            this.fin.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 5) {
            this.rodent.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 6) {
            this.feathers.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 7) {
            this.fox.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        }
        mStack.func_227865_b_();
    }

    private void renderLegs(MatrixStack mStack, IRenderTypeBuffer typeBuffer, int lightmapUV, float partialTicks) {
        ModelPartData data = this.playerdata.getPartData(EnumParts.LEGS);
        if (data.type <= 0) {
            return;
        }
        mStack.func_227860_a_();
        ModelPartConfig config = this.playerdata.getPartConfig(EnumParts.LEG_LEFT);
        this.preRender(data);
        IVertexBuilder ivertex = typeBuffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getResource(data)));
        if (data.type == 1) {
            mStack.func_227861_a_(0.0, (double)(config.transY * 2.0f), (double)(config.transZ * partialTicks + 0.04f));
            mStack.func_227862_a_(config.scaleX, config.scaleY, config.scaleZ);
            this.naga.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 2) {
            mStack.func_227861_a_(0.0, (double)(config.transY * 1.76f - 0.1f * config.scaleY), (double)(config.transZ * partialTicks));
            mStack.func_227862_a_(1.06f, 1.06f, 1.06f);
            mStack.func_227862_a_(config.scaleX, config.scaleY, config.scaleZ);
            this.spiderLegs.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 3) {
            if (config.scaleY >= 1.0f) {
                mStack.func_227861_a_(0.0, (double)(config.transY * 1.76f), (double)(config.transZ * partialTicks));
            } else {
                mStack.func_227861_a_(0.0, (double)(config.transY * 1.86f), (double)(config.transZ * partialTicks));
            }
            mStack.func_227862_a_(0.79f, 0.9f - config.scaleY / 10.0f, 0.79f);
            mStack.func_227862_a_(config.scaleX, config.scaleY, config.scaleZ);
            this.horseLegs.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 4) {
            mStack.func_227861_a_(0.0, (double)(config.transY * 1.86f), (double)(config.transZ * partialTicks));
            mStack.func_227862_a_(config.scaleX, config.scaleY, config.scaleZ);
            this.mermaid.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        } else if (data.type == 5) {
            mStack.func_227861_a_(0.0, (double)(config.transY * 1.86f), (double)(config.transZ * partialTicks));
            mStack.func_227862_a_(config.scaleX, config.scaleY, config.scaleZ);
            this.digitigrade.func_228309_a_(mStack, ivertex, lightmapUV, OverlayTexture.field_229196_a_, this.red(), this.green(), this.blue(), this.alpha());
        }
        mStack.func_227865_b_();
    }

    @Override
    public void rotate(MatrixStack matrixStack, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.rotateLegs(limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        this.rotateTail(limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    public void rotateLegs(float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPartData part = this.playerdata.getPartData(EnumParts.LEGS);
        if (part.type == 2) {
            this.spiderLegs.setupAnim(this.playerdata, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, (Entity)this.npc);
        } else if (part.type == 3) {
            this.horseLegs.setupAnim(this.playerdata, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, (Entity)this.npc);
        } else if (part.type == 1) {
            this.naga.riding = this.base.field_217113_d;
            this.naga.isSleeping = this.npc.func_70608_bn();
            this.naga.isCrawling = this.npc.currentAnimation == 7;
            this.naga.isSneaking = this.base.field_228270_o_;
            this.naga.setupAnim(limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, (Entity)this.npc);
        } else if (part.type == 4) {
            this.mermaid.setupAnim(limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, (Entity)this.npc);
        } else if (part.type == 5) {
            this.digitigrade.setupAnim(limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, (Entity)this.npc);
        }
    }

    public void rotateTail(float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPartData part = this.playerdata.getPartData(EnumParts.LEGS);
        ModelPartData partTail = this.playerdata.getPartData(EnumParts.TAIL);
        ModelPartConfig config = this.playerdata.getPartConfig(EnumParts.LEG_LEFT);
        float yRot = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 0.2f * limbSwingAmount;
        float xRot = MathHelper.func_76126_a((float)(partialTicks * 0.067f)) * 0.05f;
        this.z = 0.0f;
        this.y = 11.0f;
        if (part.type == 2) {
            this.y = 12.0f + (config.scaleY - 1.0f) * 3.0f;
            this.z = 15.0f + (config.scaleZ - 1.0f) * 10.0f;
            if (this.npc.func_70608_bn() || this.npc.currentAnimation == 7) {
                this.y = 12.0f + 16.0f * config.scaleZ;
                this.z = 1.0f * config.scaleY;
                xRot = -0.7853982f;
            }
        } else if (part.type == 3) {
            this.y = 10.0f;
            this.z = 16.0f + (config.scaleZ - 1.0f) * 12.0f;
        } else {
            this.z = (1.0f - config.scaleZ) * 1.0f;
        }
        if (partTail != null) {
            if (partTail.type == 2) {
                xRot = (float)((double)xRot + 0.5);
            }
            if (partTail.type == 0) {
                xRot += 0.87f;
            }
            if (partTail.type == 7) {
                this.fox.setupAnim(limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, (Entity)this.npc);
            }
        }
        this.z += this.base.field_178721_j.field_78798_e + 0.5f;
        this.fin.field_78795_f = this.rodent.field_78795_f = xRot;
        this.horse.field_78795_f = this.rodent.field_78795_f;
        this.squirrel.field_78795_f = this.rodent.field_78795_f;
        this.dragon.field_78795_f = this.rodent.field_78795_f;
        this.feathers.field_78795_f = this.rodent.field_78795_f;
        this.tail.field_78795_f = this.rodent.field_78795_f;
        this.fox.field_78795_f = this.rodent.field_78795_f;
        this.fin.field_78796_g = this.rodent.field_78796_g = yRot;
        this.horse.field_78796_g = this.rodent.field_78796_g;
        this.squirrel.field_78796_g = this.rodent.field_78796_g;
        this.dragon.field_78796_g = this.rodent.field_78796_g;
        this.feathers.field_78796_g = this.rodent.field_78796_g;
        this.tail.field_78796_g = this.rodent.field_78796_g;
        this.fox.field_78796_g = this.rodent.field_78796_g;
    }

    @Override
    public void preRender(EntityCustomNpc player) {
        this.npc = player;
        this.playerdata = player.modelData;
        ModelPartData data = this.playerdata.getPartData(EnumParts.LEGS);
        this.base.field_178721_j.field_78806_j = data != null && data.type == 0;
        this.base.field_178722_k.field_78806_j = this.base.field_178721_j.field_78806_j;
    }
}

