/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.roles;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.containers.ContainerNPCTraderSetup;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketNpcMarketSet;
import noppes.npcs.packets.server.SPacketNpcRoleSave;
import noppes.npcs.roles.RoleTrader;

public class GuiNpcTraderSetup
extends GuiContainerNPCInterface2<ContainerNPCTraderSetup>
implements ITextfieldListener {
    private final ResourceLocation slot = new ResourceLocation("customnpcs", "textures/gui/slot.png");
    private RoleTrader role;

    public GuiNpcTraderSetup(ContainerNPCTraderSetup container, PlayerInventory inv, ITextComponent titleIn) {
        super(NoppesUtil.getLastNpc(), container, inv, titleIn);
        this.field_147000_g = 220;
        this.menuYOffset = 10;
        this.role = container.role;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.setBackground("tradersetup.png");
        this.addLabel(new GuiNpcLabel(0, "role.marketname", this.guiLeft + 214, this.guiTop + 150));
        this.addTextField(new GuiNpcTextField(0, (Screen)this, this.guiLeft + 214, this.guiTop + 160, 180, 20, this.role.marketName));
        this.addLabel(new GuiNpcLabel(1, "gui.ignoreDamage", this.guiLeft + 260, this.guiTop + 29));
        this.addButton(new GuiNpcButtonYesNo((IGuiInterface)this, 1, this.guiLeft + 340, this.guiTop + 24, this.role.ignoreDamage));
        this.addLabel(new GuiNpcLabel(2, "gui.ignoreNBT", this.guiLeft + 260, this.guiTop + 51));
        this.addButton(new GuiNpcButtonYesNo((IGuiInterface)this, 2, this.guiLeft + 340, this.guiTop + 46, this.role.ignoreNBT));
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.guiTop += 10;
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.guiTop -= 10;
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        if (guibutton.id == 1) {
            this.role.ignoreDamage = ((GuiNpcButtonYesNo)guibutton).getBoolean();
        }
        if (guibutton.id == 2) {
            this.role.ignoreNBT = ((GuiNpcButtonYesNo)guibutton).getBoolean();
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int xMouse, int yMouse) {
        super.func_230450_a_(matrixStack, partialTicks, xMouse, yMouse);
        for (int slot = 0; slot < 18; ++slot) {
            int x = this.guiLeft + slot % 3 * 94 + 7;
            int y = this.guiTop + slot / 3 * 22 + 4;
            this.field_230706_i_.func_110434_K().func_110577_a(this.slot);
            this.func_238474_b_(matrixStack, x - 1, y, 0, 0, 18, 18);
            this.func_238474_b_(matrixStack, x + 17, y, 0, 0, 18, 18);
            this.field_230712_o_.func_238421_b_(matrixStack, "=", (float)(x + 36), (float)(y + 5), CustomNpcResourceListener.DefaultTextColor);
            this.field_230706_i_.func_110434_K().func_110577_a(this.slot);
            this.func_238474_b_(matrixStack, x + 42, y, 0, 0, 18, 18);
        }
    }

    @Override
    public void save() {
        Packets.sendServer(new SPacketNpcMarketSet(this.role.marketName, true));
        Packets.sendServer(new SPacketNpcRoleSave(this.role.save(new CompoundNBT())));
    }

    @Override
    public void unFocused(GuiNpcTextField guiNpcTextField) {
        String name = guiNpcTextField.func_146179_b();
        if (!name.equalsIgnoreCase(this.role.marketName)) {
            this.role.marketName = name;
            Packets.sendServer(new SPacketNpcMarketSet(this.role.marketName, false));
        }
    }
}

