/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.resources.I18n;
import noppes.npcs.ModelEyeData;
import noppes.npcs.ModelPartData;
import noppes.npcs.client.gui.model.GuiCreationExtra;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.client.gui.model.GuiModelColor;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiColorButton;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiInterface;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiCreationParts
extends GuiCreationScreenInterface
implements ITextfieldListener,
ICustomScrollListener {
    private GuiCustomScroll scroll;
    private GuiPart[] parts = new GuiPart[]{new GuiPart(EnumParts.EARS).setTypes(new String[]{"gui.none", "gui.normal", "ears.bunny"}), new GuiPartHorns(), new GuiPartHair(), new GuiPart(EnumParts.MOHAWK).setTypes(new String[]{"gui.none", "1", "2"}).noPlayerOptions(), new GuiPartSnout(), new GuiPartBeard(), new GuiPart(EnumParts.FIN).setTypes(new String[]{"gui.none", "fin.shark", "fin.reptile"}), new GuiPart(EnumParts.BREASTS).setTypes(new String[]{"gui.none", "1", "2", "3"}).noPlayerOptions(), new GuiPartWings(), new GuiPartClaws(), new GuiPart(EnumParts.SKIRT).setTypes(new String[]{"gui.none", "gui.normal"}), new GuiPartLegs(), new GuiPartTail(), new GuiPartEyes(), new GuiPartParticles()};
    private static int selected = 0;

    public GuiCreationParts(EntityNPCInterface npc) {
        super(npc);
        this.active = 2;
        this.closeOnEsc = false;
        Arrays.sort(this.parts, (o1, o2) -> {
            String s1 = I18n.func_135052_a((String)("part." + o1.part.name), (Object[])new Object[0]);
            String s2 = I18n.func_135052_a((String)("part." + o2.part.name), (Object[])new Object[0]);
            return s1.compareToIgnoreCase(s2);
        });
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.entity != null) {
            this.openGui(new GuiCreationExtra(this.npc));
            return;
        }
        if (this.scroll == null) {
            ArrayList<String> list = new ArrayList<String>();
            for (GuiPart part : this.parts) {
                list.add(I18n.func_135052_a((String)("part." + part.part.name), (Object[])new Object[0]));
            }
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setUnsortedList(list);
        }
        this.scroll.guiLeft = this.guiLeft;
        this.scroll.guiTop = this.guiTop + 46;
        this.scroll.func_231149_a_(100, this.imageHeight - 74);
        this.addScroll(this.scroll);
        if (this.parts[selected] != null) {
            this.scroll.setSelected(I18n.func_135052_a((String)("part." + this.parts[GuiCreationParts.selected].part.name), (Object[])new Object[0]));
            this.parts[selected].init();
        }
    }

    @Override
    public void buttonEvent(GuiNpcButton btn) {
        if (this.parts[selected] != null) {
            this.parts[selected].buttonEvent(btn);
        }
    }

    @Override
    public void unFocused(GuiNpcTextField textfield) {
        if (textfield.id == 23) {
            // empty if block
        }
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll scroll) {
        if (scroll.hasSelected()) {
            selected = scroll.getSelectedIndex();
            this.func_231160_c_();
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
    }

    class GuiPartLegs
    extends GuiPart {
        public GuiPartLegs() {
            super(EnumParts.LEGS);
            this.types = new String[]{"gui.none", "gui.normal", "legs.naga", "legs.spider", "legs.horse", "legs.mermaid", "legs.digitigrade"};
            this.canBeDeleted = false;
        }

        @Override
        public int init() {
            this.hasPlayerOption = this.data.type == 1 || this.data.type == 5;
            int y = super.init();
            if (this.data.type == 4) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.pattern", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationParts.this, 22, GuiCreationParts.this.guiLeft + 145, y, 100, 20, new String[]{"1", "2"}, this.data.pattern));
            }
            return y;
        }

        @Override
        public void buttonEvent(GuiNpcButton btn) {
            if (btn.id == 20) {
                int i = btn.getValue();
                this.data.playerTexture = i <= 1;
            }
            if (btn.id == 22) {
                this.data.pattern = (byte)btn.getValue();
            }
            super.buttonEvent(btn);
        }
    }

    class GuiPartParticles
    extends GuiPart {
        public GuiPartParticles() {
            super(EnumParts.PARTICLES);
            this.types = new String[]{"gui.none", "1", "2"};
        }

        @Override
        public int init() {
            int y = super.init();
            if (this.data == null) {
                return y;
            }
            return y;
        }
    }

    class GuiPartClaws
    extends GuiPart {
        public GuiPartClaws() {
            super(EnumParts.CLAWS);
            this.types = new String[]{"gui.none", "gui.show"};
        }

        @Override
        public int init() {
            int y = super.init();
            if (this.data == null) {
                return y;
            }
            GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.pattern", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
            GuiCreationParts.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationParts.this, 22, GuiCreationParts.this.guiLeft + 145, y, 100, 20, new String[]{"gui.both", "gui.left", "gui.right"}, this.data.pattern));
            return y;
        }
    }

    class GuiPartWings
    extends GuiPart {
        public GuiPartWings() {
            super(EnumParts.WINGS);
            this.setTypes(new String[]{"gui.none", "1", "2", "3", "4"});
        }

        @Override
        public int init() {
            int y = super.init();
            if (this.data == null) {
                return y;
            }
            return y;
        }

        @Override
        public void buttonEvent(GuiNpcButton btn) {
            if (btn.id == 34) {
                // empty if block
            }
            super.buttonEvent(btn);
        }
    }

    class GuiPartEyes
    extends GuiPart {
        private ModelEyeData eyes;

        public GuiPartEyes() {
            super(EnumParts.EYES);
            this.types = new String[]{"gui.none", "1", "2"};
            this.noPlayerOptions();
            this.canBeDeleted = false;
            this.eyes = (ModelEyeData)this.data;
        }

        @Override
        public int init() {
            int y = super.init();
            if (this.data != null && this.eyes.isEnabled()) {
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationParts.this, 22, GuiCreationParts.this.guiLeft + 145, y, 100, 20, new String[]{"gui.both", "gui.left", "gui.right"}, this.data.pattern));
                GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.draw", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationParts.this, 37, GuiCreationParts.this.guiLeft + 145, y += 25, 100, 20, new String[]{I18n.func_135052_a((String)"gui.up", (Object[])new Object[0]) + "x2", "gui.up", "gui.normal", "gui.up"}, this.eyes.eyePos + 1));
                GuiCreationParts.this.addLabel(new GuiNpcLabel(37, "gui.position", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiNpcButtonYesNo((IGuiInterface)GuiCreationParts.this, 34, GuiCreationParts.this.guiLeft + 145, y += 25, this.eyes.glint));
                GuiCreationParts.this.addLabel(new GuiNpcLabel(34, "eye.glint", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiColorButton((IGuiInterface)GuiCreationParts.this, 35, GuiCreationParts.this.guiLeft + 170, y += 25, this.eyes.browColor));
                GuiCreationParts.this.addLabel(new GuiNpcLabel(35, "eye.brow", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationParts.this, 38, GuiCreationParts.this.guiLeft + 225, y, 50, 20, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8"}, this.eyes.browThickness));
                GuiCreationParts.this.addButton(new GuiColorButton((IGuiInterface)GuiCreationParts.this, 36, GuiCreationParts.this.guiLeft + 170, y += 25, this.eyes.skinColor));
                GuiCreationParts.this.addLabel(new GuiNpcLabel(36, "eye.lid", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
            }
            return y;
        }

        @Override
        public void buttonEvent(GuiNpcButton btn) {
            if (btn.id == 34) {
                this.eyes.glint = ((GuiNpcButtonYesNo)btn).getBoolean();
            }
            if (btn.id == 35) {
                GuiCreationParts.this.setSubGui(new GuiModelColor(GuiCreationParts.this, this.eyes.browColor, color -> {
                    this.eyes.browColor = color;
                }));
            }
            if (btn.id == 36) {
                GuiCreationParts.this.setSubGui(new GuiModelColor(GuiCreationParts.this, this.eyes.skinColor, color -> {
                    this.eyes.skinColor = color;
                }));
            }
            if (btn.id == 37) {
                this.eyes.eyePos = ((GuiButtonBiDirectional)btn).getValue() - 1;
            }
            if (btn.id == 38) {
                this.eyes.browThickness = ((GuiButtonBiDirectional)btn).getValue();
            }
            super.buttonEvent(btn);
        }
    }

    class GuiPartBeard
    extends GuiPart {
        public GuiPartBeard() {
            super(EnumParts.BEARD);
            this.types = new String[]{"gui.none", "1", "2", "3", "4"};
            this.noPlayerTypes();
        }
    }

    class GuiPartSnout
    extends GuiPart {
        public GuiPartSnout() {
            super(EnumParts.SNOUT);
            this.types = new String[]{"gui.none", "snout.small", "snout.medium", "snout.large", "snout.bunny", "snout.beak"};
        }
    }

    class GuiPartHair
    extends GuiPart {
        public GuiPartHair() {
            super(EnumParts.HAIR);
            this.types = new String[]{"gui.none", "1", "2", "3", "4"};
            this.noPlayerTypes();
        }
    }

    class GuiPartHorns
    extends GuiPart {
        public GuiPartHorns() {
            super(EnumParts.HORNS);
            this.types = new String[]{"gui.none", "horns.bull", "horns.antlers", "horns.antenna"};
        }

        @Override
        public int init() {
            int y = super.init();
            if (this.data != null && this.data.type == 2) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.pattern", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationParts.this, 22, GuiCreationParts.this.guiLeft + 145, y, 100, 20, new String[]{"1", "2"}, this.data.pattern));
            }
            return y;
        }
    }

    class GuiPartTail
    extends GuiPart {
        public GuiPartTail() {
            super(EnumParts.TAIL);
            this.types = new String[]{"gui.none", "part.tail", "tail.dragon", "tail.horse", "tail.squirrel", "tail.fin", "tail.rodent", "tail.bird", "tail.fox"};
        }

        @Override
        public int init() {
            this.data = GuiCreationParts.this.playerdata.getPartData(this.part);
            this.hasPlayerOption = this.data != null && (this.data.type == 0 || this.data.type == 1 || this.data.type == 6 || this.data.type == 7);
            int y = super.init();
            if (this.data != null && this.data.type == 0) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(22, "gui.pattern", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationParts.this, 22, GuiCreationParts.this.guiLeft + 145, y, 100, 20, new String[]{"1", "2"}, this.data.pattern));
            }
            return y;
        }
    }

    class GuiPart {
        EnumParts part;
        private int paterns = 0;
        protected String[] types = new String[]{"gui.none"};
        protected ModelPartData data;
        protected boolean hasPlayerOption = true;
        protected boolean noPlayerTypes = false;
        protected boolean canBeDeleted = true;

        public GuiPart(EnumParts part) {
            this.part = part;
            this.data = GuiCreationParts.this.playerdata.getPartData(part);
        }

        public int init() {
            this.data = GuiCreationParts.this.playerdata.getPartData(this.part);
            int y = GuiCreationParts.this.guiTop + 50;
            if (this.data == null || !this.data.playerTexture || !this.noPlayerTypes) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(20, "gui.type", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiButtonBiDirectional((IGuiInterface)GuiCreationParts.this, 20, GuiCreationParts.this.guiLeft + 145, y, 100, 20, this.types, this.data == null ? 0 : this.data.type + 1));
                y += 25;
            }
            if (this.data != null && this.hasPlayerOption) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(21, "gui.playerskin", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiNpcButtonYesNo((IGuiInterface)GuiCreationParts.this, 21, GuiCreationParts.this.guiLeft + 170, y, this.data.playerTexture));
                y += 25;
            }
            if (this.data != null && !this.data.playerTexture) {
                GuiCreationParts.this.addLabel(new GuiNpcLabel(23, "gui.color", GuiCreationParts.this.guiLeft + 102, y + 5, 0xFFFFFF));
                GuiCreationParts.this.addButton(new GuiColorButton((IGuiInterface)GuiCreationParts.this, 23, GuiCreationParts.this.guiLeft + 170, y, this.data.color));
                y += 25;
            }
            return y;
        }

        public void buttonEvent(GuiNpcButton btn) {
            if (btn.id == 20) {
                int i = btn.getValue();
                if (i == 0 && this.canBeDeleted) {
                    GuiCreationParts.this.playerdata.removePart(this.part);
                } else {
                    this.data = GuiCreationParts.this.playerdata.getOrCreatePart(this.part);
                    this.data.pattern = 0;
                    this.data.setType(i - 1);
                }
                GuiCreationParts.this.func_231160_c_();
            }
            if (btn.id == 22) {
                this.data.pattern = (byte)btn.getValue();
            }
            if (btn.id == 21) {
                this.data.playerTexture = ((GuiNpcButtonYesNo)btn).getBoolean();
                GuiCreationParts.this.func_231160_c_();
            }
            if (btn.id == 23) {
                GuiCreationParts.this.setSubGui(new GuiModelColor(GuiCreationParts.this, this.data.color, color -> {
                    this.data.color = color;
                }));
            }
        }

        public GuiPart noPlayerOptions() {
            this.hasPlayerOption = false;
            return this;
        }

        public GuiPart noPlayerTypes() {
            this.noPlayerTypes = true;
            return this;
        }

        public GuiPart setTypes(String[] types) {
            this.types = types;
            return this;
        }
    }
}

