/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noppes.npcs.client.gui.SubGuiNpcTextArea;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.server.SPacketNbtBookBlockSave;
import noppes.npcs.packets.server.SPacketNbtBookEntitySave;

public class GuiNbtBook
extends GuiNPCInterface
implements IGuiData {
    private BlockPos pos;
    private TileEntity tile;
    private BlockState state;
    private ItemStack blockStack;
    private int entityId;
    private Entity entity;
    private CompoundNBT originalCompound;
    private CompoundNBT compound;
    private String faultyText = null;
    private String errorMessage = null;

    public GuiNbtBook(BlockPos pos) {
        this.pos = pos;
        this.setBackground("menubg.png");
        this.imageWidth = 256;
        this.imageHeight = 216;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int y = this.guiTop + 40;
        if (this.state != null) {
            this.addLabel(new GuiNpcLabel(11, "x: " + this.pos.func_177958_n() + ", y: " + this.pos.func_177956_o() + ", z: " + this.pos.func_177952_p(), this.guiLeft + 60, this.guiTop + 6));
            this.addLabel(new GuiNpcLabel(12, "id: " + ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.state.func_177230_c()), this.guiLeft + 60, this.guiTop + 16));
        }
        if (this.entity != null) {
            this.addLabel(new GuiNpcLabel(12, "id: " + this.entity.func_200600_R().func_210760_d(), this.guiLeft + 60, this.guiTop + 6));
        }
        this.addButton(new GuiNpcButton(this, 0, this.guiLeft + 38, this.guiTop + 144, 180, 20, "nbt.edit"));
        this.getButton((int)0).field_230693_o_ = this.compound != null && !this.compound.isEmpty();
        this.addLabel(new GuiNpcLabel(0, "", this.guiLeft + 4, this.guiTop + 167));
        this.addLabel(new GuiNpcLabel(1, "", this.guiLeft + 4, this.guiTop + 177));
        this.addButton(new GuiNpcButton(this, 66, this.guiLeft + 128, this.guiTop + 190, 120, 20, "gui.close"));
        this.addButton(new GuiNpcButton(this, 67, this.guiLeft + 4, this.guiTop + 190, 120, 20, "gui.save"));
        if (this.errorMessage != null) {
            this.getButton((int)67).field_230693_o_ = false;
            int i = this.errorMessage.indexOf(" at: ");
            if (i > 0) {
                this.getLabel((int)0).label = new TranslationTextComponent(this.errorMessage.substring(0, i));
                this.getLabel((int)1).label = new TranslationTextComponent(this.errorMessage.substring(i));
            } else {
                this.getLabel((int)0).label = new TranslationTextComponent(this.errorMessage);
            }
        }
        if (this.getButton((int)67).field_230693_o_ && this.originalCompound != null) {
            this.getButton((int)67).field_230693_o_ = !this.originalCompound.equals((Object)this.compound);
        }
    }

    @Override
    public void buttonEvent(GuiNpcButton guibutton) {
        int id = guibutton.id;
        if (id == 0) {
            if (this.faultyText != null) {
                this.setSubGui(new SubGuiNpcTextArea(this.compound.toString(), this.faultyText).enableHighlighting());
            } else {
                this.setSubGui(new SubGuiNpcTextArea(this.compound.toString()).enableHighlighting());
            }
        }
        if (id == 67) {
            this.getLabel((int)0).label = new TranslationTextComponent("Saved");
            if (this.compound.equals((Object)this.originalCompound)) {
                return;
            }
            if (this.tile == null) {
                Packets.sendServer(new SPacketNbtBookEntitySave(this.entityId, this.compound));
                return;
            }
            Packets.sendServer(new SPacketNbtBookBlockSave(this.pos, this.compound));
            this.originalCompound = this.compound.func_74737_b();
            this.getButton((int)67).field_230693_o_ = false;
        }
        if (id == 66) {
            this.close();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.hasSubGui()) {
            return;
        }
        if (this.state != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(this.guiLeft + 4), (float)(this.guiTop + 4), (float)0.0f);
            RenderSystem.scalef((float)3.0f, (float)3.0f, (float)3.0f);
            this.field_230707_j_.func_180450_b(this.blockStack, 0, 0);
            this.field_230707_j_.func_175030_a(this.field_230712_o_, this.blockStack, 0, 0);
            RenderSystem.popMatrix();
        }
        if (this.entity instanceof LivingEntity) {
            this.drawNpc((LivingEntity)this.entity, 20, 80, 1.0f, 0);
        }
    }

    @Override
    public void closeSubGui(SubGuiInterface gui) {
        super.closeSubGui(gui);
        if (gui instanceof SubGuiNpcTextArea) {
            try {
                this.compound = JsonToNBT.func_180713_a((String)((SubGuiNpcTextArea)gui).text);
                this.faultyText = null;
                this.errorMessage = null;
            }
            catch (CommandSyntaxException e) {
                this.errorMessage = e.getLocalizedMessage();
                this.faultyText = ((SubGuiNpcTextArea)gui).text;
            }
            this.func_231160_c_();
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void setGuiData(CompoundNBT compound) {
        if (compound.func_74764_b("EntityId")) {
            this.entityId = compound.func_74762_e("EntityId");
            this.entity = this.player.field_70170_p.func_73045_a(this.entityId);
        } else {
            this.tile = this.player.field_70170_p.func_175625_s(this.pos);
            this.state = this.player.field_70170_p.func_180495_p(this.pos);
            this.blockStack = this.state.func_177230_c().func_185473_a((IBlockReader)this.player.field_70170_p, this.pos, this.state);
        }
        this.originalCompound = compound.func_74775_l("Data");
        this.compound = this.originalCompound.func_74737_b();
        this.func_231160_c_();
    }
}

