/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabFactions;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabQuests;
import micdoodle8.mods.galacticraft.api.client.tabs.InventoryTabVanilla;
import micdoodle8.mods.galacticraft.api.client.tabs.TabRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.network.NetworkEvent;
import noppes.npcs.CommonProxy;
import noppes.npcs.CustomContainer;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomTabs;
import noppes.npcs.LogWriter;
import noppes.npcs.ModelData;
import noppes.npcs.ModelPartData;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemScripted;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.client.ClientTickHandler;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.CustomTileEntityItemStackRenderer;
import noppes.npcs.client.VersionChecker;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.controllers.PresetController;
import noppes.npcs.client.fx.EntityEnderFX;
import noppes.npcs.client.gui.GuiBlockBuilder;
import noppes.npcs.client.gui.GuiBlockCopy;
import noppes.npcs.client.gui.GuiBorderBlock;
import noppes.npcs.client.gui.GuiMerchantAdd;
import noppes.npcs.client.gui.GuiNbtBook;
import noppes.npcs.client.gui.GuiNpcDimension;
import noppes.npcs.client.gui.GuiNpcMobSpawner;
import noppes.npcs.client.gui.GuiNpcMobSpawnerMounter;
import noppes.npcs.client.gui.GuiNpcPather;
import noppes.npcs.client.gui.GuiNpcRedstoneBlock;
import noppes.npcs.client.gui.GuiNpcRemoteEditor;
import noppes.npcs.client.gui.GuiNpcWaypoint;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.global.GuiNPCManageBanks;
import noppes.npcs.client.gui.global.GuiNPCManageDialogs;
import noppes.npcs.client.gui.global.GuiNPCManageFactions;
import noppes.npcs.client.gui.global.GuiNPCManageLinkedNpc;
import noppes.npcs.client.gui.global.GuiNPCManageQuest;
import noppes.npcs.client.gui.global.GuiNPCManageTransporters;
import noppes.npcs.client.gui.global.GuiNpcManageRecipes;
import noppes.npcs.client.gui.global.GuiNpcQuestReward;
import noppes.npcs.client.gui.mainmenu.GuiNPCGlobalMainMenu;
import noppes.npcs.client.gui.mainmenu.GuiNPCInv;
import noppes.npcs.client.gui.mainmenu.GuiNpcAI;
import noppes.npcs.client.gui.mainmenu.GuiNpcAdvanced;
import noppes.npcs.client.gui.mainmenu.GuiNpcDisplay;
import noppes.npcs.client.gui.mainmenu.GuiNpcStats;
import noppes.npcs.client.gui.player.GuiMailbox;
import noppes.npcs.client.gui.player.GuiMailmanWrite;
import noppes.npcs.client.gui.player.GuiNPCBankChest;
import noppes.npcs.client.gui.player.GuiNPCTrader;
import noppes.npcs.client.gui.player.GuiNpcCarpentryBench;
import noppes.npcs.client.gui.player.GuiNpcFollower;
import noppes.npcs.client.gui.player.GuiNpcFollowerHire;
import noppes.npcs.client.gui.player.GuiTransportSelection;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionInv;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionStats;
import noppes.npcs.client.gui.player.companion.GuiNpcCompanionTalents;
import noppes.npcs.client.gui.questtypes.GuiNpcQuestTypeItem;
import noppes.npcs.client.gui.roles.GuiNpcBankSetup;
import noppes.npcs.client.gui.roles.GuiNpcFollowerSetup;
import noppes.npcs.client.gui.roles.GuiNpcItemGiver;
import noppes.npcs.client.gui.roles.GuiNpcTraderSetup;
import noppes.npcs.client.gui.roles.GuiNpcTransporter;
import noppes.npcs.client.gui.script.GuiScript;
import noppes.npcs.client.gui.script.GuiScriptBlock;
import noppes.npcs.client.gui.script.GuiScriptDoor;
import noppes.npcs.client.gui.script.GuiScriptGlobal;
import noppes.npcs.client.gui.script.GuiScriptItem;
import noppes.npcs.client.model.ModelClassicPlayer;
import noppes.npcs.client.model.ModelNPCGolem;
import noppes.npcs.client.model.ModelNpcCrystal;
import noppes.npcs.client.model.ModelNpcDragon;
import noppes.npcs.client.model.ModelNpcSlime;
import noppes.npcs.client.model.ModelPlayer64x32;
import noppes.npcs.client.model.ModelPony;
import noppes.npcs.client.renderer.RenderCustomNpc;
import noppes.npcs.client.renderer.RenderNPCInterface;
import noppes.npcs.client.renderer.RenderNPCPony;
import noppes.npcs.client.renderer.RenderNpcCrystal;
import noppes.npcs.client.renderer.RenderNpcDragon;
import noppes.npcs.client.renderer.RenderNpcSlime;
import noppes.npcs.client.renderer.RenderProjectile;
import noppes.npcs.config.TrueTypeFont;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.mixin.ArmorLayerMixin;
import noppes.npcs.packets.PacketBasic;

public class ClientProxy
extends CommonProxy {
    public static PlayerData playerData = new PlayerData();
    public static KeyBinding QuestLog;
    public static KeyBinding Scene1;
    public static KeyBinding SceneReset;
    public static KeyBinding Scene2;
    public static KeyBinding Scene3;
    public static FontContainer Font;
    public static ModelData data;
    public static PlayerModel playerModel;
    public static ArmorLayerMixin armorLayer;

    @Override
    public void load() {
        Font = new FontContainer(CustomNpcs.FontType, CustomNpcs.FontSize);
        this.createFolders();
        CustomNpcResourceListener listener = new CustomNpcResourceListener();
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)listener);
        listener.func_195410_a(Minecraft.func_71410_x().func_195551_G());
        SimpleReloadableResourceManager rmanager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_195551_G();
        rmanager.func_199021_a((IResourcePack)new FolderPack(CustomNpcs.Dir));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityNpcPony, manager -> new RenderNPCPony(manager, new ModelPony()));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityNpcCrystal, manager -> new RenderNpcCrystal(manager, new ModelNpcCrystal()));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityNpcDragon, manager -> new RenderNpcDragon(manager, new ModelNpcDragon(), 0.5f));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityNpcSlime, manager -> new RenderNpcSlime(manager, new ModelNpcSlime(16), (Model)new ModelNpcSlime(0), 0.25f));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityProjectile, manager -> new RenderProjectile(manager));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityCustomNpc, manager -> new RenderCustomNpc(manager, new PlayerModel(0.0f, false)));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityNPC64x32, manager -> new RenderCustomNpc(manager, new ModelPlayer64x32()));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityNPCGolem, manager -> new RenderNPCInterface(manager, new ModelNPCGolem(0.0f), 0.0f));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityNpcAlex, manager -> new RenderCustomNpc(manager, new PlayerModel(0.0f, true)));
        RenderingRegistry.registerEntityRenderingHandler(CustomEntities.entityNpcClassicPlayer, manager -> new RenderCustomNpc(manager, new ModelClassicPlayer(0.0f)));
        ScreenManager.func_216911_a(CustomContainer.container_carpentrybench, GuiNpcCarpentryBench::new);
        ScreenManager.func_216911_a(CustomContainer.container_customgui, GuiCustom::new);
        ScreenManager.func_216911_a(CustomContainer.container_mail, GuiMailmanWrite::new);
        ScreenManager.func_216911_a(CustomContainer.container_managebanks, GuiNPCManageBanks::new);
        ScreenManager.func_216911_a(CustomContainer.container_managerecipes, GuiNpcManageRecipes::new);
        ScreenManager.func_216911_a(CustomContainer.container_merchantadd, GuiMerchantAdd::new);
        ScreenManager.func_216911_a(CustomContainer.container_banklarge, GuiNPCBankChest::new);
        ScreenManager.func_216911_a(CustomContainer.container_banksmall, GuiNPCBankChest::new);
        ScreenManager.func_216911_a(CustomContainer.container_bankunlock, GuiNPCBankChest::new);
        ScreenManager.func_216911_a(CustomContainer.container_bankupgrade, GuiNPCBankChest::new);
        ScreenManager.func_216911_a(CustomContainer.container_companion, GuiNpcCompanionInv::new);
        ScreenManager.func_216911_a(CustomContainer.container_follower, GuiNpcFollower::new);
        ScreenManager.func_216911_a(CustomContainer.container_followerhire, GuiNpcFollowerHire::new);
        ScreenManager.func_216911_a(CustomContainer.container_followersetup, GuiNpcFollowerSetup::new);
        ScreenManager.func_216911_a(CustomContainer.container_inv, GuiNPCInv::new);
        ScreenManager.func_216911_a(CustomContainer.container_itemgiver, GuiNpcItemGiver::new);
        ScreenManager.func_216911_a(CustomContainer.container_questreward, GuiNpcQuestReward::new);
        ScreenManager.func_216911_a(CustomContainer.container_questtypeitem, GuiNpcQuestTypeItem::new);
        ScreenManager.func_216911_a(CustomContainer.container_trader, GuiNPCTrader::new);
        ScreenManager.func_216911_a(CustomContainer.container_tradersetup, GuiNpcTraderSetup::new);
        new MusicController();
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        Minecraft mc = Minecraft.func_71410_x();
        QuestLog = new KeyBinding("Quest Log", 76, "key.categories.gameplay");
        if (CustomNpcs.SceneButtonsEnabled) {
            Scene1 = new KeyBinding("Scene1 start/pause", 321, "key.categories.gameplay");
            Scene2 = new KeyBinding("Scene2 start/pause", 322, "key.categories.gameplay");
            Scene3 = new KeyBinding("Scene3 start/pause", 323, "key.categories.gameplay");
            SceneReset = new KeyBinding("Scene reset", 320, "key.categories.gameplay");
            ClientRegistry.registerKeyBinding((KeyBinding)Scene1);
            ClientRegistry.registerKeyBinding((KeyBinding)Scene2);
            ClientRegistry.registerKeyBinding((KeyBinding)Scene3);
            ClientRegistry.registerKeyBinding((KeyBinding)SceneReset);
        }
        ClientRegistry.registerKeyBinding((KeyBinding)QuestLog);
        new PresetController(CustomNpcs.Dir);
        if (CustomNpcs.EnableUpdateChecker) {
            VersionChecker checker = new VersionChecker();
            checker.start();
        }
        PixelmonHelper.loadClient();
    }

    @Override
    public PlayerData getPlayerData(PlayerEntity player) {
        if (player.func_110124_au() == Minecraft.func_71410_x().field_71439_g.func_110124_au()) {
            if (ClientProxy.playerData.player != player) {
                ClientProxy.playerData.player = player;
            }
            return playerData;
        }
        return null;
    }

    @Override
    public void postload() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        if (CustomNpcs.InventoryGuiEnabled) {
            TabRegistry.registerEventListeners(MinecraftForge.EVENT_BUS);
            if (TabRegistry.getTabList().isEmpty()) {
                TabRegistry.registerTab(new InventoryTabVanilla());
            }
            TabRegistry.registerTab(new InventoryTabFactions());
            TabRegistry.registerTab(new InventoryTabQuests());
        }
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> 9127187, new IItemProvider[]{CustomItems.mount, CustomItems.cloner, CustomItems.moving, CustomItems.scripter, CustomItems.wand, CustomItems.teleporter});
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            IItemStack item;
            if (stack.func_77973_b() == CustomItems.scripted_item && !(item = NpcAPI.Instance().getIItemStack(stack)).isEmpty()) {
                return ((IItemScripted)item).getColor();
            }
            return -1;
        }, new IItemProvider[]{CustomItems.scripted_item});
    }

    private void createFolders() {
        File meta;
        File json;
        File check;
        File file = new File(CustomNpcs.Dir, "assets/customnpcs");
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(check = new File(file, "sounds")).exists()) {
            check.mkdir();
        }
        if (!(json = new File(file, "sounds.json")).exists()) {
            try {
                json.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(json));
                writer.write("{\n\n}");
                writer.close();
            }
            catch (IOException writer) {
                // empty catch block
            }
        }
        if (!(meta = new File(CustomNpcs.Dir, "pack.mcmeta")).exists()) {
            try {
                meta.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(meta));
                writer.write("{\n    \"pack\": {\n        \"description\": \"customnpcs map resource pack\",\n        \"pack_format\": 6\n    }\n}");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(check = new File(file, "textures")).exists()) {
            check.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Screen getGui(EnumGuiType gui, EntityNPCInterface npc, PacketBuffer buf) {
        try {
            if (gui == EnumGuiType.MainMenuDisplay) {
                if (npc != null) {
                    GuiNpcDisplay guiNpcDisplay = new GuiNpcDisplay(npc);
                    return guiNpcDisplay;
                }
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("Unable to find npc"), Util.field_240973_b_);
            } else {
                if (gui == EnumGuiType.MainMenuStats) {
                    GuiNpcStats guiNpcStats = new GuiNpcStats(npc);
                    return guiNpcStats;
                }
                if (gui == EnumGuiType.MainMenuAdvanced) {
                    GuiNpcAdvanced guiNpcAdvanced = new GuiNpcAdvanced(npc);
                    return guiNpcAdvanced;
                }
                if (gui == EnumGuiType.MovingPath) {
                    GuiNpcPather guiNpcPather = new GuiNpcPather(npc);
                    return guiNpcPather;
                }
                if (gui == EnumGuiType.ManageFactions) {
                    GuiNPCManageFactions guiNPCManageFactions = new GuiNPCManageFactions(npc);
                    return guiNPCManageFactions;
                }
                if (gui == EnumGuiType.ManageLinked) {
                    GuiNPCManageLinkedNpc guiNPCManageLinkedNpc = new GuiNPCManageLinkedNpc(npc);
                    return guiNPCManageLinkedNpc;
                }
                if (gui == EnumGuiType.BuilderBlock) {
                    GuiBlockBuilder guiBlockBuilder = new GuiBlockBuilder(buf.func_179259_c());
                    return guiBlockBuilder;
                }
                if (gui == EnumGuiType.ManageTransport) {
                    GuiNPCManageTransporters guiNPCManageTransporters = new GuiNPCManageTransporters(npc);
                    return guiNPCManageTransporters;
                }
                if (gui == EnumGuiType.ManageDialogs) {
                    GuiNPCManageDialogs guiNPCManageDialogs = new GuiNPCManageDialogs(npc);
                    return guiNPCManageDialogs;
                }
                if (gui == EnumGuiType.ManageQuests) {
                    GuiNPCManageQuest guiNPCManageQuest = new GuiNPCManageQuest(npc);
                    return guiNPCManageQuest;
                }
                if (gui == EnumGuiType.Companion) {
                    GuiNpcCompanionStats guiNpcCompanionStats = new GuiNpcCompanionStats(npc);
                    return guiNpcCompanionStats;
                }
                if (gui == EnumGuiType.CompanionTalent) {
                    GuiNpcCompanionTalents guiNpcCompanionTalents = new GuiNpcCompanionTalents(npc);
                    return guiNpcCompanionTalents;
                }
                if (gui == EnumGuiType.MainMenuGlobal) {
                    GuiNPCGlobalMainMenu guiNPCGlobalMainMenu = new GuiNPCGlobalMainMenu(npc);
                    return guiNPCGlobalMainMenu;
                }
                if (gui == EnumGuiType.MainMenuAI) {
                    GuiNpcAI guiNpcAI = new GuiNpcAI(npc);
                    return guiNpcAI;
                }
                if (gui == EnumGuiType.PlayerTransporter) {
                    GuiTransportSelection guiTransportSelection = new GuiTransportSelection(npc);
                    return guiTransportSelection;
                }
                if (gui == EnumGuiType.Script) {
                    GuiScript guiScript = new GuiScript(npc);
                    return guiScript;
                }
                if (gui == EnumGuiType.ScriptBlock) {
                    GuiScriptBlock guiScriptBlock = new GuiScriptBlock(buf.func_179259_c());
                    return guiScriptBlock;
                }
                if (gui == EnumGuiType.ScriptItem) {
                    GuiScriptItem guiScriptItem = new GuiScriptItem((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                    return guiScriptItem;
                }
                if (gui == EnumGuiType.ScriptDoor) {
                    GuiScriptDoor guiScriptDoor = new GuiScriptDoor(buf.func_179259_c());
                    return guiScriptDoor;
                }
                if (gui == EnumGuiType.ScriptPlayers) {
                    GuiScriptGlobal guiScriptGlobal = new GuiScriptGlobal();
                    return guiScriptGlobal;
                }
                if (gui == EnumGuiType.SetupTransporter) {
                    GuiNpcTransporter guiNpcTransporter = new GuiNpcTransporter(npc);
                    return guiNpcTransporter;
                }
                if (gui == EnumGuiType.SetupBank) {
                    GuiNpcBankSetup guiNpcBankSetup = new GuiNpcBankSetup(npc);
                    return guiNpcBankSetup;
                }
                if (gui == EnumGuiType.NpcRemote && Minecraft.func_71410_x().field_71462_r == null) {
                    GuiNpcRemoteEditor guiNpcRemoteEditor = new GuiNpcRemoteEditor();
                    return guiNpcRemoteEditor;
                }
                if (gui == EnumGuiType.PlayerMailbox) {
                    GuiMailbox guiMailbox = new GuiMailbox();
                    return guiMailbox;
                }
                if (gui == EnumGuiType.NpcDimensions) {
                    GuiNpcDimension guiNpcDimension = new GuiNpcDimension();
                    return guiNpcDimension;
                }
                if (gui == EnumGuiType.Border) {
                    GuiBorderBlock guiBorderBlock = new GuiBorderBlock(buf.func_179259_c());
                    return guiBorderBlock;
                }
                if (gui == EnumGuiType.RedstoneBlock) {
                    GuiNpcRedstoneBlock guiNpcRedstoneBlock = new GuiNpcRedstoneBlock(buf.func_179259_c());
                    return guiNpcRedstoneBlock;
                }
                if (gui == EnumGuiType.MobSpawner) {
                    GuiNpcMobSpawner guiNpcMobSpawner = new GuiNpcMobSpawner(buf.func_179259_c());
                    return guiNpcMobSpawner;
                }
                if (gui == EnumGuiType.CopyBlock) {
                    GuiBlockCopy guiBlockCopy = new GuiBlockCopy(buf.func_179259_c());
                    return guiBlockCopy;
                }
                if (gui == EnumGuiType.MobSpawnerMounter) {
                    GuiNpcMobSpawnerMounter guiNpcMobSpawnerMounter = new GuiNpcMobSpawnerMounter();
                    return guiNpcMobSpawnerMounter;
                }
                if (gui == EnumGuiType.Waypoint) {
                    GuiNpcWaypoint guiNpcWaypoint = new GuiNpcWaypoint(buf.func_179259_c());
                    return guiNpcWaypoint;
                }
                if (gui == EnumGuiType.NbtBook) {
                    GuiNbtBook guiNbtBook = new GuiNbtBook(buf.func_179259_c());
                    return guiNbtBook;
                }
            }
            Screen screen = null;
            return screen;
        }
        finally {
            if (buf != null) {
                buf.release();
            }
        }
    }

    @Override
    public void openGui(PlayerEntity player, EnumGuiType gui) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71439_g != player) {
            return;
        }
        Screen screen = ClientProxy.getGui(gui, null, null);
        if (screen != null) {
            minecraft.func_147108_a(screen);
        }
    }

    @Override
    public void openGui(EntityNPCInterface npc, EnumGuiType gui) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_147108_a(ClientProxy.getGui(gui, npc, null));
    }

    @Override
    public void openGui(PlayerEntity player, Object guiscreen) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!player.field_70170_p.field_72995_K || !(guiscreen instanceof Screen)) {
            return;
        }
        if (guiscreen != null) {
            minecraft.func_147108_a((Screen)guiscreen);
        }
    }

    @Override
    public void spawnParticle(LivingEntity player, String string, Object ... ob) {
        if (string.equals("Block")) {
            BlockPos pos = (BlockPos)ob[0];
            BlockState state = (BlockState)ob[1];
            Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, state);
        } else if (string.equals("ModelData")) {
            ModelData data = (ModelData)ob[0];
            ModelPartData particles = (ModelPartData)ob[1];
            EntityCustomNpc npc = (EntityCustomNpc)player;
            Minecraft minecraft = Minecraft.func_71410_x();
            double height = npc.func_70033_W() + (double)data.getBodyY();
            Random rand = npc.func_70681_au();
            for (int i = 0; i < 2; ++i) {
                EntityEnderFX fx = new EntityEnderFX(npc, (rand.nextDouble() - 0.5) * (double)player.func_213311_cf(), rand.nextDouble() * (double)player.func_213302_cg() - height - 0.25, (rand.nextDouble() - 0.5) * (double)player.func_213311_cf(), (rand.nextDouble() - 0.5) * 2.0, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 2.0, particles);
                minecraft.field_71452_i.func_78873_a((Particle)fx);
            }
        }
    }

    @Override
    public boolean hasClient() {
        return true;
    }

    @Override
    public PlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void bind(ResourceLocation location) {
        try {
            if (location == null) {
                return;
            }
            TextureManager manager = Minecraft.func_71410_x().func_110434_K();
            Texture ob = manager.func_229267_b_(location);
            if (ob == null) {
                ob = new SimpleTexture(location);
                manager.func_229263_a_(location, ob);
            }
            RenderSystem.bindTexture((int)ob.func_110552_b());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void spawnParticle(BasicParticleType particle, double x, double y, double z, double motionX, double motionY, double motionZ, float scale) {
        double zz;
        double yy;
        Minecraft mc = Minecraft.func_71410_x();
        double xx = mc.func_175606_aa().func_226277_ct_() - x;
        if (xx * xx + (yy = mc.func_175606_aa().func_226278_cu_() - y) * yy + (zz = mc.func_175606_aa().func_226281_cx_() - z) * zz > 256.0) {
            return;
        }
        Particle fx = mc.field_71452_i.func_199280_a((IParticleData)particle, x, y, z, motionX, motionY, motionZ);
        if (fx == null) {
            return;
        }
        if (particle == ParticleTypes.field_197631_x) {
            fx.func_70541_f(1.0E-5f);
        } else if (particle == ParticleTypes.field_197601_L) {
            fx.func_70541_f(1.0E-5f);
        }
    }

    @Override
    public Item.Properties getItemProperties() {
        Supplier<Callable> teisr = () -> () -> CustomTileEntityItemStackRenderer.i;
        return new Item.Properties().setISTER(teisr).func_200916_a(CustomTabs.tab);
    }

    @Override
    public void handlePacket(PacketBasic msg, Supplier<NetworkEvent.Context> ctx) {
        msg.player = Minecraft.func_71410_x().field_71439_g;
        msg.handle();
    }

    public static class FontContainer {
        private TrueTypeFont textFont = null;
        public boolean useCustomFont = true;

        private FontContainer() {
        }

        public FontContainer(String fontType, int fontSize) {
            try {
                this.textFont = new TrueTypeFont(new Font(fontType, 0, fontSize), 1.0f);
                boolean bl = this.useCustomFont = !fontType.equalsIgnoreCase("minecraft");
                if (!this.useCustomFont || fontType.isEmpty() || fontType.equalsIgnoreCase("default")) {
                    this.textFont = new TrueTypeFont(new ResourceLocation("customnpcs", "opensans.ttf"), fontSize, 1.0f);
                }
            }
            catch (Throwable e) {
                LogWriter.except(e);
                this.useCustomFont = false;
            }
        }

        public int height(String text) {
            if (this.useCustomFont) {
                return this.textFont.height(text);
            }
            Minecraft.func_71410_x().field_71466_p.getClass();
            return 9;
        }

        public int width(String text) {
            if (this.useCustomFont) {
                return this.textFont.width(text);
            }
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        }

        public FontContainer copy() {
            FontContainer font = new FontContainer();
            font.textFont = this.textFont;
            font.useCustomFont = this.useCustomFont;
            return font;
        }

        public void draw(MatrixStack matrixStack, String text, int x, int y, int color) {
            if (this.useCustomFont) {
                this.textFont.draw(text, x, y, color);
            } else {
                Minecraft.func_71410_x().field_71466_p.func_238405_a_(matrixStack, text, (float)x, (float)y, color);
            }
        }

        public String getName() {
            if (!this.useCustomFont) {
                return "Minecraft";
            }
            return this.textFont.getFontName();
        }

        public void clear() {
            if (this.textFont != null) {
                this.textFont.dispose();
            }
        }
    }
}

