/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IEntityLiving;
import noppes.npcs.api.entity.data.IMark;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.controllers.data.MarkData;

public class EntityLivingBaseWrapper<T extends LivingEntity>
extends EntityWrapper<T>
implements IEntityLiving {
    public EntityLivingBaseWrapper(T entity) {
        super(entity);
    }

    @Override
    public float getHealth() {
        return ((LivingEntity)this.entity).func_110143_aJ();
    }

    @Override
    public void setHealth(float health) {
        ((LivingEntity)this.entity).func_70606_j(health);
    }

    @Override
    public float getMaxHealth() {
        return ((LivingEntity)this.entity).func_110138_aP();
    }

    @Override
    public void setMaxHealth(float health) {
        if (health < 0.0f) {
            return;
        }
        ((LivingEntity)this.entity).func_110148_a(Attributes.field_233818_a_).func_111128_a((double)health);
    }

    @Override
    public boolean isAttacking() {
        return ((LivingEntity)this.entity).func_70643_av() != null;
    }

    @Override
    public void setAttackTarget(IEntityLiving living) {
        if (living == null) {
            ((LivingEntity)this.entity).func_70604_c(null);
        } else {
            ((LivingEntity)this.entity).func_70604_c(living.getMCEntity());
        }
    }

    @Override
    public IEntityLiving getAttackTarget() {
        return (IEntityLiving)NpcAPI.Instance().getIEntity((Entity)((LivingEntity)this.entity).func_70643_av());
    }

    @Override
    public IEntityLiving getLastAttacked() {
        return (IEntityLiving)NpcAPI.Instance().getIEntity((Entity)((LivingEntity)this.entity).func_110144_aD());
    }

    @Override
    public int getLastAttackedTime() {
        return ((LivingEntity)this.entity).func_142013_aG();
    }

    @Override
    public boolean canSeeEntity(IEntity entity) {
        return ((LivingEntity)this.entity).func_70685_l(entity.getMCEntity());
    }

    @Override
    public void swingMainhand() {
        ((LivingEntity)this.entity).func_184609_a(Hand.MAIN_HAND);
    }

    @Override
    public void swingOffhand() {
        ((LivingEntity)this.entity).func_184609_a(Hand.OFF_HAND);
    }

    @Override
    public void addPotionEffect(int effect, int duration, int strength, boolean hideParticles) {
        Effect p = Effect.func_188412_a((int)effect);
        if (p == null) {
            return;
        }
        if (strength < 0) {
            strength = 0;
        } else if (strength > 255) {
            strength = 255;
        }
        if (duration < 0) {
            duration = 0;
        } else if (duration > 1000000) {
            duration = 1000000;
        }
        if (!p.func_76403_b()) {
            duration *= 20;
        }
        if (duration == 0) {
            ((LivingEntity)this.entity).func_195063_d(p);
        } else {
            ((LivingEntity)this.entity).func_195064_c(new EffectInstance(p, duration, strength, false, hideParticles));
        }
    }

    @Override
    public void clearPotionEffects() {
        ((LivingEntity)this.entity).func_195061_cb();
    }

    @Override
    public int getPotionEffect(int effect) {
        EffectInstance pf = ((LivingEntity)this.entity).func_70660_b(Effect.func_188412_a((int)effect));
        if (pf == null) {
            return -1;
        }
        return pf.func_76458_c();
    }

    @Override
    public IItemStack getMainhandItem() {
        return NpcAPI.Instance().getIItemStack(((LivingEntity)this.entity).func_184614_ca());
    }

    @Override
    public void setMainhandItem(IItemStack item) {
        ((LivingEntity)this.entity).func_184611_a(Hand.MAIN_HAND, item == null ? ItemStack.field_190927_a : item.getMCItemStack());
    }

    @Override
    public IItemStack getOffhandItem() {
        return NpcAPI.Instance().getIItemStack(((LivingEntity)this.entity).func_184592_cb());
    }

    @Override
    public void setOffhandItem(IItemStack item) {
        ((LivingEntity)this.entity).func_184611_a(Hand.OFF_HAND, item == null ? ItemStack.field_190927_a : item.getMCItemStack());
    }

    @Override
    public IItemStack getArmor(int slot) {
        if (slot < 0 || slot > 3) {
            throw new CustomNPCsException("Wrong slot id:" + slot, new Object[0]);
        }
        return NpcAPI.Instance().getIItemStack(((LivingEntity)this.entity).func_184582_a(this.getSlot(slot)));
    }

    @Override
    public void setArmor(int slot, IItemStack item) {
        if (slot < 0 || slot > 3) {
            throw new CustomNPCsException("Wrong slot id:" + slot, new Object[0]);
        }
        ((LivingEntity)this.entity).func_184201_a(this.getSlot(slot), item == null ? ItemStack.field_190927_a : item.getMCItemStack());
    }

    private EquipmentSlotType getSlot(int slot) {
        if (slot == 3) {
            return EquipmentSlotType.HEAD;
        }
        if (slot == 2) {
            return EquipmentSlotType.CHEST;
        }
        if (slot == 1) {
            return EquipmentSlotType.LEGS;
        }
        if (slot == 0) {
            return EquipmentSlotType.FEET;
        }
        return null;
    }

    @Override
    public float getRotation() {
        return ((LivingEntity)this.entity).field_70761_aq;
    }

    @Override
    public void setRotation(float rotation) {
        ((LivingEntity)this.entity).field_70761_aq = rotation;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public boolean typeOf(int type) {
        return type == 5 ? true : super.typeOf(type);
    }

    @Override
    public boolean isChild() {
        return ((LivingEntity)this.entity).func_70631_g_();
    }

    @Override
    public IMark addMark(int type) {
        MarkData data = MarkData.get((LivingEntity)this.entity);
        return data.addMark(type);
    }

    @Override
    public void removeMark(IMark mark) {
        MarkData data = MarkData.get((LivingEntity)this.entity);
        data.marks.remove(mark);
        data.syncClients();
    }

    @Override
    public IMark[] getMarks() {
        MarkData data = MarkData.get((LivingEntity)this.entity);
        return data.marks.toArray(new IMark[data.marks.size()]);
    }

    @Override
    public float getMoveForward() {
        return ((LivingEntity)this.entity).field_191988_bg;
    }

    @Override
    public void setMoveForward(float move) {
        ((LivingEntity)this.entity).field_191988_bg = move;
    }

    @Override
    public float getMoveStrafing() {
        return ((LivingEntity)this.entity).field_70702_br;
    }

    @Override
    public void setMoveStrafing(float move) {
        ((LivingEntity)this.entity).field_70702_br = move;
    }

    @Override
    public float getMoveVertical() {
        return ((LivingEntity)this.entity).field_70701_bs;
    }

    @Override
    public void setMoveVertical(float move) {
        ((LivingEntity)this.entity).field_70701_bs = move;
    }
}

