/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noppes.npcs.api.ITimers;
import noppes.npcs.api.block.IBlockScriptedDoor;
import noppes.npcs.api.wrapper.BlockWrapper;
import noppes.npcs.blocks.tiles.TileScriptedDoor;

public class BlockScriptedDoorWrapper
extends BlockWrapper
implements IBlockScriptedDoor {
    private TileScriptedDoor tile;

    public BlockScriptedDoorWrapper(World level, Block block, BlockPos pos) {
        super(level, block, pos);
        this.tile = (TileScriptedDoor)((BlockWrapper)this).tile;
    }

    @Override
    public boolean getOpen() {
        BlockState state = this.level.getMCWorld().func_180495_p(this.pos);
        return ((Boolean)state.func_177229_b((Property)DoorBlock.field_176519_b)).equals(true);
    }

    @Override
    public void setOpen(boolean open) {
        if (this.getOpen() == open || this.isRemoved()) {
            return;
        }
        BlockState state = this.level.getMCWorld().func_180495_p(this.pos);
        ((DoorBlock)this.block).func_242663_a((World)this.level.getMCWorld(), state, this.pos, open);
    }

    @Override
    public void setBlockModel(String name) {
        Block b = null;
        if (name != null) {
            b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
        }
        this.tile.setItemModel(b);
    }

    @Override
    public String getBlockModel() {
        return ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.tile.blockModel) + "";
    }

    @Override
    public ITimers getTimers() {
        return this.tile.timers;
    }

    @Override
    public float getHardness() {
        return this.tile.blockHardness;
    }

    @Override
    public void setHardness(float hardness) {
        this.tile.blockHardness = hardness;
    }

    @Override
    public float getResistance() {
        return this.tile.blockResistance;
    }

    @Override
    public void setResistance(float resistance) {
        this.tile.blockResistance = resistance;
    }

    @Override
    protected void setTile(TileEntity tile) {
        this.tile = (TileScriptedDoor)tile;
        super.setTile(tile);
    }
}

