/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.network.packets.player.aura;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcdbc.controllers.AuraController;
import kamkeel.npcdbc.data.aura.Aura;
import kamkeel.npcdbc.network.AbstractPacket;
import kamkeel.npcdbc.network.DBCPacketHandler;
import kamkeel.npcdbc.network.NetworkUtility;
import kamkeel.npcdbc.network.PacketChannel;
import kamkeel.npcdbc.network.packets.EnumPacketPlayer;
import kamkeel.npcs.network.packets.data.large.GuiDataPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public final class DBCRequestAura
extends AbstractPacket {
    public static final String packetName = "NPC|RequestAura";
    private int auraID;
    private boolean onlyPlayers;

    public DBCRequestAura(int auraID, boolean players) {
        this.auraID = auraID;
        this.onlyPlayers = players;
    }

    public DBCRequestAura() {
    }

    @Override
    public Enum getType() {
        return EnumPacketPlayer.AuraList;
    }

    @Override
    public PacketChannel getChannel() {
        return DBCPacketHandler.PLAYER_PACKETS;
    }

    @Override
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.auraID);
        out.writeBoolean(this.onlyPlayers);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        this.auraID = in.readInt();
        this.onlyPlayers = in.readBoolean();
        if (this.auraID != -1) {
            Aura aura = (Aura)AuraController.getInstance().get(this.auraID);
            if (aura != null) {
                NBTTagCompound compound = aura.writeToNBT();
                compound.func_74778_a("PACKETTYPE", "Aura");
                GuiDataPacket.sendGuiData((EntityPlayerMP)((EntityPlayerMP)player), (NBTTagCompound)compound);
            }
        } else if (this.onlyPlayers) {
            NetworkUtility.sendPlayersAuras((EntityPlayer)((EntityPlayerMP)player));
        } else {
            NetworkUtility.sendCustomAuraDataAll((EntityPlayerMP)player);
        }
    }
}

