/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.mixins.late.impl.npc;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import kamkeel.npcdbc.config.ConfigDBCGeneral;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.util.DBCUtils;
import kamkeel.npcs.util.AttributeAttackUtil;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.scripted.event.NpcEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityNPCInterface.class})
public abstract class MixinEntityNPCInterface
extends EntityCreature
implements IEntityAdditionalSpawnData,
ICommandSender,
IRangedAttackMob,
IBossDisplayData {
    @Unique
    private boolean dbcAltered;

    private MixinEntityNPCInterface(World p_i1602_1_) {
        super(p_i1602_1_);
    }

    @Inject(method={"entityInit"}, at={@At(value="RETURN")})
    private void addWatchableObjects(CallbackInfo ci) {
        this.field_70180_af.func_75682_a(31, (Object)1);
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="FIELD", target="Lnoppes/npcs/entity/EntityNPCInterface;wrappedNPC:Lnoppes/npcs/api/entity/ICustomNpc;", shift=At.Shift.BEFORE)})
    public void fixDamagedEventDBCDamage(DamageSource damagesource, float amount, CallbackInfoReturnable<Boolean> cir, @Local(name={"i"}) LocalFloatRef dam) {
        Entity attackerEntity = NoppesUtilServer.GetDamageSource((DamageSource)damagesource);
        if (attackerEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attackerEntity;
            DBCData data = DBCData.get(player);
            this.dbcAltered = data.Powertype == 1;
            if (this.dbcAltered) {
                float modifiedDamage = DBCUtils.calculateAttackStat(player, dam.get(), damagesource);
                EntityNPCInterface npcInterface = (EntityNPCInterface)this;
                modifiedDamage = AttributeAttackUtil.calculateDamagePlayerToNPC((EntityPlayer)player, (EntityNPCInterface)npcInterface, (float)modifiedDamage);
                if (ConfigDBCGeneral.ALLOW_DBC_DAMAGE_RESISTANCE) {
                    modifiedDamage = npcInterface.stats.resistances.applyResistance(damagesource, modifiedDamage);
                }
                dam.set(modifiedDamage);
            }
        }
    }

    @Redirect(method={"attackEntityFrom"}, at=@At(value="INVOKE", target="Lnoppes/npcs/scripted/event/NpcEvent$DamagedEvent;getDamage()F"))
    public float fixDamagedEventDBCDamage(NpcEvent.DamagedEvent instance) {
        if (this.dbcAltered && DBCUtils.npcLastSetDamage == null && !instance.isCancelled()) {
            DBCUtils.npcLastSetDamage = Float.valueOf(instance.getDamage());
        }
        this.dbcAltered = false;
        return instance.getDamage();
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="HEAD")})
    public void resetDamageEntityCalled(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        DBCUtils.damageEntityCalled = false;
    }

    @Inject(method={"attackEntityFrom"}, at={@At(value="RETURN")})
    public void clearNPCDamageIfNeeded(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!DBCUtils.damageEntityCalled) {
            DBCUtils.npcLastSetDamage = null;
        }
    }
}

