/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.effects.types;

import kamkeel.npcdbc.constants.enums.EnumPotaraTypes;
import kamkeel.npcdbc.controllers.BonusController;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.data.dbcdata.DBCData;
import kamkeel.npcdbc.data.effects.AddonEffect;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.controllers.data.PlayerEffect;
import noppes.npcs.scripted.event.player.PlayerEvent;

public class PotaraFusion
extends AddonEffect {
    public PotaraFusion() {
        this.name = "Potara";
        this.langName = "effect.potara";
        this.id = 12;
        this.iconX = 176;
        this.iconY = 0;
    }

    public void onAdded(EntityPlayer player, PlayerEffect playerEffect) {
        EnumPotaraTypes potaraTypes = EnumPotaraTypes.getPotaraFromMeta(playerEffect.level);
        float bonusMulti = potaraTypes.getMulti();
        if (bonusMulti > 0.0f) {
            PlayerBonus bonus = new PlayerBonus(this.name, 0, bonusMulti, bonusMulti, bonusMulti);
            BonusController.getInstance().applyBonus(player, bonus);
        }
    }

    public void onRemoved(EntityPlayer player, PlayerEffect playerEffect, PlayerEvent.EffectEvent.ExpirationType type) {
        BonusController.getInstance().removeBonus(player, this.name);
    }

    public void onTick(EntityPlayer player, PlayerEffect playerEffect) {
        boolean isFused;
        DBCData dbcData = DBCData.get(player);
        boolean bl = isFused = dbcData.containsSE(10) || dbcData.containsSE(11);
        if (!isFused) {
            playerEffect.kill();
            BonusController.getInstance().removeBonus(player, this.name);
        }
    }
}

