/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.necrotempus.modules.features.bossbar.server;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.github.cruciblemc.necrotempus.NecroTempus;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBar;
import io.github.cruciblemc.necrotempus.api.bossbar.BossBarManager;
import io.github.cruciblemc.necrotempus.modules.features.bossbar.network.BossBarPacket;
import io.github.cruciblemc.necrotempus.utils.ServerUtils;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;

public class BossBarManagerServer
extends BossBarManager {
    @Override
    public void add(UUID target, BossBar bossBar) {
        this.deliver(Collections.singleton(target), new BossBarPacket(bossBar, BossBarPacket.PacketType.ADD));
    }

    @Override
    public void remove(BossBar bossBar) {
        if (!bossBar.isVisible() || this.hasPlayers(bossBar)) {
            this.deliver(this.getPlayers(bossBar), new BossBarPacket(bossBar, BossBarPacket.PacketType.REMOVE));
        }
    }

    @Override
    public void remove(UUID target, BossBar bossBar) {
        this.deliver(Collections.singleton(target), new BossBarPacket(bossBar, BossBarPacket.PacketType.REMOVE));
    }

    @Override
    public void deliver(Set<UUID> players, Object packet) {
        if (packet instanceof BossBarPacket) {
            BossBarPacket bossBarPacket = (BossBarPacket)packet;
            for (UUID uuid : players) {
                EntityPlayerMP entityPlayerMP = ServerUtils.getPlayer(uuid);
                if (entityPlayerMP == null) continue;
                NecroTempus.DISPATCHER.sendTo((IMessage)bossBarPacket, entityPlayerMP);
            }
        }
    }
}

