/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.sheath;

import com.DarknessCrow.main.mainRegistry;
import com.DarknessCrow.sheath.PacketSwordSheath;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PlayerTickHandler {
    private final int TICK_INTERVAL = 10;
    private final double RANGE = 32.0;
    private final Map<UUID, Integer> tickMap = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        UUID uuid = player.func_110124_au();
        int counter = this.tickMap.getOrDefault(uuid, 0) + 1;
        if (counter < 10) {
            this.tickMap.put(uuid, counter);
            return;
        }
        this.tickMap.put(uuid, 0);
        this.sendSwordPacket(player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = event.player;
        this.sendSwordPacket(player);
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!(event.player instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = event.player;
        UUID uuid = player.func_110124_au();
        this.tickMap.remove(uuid);
    }

    private void sendSwordPacket(EntityPlayer player) {
        ItemStack hotbarItem = player.field_71071_by.func_70301_a(0);
        int itemId = hotbarItem == null ? -1 : Item.func_150891_b((Item)hotbarItem.func_77973_b());
        mainRegistry.channelCintura.sendToAllAround((IMessage)new PacketSwordSheath(player.func_145782_y(), itemId), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 32.0));
    }
}

