/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.network;

import com.DarknessCrow.main.mainRegistry;
import com.DarknessCrow.modelsParts.ModelCustomObjPart;
import com.DarknessCrow.network.ClientModelPartsStorage;
import com.DarknessCrow.network.ModelRegistry;
import com.DarknessCrow.network.PacketHelper;
import com.DarknessCrow.network.ServerModelPartsStorage;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PlayerEventHandler {
    private static final double RENDER_RANGE = 32.0;

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            int[] parts = ServerModelPartsStorage.getModelParts(player);
            PacketHelper.sendModelPartsToNearbyPlayers(parts, player, mainRegistry.modInstance);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        EntityClientPlayerMP localPlayer = Minecraft.func_71410_x().field_71439_g;
        if (localPlayer == null) {
            return;
        }
        float partialTicks = event.partialTicks;
        for (Object obj : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
            int[] parts;
            EntityPlayer player;
            if (!(obj instanceof EntityPlayer) || (player = (EntityPlayer)obj).func_110124_au().equals(localPlayer.func_110124_au()) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 || !player.func_110124_au().equals(localPlayer.func_110124_au()) && localPlayer.func_70068_e((Entity)player) > 1024.0 || (parts = ClientModelPartsStorage.getModelParts(player)).length == 0) continue;
            double renderX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double renderZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            double renderY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            float eyeHeight = player.func_70047_e();
            if (player.func_70093_af()) {
                eyeHeight -= 0.08f;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)(renderX - RenderManager.field_78725_b), (double)((renderY += (double)eyeHeight) - RenderManager.field_78726_c), (double)(renderZ - RenderManager.field_78723_d));
            float rotationYaw = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
            GL11.glRotatef((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderPlayer renderPlayer = (RenderPlayer)RenderManager.field_78727_a.func_78713_a((Entity)player);
            ModelBiped bipedModel = renderPlayer.field_77109_a;
            float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            float sneakOffset = player.func_70093_af() ? 0.125f : 0.0f;
            for (int id : parts) {
                List<ModelCustomObjPart> modelList = ModelRegistry.get(id);
                for (ModelCustomObjPart model : modelList) {
                    if (model == null || model.alpha >= 1.0f) continue;
                    GL11.glPushMatrix();
                    if (!"none".equals(model.bodyPart)) {
                        this.applyRefinedTransform(bipedModel, model.bodyPart, pitch, player.func_70093_af());
                    } else {
                        GL11.glTranslatef((float)0.0f, (float)sneakOffset, (float)0.0f);
                        if (model.modelOffset.length >= 3) {
                            GL11.glTranslatef((float)model.modelOffset[0], (float)model.modelOffset[1], (float)model.modelOffset[2]);
                        }
                    }
                    model.func_78785_a(0.0625f);
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderPlayerSpecials(RenderPlayerEvent.Specials.Post event) {
        EntityPlayer player = event.entityPlayer;
        int[] parts = ClientModelPartsStorage.getModelParts(player);
        if (parts.length == 0) {
            return;
        }
        ModelBiped biped = event.renderer.field_77109_a;
        for (int id : parts) {
            List<ModelCustomObjPart> modelList = ModelRegistry.get(id);
            for (ModelCustomObjPart model : modelList) {
                if (model == null || model.alpha < 1.0f) continue;
                GL11.glPushMatrix();
                if ("none".equals(model.bodyPart)) {
                    GL11.glRotatef((float)player.field_70761_aq, (float)0.0f, (float)1.0f, (float)0.0f);
                    if (model.modelOffset.length >= 3) {
                        GL11.glTranslatef((float)model.modelOffset[0], (float)model.modelOffset[1], (float)model.modelOffset[2]);
                    }
                } else {
                    ModelRenderer part = this.getBodyPartRenderer(biped, model.bodyPart);
                    if (part != null) {
                        part.func_78794_c(0.0625f);
                    }
                }
                model.func_78785_a(1.0f);
                GL11.glPopMatrix();
            }
        }
    }

    private ModelRenderer getBodyPartRenderer(ModelBiped biped, String partName) {
        switch (partName) {
            case "bipedHead": {
                return biped.field_78116_c;
            }
            case "bipedBody": {
                return biped.field_78115_e;
            }
            case "bipedRightArm": {
                return biped.field_78112_f;
            }
            case "bipedLeftArm": {
                return biped.field_78113_g;
            }
            case "bipedRightLeg": {
                return biped.field_78123_h;
            }
            case "bipedLeftLeg": {
                return biped.field_78124_i;
            }
            case "none": {
                return null;
            }
        }
        return null;
    }

    private void applyRefinedTransform(ModelBiped biped, String partName, float pitch, boolean sneaking) {
        ModelRenderer part = null;
        switch (partName) {
            case "bipedHead": {
                part = biped.field_78116_c;
                break;
            }
            case "bipedBody": {
                part = biped.field_78115_e;
                break;
            }
            case "bipedRightArm": {
                part = biped.field_78112_f;
                break;
            }
            case "bipedLeftArm": {
                part = biped.field_78113_g;
                break;
            }
            case "bipedRightLeg": {
                part = biped.field_78123_h;
                break;
            }
            case "bipedLeftLeg": {
                part = biped.field_78124_i;
            }
        }
        if (part == null) {
            return;
        }
        GL11.glTranslatef((float)(biped.field_78115_e.field_78800_c / 16.0f), (float)(biped.field_78115_e.field_78797_d / 16.0f), (float)(biped.field_78115_e.field_78798_e / 16.0f));
        GL11.glRotatef((float)(biped.field_78115_e.field_78808_h * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(biped.field_78115_e.field_78796_g * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-biped.field_78115_e.field_78795_f * 320.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(part.field_78800_c / 16.0f), (float)(part.field_78797_d / 16.0f), (float)(part.field_78798_e / 16.0f));
        GL11.glRotatef((float)(part.field_78808_h * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
        if ("bipedRightArm".equals(partName)) {
            GL11.glRotatef((float)(-part.field_78795_f * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-part.field_78796_g * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)(part.field_78795_f * 180.0f / (float)Math.PI), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(part.field_78796_g * 180.0f / (float)Math.PI), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }
}

