/*
 * Decompiled with CFR 0.152.
 */
package com.DarknessCrow.chat;

import com.DarknessCrow.chat.TextBlockClient;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IChatComponent;
import org.lwjgl.opengl.GL11;

public class ChatMessages {
    private static Map<String, ChatMessages> users = new Hashtable<String, ChatMessages>();
    private Map<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
    private int boxLength = 46;
    private float scale = 0.5f;
    private String lastMessage = "";
    private long lastMessageTime = 0L;
    private static Pattern[] patterns = new Pattern[]{Pattern.compile("^<+([a-zA-z0-9_]{2,16})>[:]? (.*)"), Pattern.compile("^\\[.*[\\]]{1,16}[^a-zA-z0-9]?([a-zA-z0-9_]{2,16})[:]? (.*)"), Pattern.compile("^[a-zA-z0-9_]{2,10}[^a-zA-z0-9]([a-zA-z0-9_]{2,16})[:]? (.*)")};

    public void addMessage(String message) {
        long time = System.currentTimeMillis();
        if (message.equals(this.lastMessage) && this.lastMessageTime + 1000L > time) {
            return;
        }
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>(this.messages);
        messages.put(time, new TextBlockClient(message, this.boxLength * 4));
        if (messages.size() > 3) {
            messages.remove(messages.keySet().iterator().next());
        }
        this.messages = messages;
        this.lastMessage = message;
        this.lastMessageTime = time;
    }

    public static void renderPlayerBubbles(EntityPlayer player, double x, double y, double z) {
        ChatMessages chat = ChatMessages.getChatMessages(player.func_70005_c_());
        chat.renderMessages(x, y + (double)player.field_70131_O + 0.5, z);
    }

    public void renderMessages(double par3, double par5, double par7) {
        Map<Long, TextBlockClient> messages = this.getMessages();
        if (messages.isEmpty()) {
            return;
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        float var13 = 1.6f;
        float var14 = 0.016666668f * var13;
        GL11.glPushMatrix();
        int size = 0;
        for (TextBlockClient block : messages.values()) {
            size += block.lines.size();
        }
        int textYSize = (int)((float)(size * font.field_78288_b) * this.scale);
        GL11.glTranslatef((float)((float)par3 + 0.0f), (float)((float)par5 + (float)textYSize * var14), (float)((float)par7));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-var14), (float)(-var14), (float)var14);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)515);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3553);
        ChatMessages.drawRect(-this.boxLength - 2, -2, this.boxLength + 2, textYSize + 1, -1140850689, 0.11);
        ChatMessages.drawRect(-this.boxLength - 1, -3, this.boxLength + 1, -2, -16777216, 0.1);
        ChatMessages.drawRect(-this.boxLength - 1, textYSize + 2, -1, textYSize + 1, -16777216, 0.1);
        ChatMessages.drawRect(3, textYSize + 2, this.boxLength + 1, textYSize + 1, -16777216, 0.1);
        ChatMessages.drawRect(-this.boxLength - 3, -1, -this.boxLength - 2, textYSize, -16777216, 0.1);
        ChatMessages.drawRect(this.boxLength + 3, -1, this.boxLength + 2, textYSize, -16777216, 0.1);
        ChatMessages.drawRect(-this.boxLength - 2, -2, -this.boxLength - 1, -1, -16777216, 0.1);
        ChatMessages.drawRect(this.boxLength + 2, -2, this.boxLength + 1, -1, -16777216, 0.1);
        ChatMessages.drawRect(-this.boxLength - 2, textYSize + 1, -this.boxLength - 1, textYSize, -16777216, 0.1);
        ChatMessages.drawRect(this.boxLength + 2, textYSize + 1, this.boxLength + 1, textYSize, -16777216, 0.1);
        ChatMessages.drawRect(0, textYSize + 1, 3, textYSize + 4, -1140850689, 0.11);
        ChatMessages.drawRect(-1, textYSize + 4, 1, textYSize + 5, -1140850689, 0.11);
        ChatMessages.drawRect(-1, textYSize + 1, 0, textYSize + 4, -16777216, 0.1);
        ChatMessages.drawRect(3, textYSize + 1, 4, textYSize + 3, -16777216, 0.1);
        ChatMessages.drawRect(2, textYSize + 3, 3, textYSize + 4, -16777216, 0.1);
        ChatMessages.drawRect(1, textYSize + 4, 2, textYSize + 5, -16777216, 0.1);
        ChatMessages.drawRect(-2, textYSize + 4, -1, textYSize + 5, -16777216, 0.1);
        ChatMessages.drawRect(-2, textYSize + 5, 1, textYSize + 6, -16777216, 0.1);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        int index = 0;
        for (TextBlockClient block : messages.values()) {
            for (IChatComponent chat : block.lines) {
                String message = chat.func_150254_d();
                font.func_78276_b(message, -font.func_78256_a(message) / 2, index * font.field_78288_b, 0);
                ++index;
            }
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        RenderHelper.func_74519_b();
    }

    public static void drawRect(int par0, int par1, int par2, int par3, int par4, double par5) {
        int j1;
        if (par0 < par2) {
            j1 = par0;
            par0 = par2;
            par2 = j1;
        }
        if (par1 < par3) {
            j1 = par1;
            par1 = par3;
            par3 = j1;
        }
        float f = (float)(par4 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par4 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par4 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par4 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)par0, (double)par3, par5);
        tessellator.func_78377_a((double)par2, (double)par3, par5);
        tessellator.func_78377_a((double)par2, (double)par1, par5);
        tessellator.func_78377_a((double)par0, (double)par1, par5);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public static ChatMessages getChatMessages(String username) {
        if (users.containsKey(username)) {
            return users.get(username);
        }
        ChatMessages chat = new ChatMessages();
        users.put(username, chat);
        return chat;
    }

    public static void parseMessage(String toParse) {
        toParse = toParse.replaceAll("\u00a7.", "");
        for (Pattern pattern : patterns) {
            String username;
            Matcher m = pattern.matcher(toParse);
            if (!m.find() || !ChatMessages.validPlayer(username = m.group(1))) continue;
            String message = m.group(2);
            ChatMessages.getChatMessages(username).addMessage(message);
            return;
        }
    }

    private static boolean validPlayer(String username) {
        return Minecraft.func_71410_x().field_71441_e.func_72924_a(username) != null;
    }

    private Map<Long, TextBlockClient> getMessages() {
        TreeMap<Long, TextBlockClient> messages = new TreeMap<Long, TextBlockClient>();
        long time = System.currentTimeMillis();
        for (long timestamp : this.messages.keySet()) {
            if (time > timestamp + 10000L) continue;
            TextBlockClient message = this.messages.get(timestamp);
            messages.put(timestamp, message);
        }
        this.messages = messages;
        return messages;
    }
}

