/*
 * Decompiled with CFR 0.152.
 */
package com.rnoverlays.server;

import com.rnoverlays.net.DBNNetwork;
import com.rnoverlays.net.PacketSetOverlay;
import com.rnoverlays.server.ServerOverlayStore;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class CommandOverlay
extends CommandBase {
    public String func_71517_b() {
        return "overlay";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/overlay set [player|@p|@all] <url> [xFrac yFrac widthFrac alpha layer]\n/overlay clear [player|@p|@all]";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String sub = args[0].toLowerCase();
        if ("clear".equals(sub)) {
            List<EntityPlayerMP> targets = args.length >= 2 ? CommandOverlay.resolveTargets(sender, args[1]) : Collections.singletonList(CommandOverlay.requireSelf(sender));
            for (EntityPlayerMP p : targets) {
                ServerOverlayStore.clearOverlays(p);
                DBNNetwork.CHANNEL.sendTo((IMessage)new PacketSetOverlay(false, "", 0.0f, 0.0f, 0.0f, 1.0f, 1), p);
            }
            if (targets.size() == 1) {
                CommandOverlay.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Overlay limpo para %s.", (Object[])new Object[]{targets.get(0).func_70005_c_()});
            } else {
                CommandOverlay.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Overlay limpo para %d jogadores.", (Object[])new Object[]{targets.size()});
            }
            return;
        }
        if ("set".equals(sub)) {
            List<EntityPlayerMP> targets;
            int idx = 1;
            if (idx < args.length && CommandOverlay.looksLikeUrl(args[idx])) {
                targets = Collections.singletonList(CommandOverlay.requireSelf(sender));
            } else {
                if (idx >= args.length) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                targets = CommandOverlay.resolveTargets(sender, args[idx++]);
            }
            if (idx >= args.length || !CommandOverlay.looksLikeUrl(args[idx])) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            String url = args[idx++];
            float xFrac = 0.02f;
            float yFrac = 0.02f;
            float wFrac = 0.3f;
            float alpha = 1.0f;
            int layer = 1;
            if (idx < args.length) {
                xFrac = CommandOverlay.clamp01(CommandOverlay.parseFloat(args[idx++]));
            }
            if (idx < args.length) {
                yFrac = CommandOverlay.clamp01(CommandOverlay.parseFloat(args[idx++]));
            }
            if (idx < args.length) {
                wFrac = CommandOverlay.clampRange(CommandOverlay.parseFloat(args[idx++]), 0.05f, 1.0f);
            }
            if (idx < args.length) {
                alpha = CommandOverlay.clampRange(CommandOverlay.parseFloat(args[idx++]), 0.0f, 1.0f);
            }
            if (idx < args.length) {
                try {
                    layer = Integer.parseInt(args[idx++]);
                }
                catch (NumberFormatException ignored) {
                    layer = 1;
                }
                if (layer < 0) {
                    layer = 0;
                }
                if (layer > 2) {
                    layer = 2;
                }
            }
            for (EntityPlayerMP p : targets) {
                ServerOverlayStore.OverlayData od = new ServerOverlayStore.OverlayData(url, xFrac, yFrac, wFrac, alpha, layer);
                ServerOverlayStore.addOverlay(p, od);
                DBNNetwork.CHANNEL.sendTo((IMessage)new PacketSetOverlay(true, url, xFrac, yFrac, wFrac, alpha, layer), p);
            }
            if (targets.size() == 1) {
                CommandOverlay.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Overlay enviado para %s.", (Object[])new Object[]{targets.get(0).func_70005_c_()});
            } else {
                CommandOverlay.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"Overlay enviado para %d jogadores.", (Object[])new Object[]{targets.size()});
            }
            return;
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    private static float parseFloat(String s) {
        try {
            return Float.parseFloat(s);
        }
        catch (Throwable ignored) {
            return 0.0f;
        }
    }

    private static float clamp01(float v) {
        return CommandOverlay.clampRange(v, 0.0f, 1.0f);
    }

    private static float clampRange(float v, float min, float max) {
        if (v < min) {
            return min;
        }
        if (v > max) {
            return max;
        }
        return v;
    }

    private static boolean looksLikeUrl(String s) {
        int h;
        if (s == null) {
            return false;
        }
        String u = s.trim().toLowerCase();
        if (!u.startsWith("http://") && !u.startsWith("https://")) {
            return false;
        }
        int q = u.indexOf(63);
        if (q >= 0) {
            u = u.substring(0, q);
        }
        if ((h = u.indexOf(35)) >= 0) {
            u = u.substring(0, h);
        }
        return u.endsWith(".png") || u.endsWith(".jpg") || u.endsWith(".jpeg") || u.endsWith(".gif");
    }

    private static EntityPlayerMP requireSelf(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            return (EntityPlayerMP)sender;
        }
        throw new CommandException("Ao usar via console, especifique o jogador: /overlay set [player|@p|@all] <url> ...", new Object[0]);
    }

    private static List<EntityPlayerMP> resolveTargets(ICommandSender sender, String token) {
        ArrayList<EntityPlayerMP> out = new ArrayList<EntityPlayerMP>();
        if ("@p".equalsIgnoreCase(token)) {
            out.add(CommandOverlay.getNearestPlayer(sender, false));
            return out;
        }
        if ("@all".equalsIgnoreCase(token)) {
            for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                out.add((EntityPlayerMP)o);
            }
            if (out.isEmpty()) {
                throw new PlayerNotFoundException();
            }
            return out;
        }
        EntityPlayerMP p = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(token);
        if (p == null) {
            throw new PlayerNotFoundException();
        }
        out.add(p);
        return out;
    }

    private static EntityPlayerMP getNearestPlayer(ICommandSender sender, boolean mustBeDifferent) {
        Entity senderEnt = sender instanceof Entity ? (Entity)sender : null;
        EntityPlayerMP best = null;
        double bestDistSq = Double.MAX_VALUE;
        for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayerMP p = (EntityPlayerMP)o;
            if (mustBeDifferent && senderEnt != null && p == senderEnt) continue;
            if (senderEnt != null) {
                double dx = p.field_70165_t - senderEnt.field_70165_t;
                double dy = p.field_70163_u - senderEnt.field_70163_u;
                double dz = p.field_70161_v - senderEnt.field_70161_v;
                double d2 = dx * dx + dy * dy + dz * dz;
                if (!(d2 < bestDistSq)) continue;
                bestDistSq = d2;
                best = p;
                continue;
            }
            best = p;
            break;
        }
        if (best == null) {
            throw new PlayerNotFoundException();
        }
        return best;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandOverlay.func_71530_a((String[])args, (String[])new String[]{"set", "clear"});
        }
        if (args.length == 2 && ("set".equalsIgnoreCase(args[0]) || "clear".equalsIgnoreCase(args[0]))) {
            ArrayList<String> opts = new ArrayList<String>();
            opts.add("@p");
            opts.add("@all");
            for (String name : MinecraftServer.func_71276_C().func_71213_z()) {
                opts.add(name);
            }
            return CommandOverlay.func_71530_a((String[])args, (String[])opts.toArray(new String[0]));
        }
        return new ArrayList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1 && ("set".equalsIgnoreCase(args[0]) || "clear".equalsIgnoreCase(args[0]));
    }
}

