/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcs.network.packets.request.clone;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import kamkeel.npcs.network.AbstractPacket;
import kamkeel.npcs.network.PacketChannel;
import kamkeel.npcs.network.PacketHandler;
import kamkeel.npcs.network.PacketUtil;
import kamkeel.npcs.network.enums.EnumItemPacketType;
import kamkeel.npcs.network.enums.EnumRequestPacket;
import kamkeel.npcs.network.packets.data.large.GuiDataPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.controllers.ServerCloneController;

public final class CloneListPacket
extends AbstractPacket {
    public static String packetName = "Request|CloneList";
    private int tab;

    public CloneListPacket(int tab) {
        this.tab = tab;
    }

    public CloneListPacket() {
    }

    @Override
    public Enum getType() {
        return EnumRequestPacket.CloneList;
    }

    @Override
    public PacketChannel getChannel() {
        return PacketHandler.REQUEST_PACKET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void sendData(ByteBuf out) throws IOException {
        out.writeInt(this.tab);
    }

    @Override
    public void receiveData(ByteBuf in, EntityPlayer player) throws IOException {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (!PacketUtil.verifyItemPacket(packetName, player, EnumItemPacketType.MOUNTER, EnumItemPacketType.CLONER)) {
            return;
        }
        NBTTagList list = new NBTTagList();
        int tab = in.readInt();
        for (String string : ServerCloneController.Instance.getClones(tab)) {
            list.func_74742_a((NBTBase)new NBTTagString(string));
        }
        NBTTagList listDate = new NBTTagList();
        for (String name : ServerCloneController.Instance.getClonesDate(tab)) {
            listDate.func_74742_a((NBTBase)new NBTTagString(name));
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74782_a("List", (NBTBase)list);
        nBTTagCompound.func_74782_a("ListDate", (NBTBase)listDate);
        GuiDataPacket.sendGuiData((EntityPlayerMP)player, nBTTagCompound);
    }
}

