/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import kamkeel.npcdbc.client.model.ModelPotara;
import kamkeel.npcdbc.config.ConfigDBCGameplay;
import kamkeel.npcdbc.constants.enums.EnumMiscCapsules;
import kamkeel.npcdbc.constants.enums.EnumPotaraTypes;
import kamkeel.npcdbc.controllers.FusionHandler;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;

public class ItemPotara
extends ItemArmor {
    protected IIcon[] icons;

    public ItemPotara() {
        super(ItemArmor.ArmorMaterial.IRON, 0, 0);
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a((CreativeTabs)CustomItems.tabMisc);
    }

    public String func_77667_c(ItemStack stack) {
        int metadata = stack.func_77960_j();
        EnumPotaraTypes misc = EnumPotaraTypes.values()[metadata];
        return "item.npcdbc:" + misc.getName().toLowerCase() + "_potara";
    }

    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[EnumPotaraTypes.count() * 2];
        String prefix = "npcdbc:potara/";
        for (EnumPotaraTypes potaraTypes : EnumPotaraTypes.values()) {
            this.icons[potaraTypes.getMeta()] = reg.func_94245_a(prefix + potaraTypes.getName().toLowerCase());
        }
        for (int i = EnumPotaraTypes.count(); i < EnumPotaraTypes.count() * 2; ++i) {
            this.icons[i] = reg.func_94245_a(prefix + EnumPotaraTypes.values()[i - EnumPotaraTypes.count()].getName().toLowerCase() + "_pair");
        }
    }

    public IIcon func_77617_a(int meta) {
        if (meta >= 0 && meta < EnumMiscCapsules.count()) {
            return this.icons[meta];
        }
        if (meta >= EnumMiscCapsules.count() && meta < EnumMiscCapsules.count() * 2) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    public EnumRarity func_77613_e(ItemStack item) {
        if (item.func_77978_p() == null || !item.func_77978_p().func_74764_b("Side")) {
            return EnumRarity.common;
        }
        return EnumRarity.uncommon;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (EnumPotaraTypes potara : EnumPotaraTypes.values()) {
            list.add(new ItemStack(item, 1, potara.getMeta()));
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        player.func_71008_a(itemStack, this.func_77626_a(itemStack));
        if (world.field_72995_K) {
            return itemStack;
        }
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("Side")) {
            return itemStack;
        }
        int openSlots = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null && ++openSlots >= 2) break;
        }
        if (openSlots >= 2) {
            ItemStack leftPotara = new ItemStack(itemStack.func_77973_b());
            leftPotara.func_77964_b(itemStack.func_77960_j());
            ItemStack rightPotara = new ItemStack(itemStack.func_77973_b());
            rightPotara.func_77964_b(itemStack.func_77960_j());
            NBTTagCompound leftNBT = leftPotara.func_77978_p();
            NBTTagCompound rightNBT = rightPotara.func_77978_p();
            if (leftNBT == null) {
                leftNBT = new NBTTagCompound();
            }
            if (rightNBT == null) {
                rightNBT = new NBTTagCompound();
            }
            if (ConfigDBCGameplay.UniqueEarrings) {
                String uniqueCode = this.generateUniqueCode();
                leftNBT.func_74778_a("Hash", uniqueCode);
                rightNBT.func_74778_a("Hash", uniqueCode);
            }
            leftNBT.func_74778_a("Side", "LEFT");
            rightNBT.func_74778_a("Side", "RIGHT");
            leftPotara.func_77982_d(leftNBT);
            rightPotara.func_77982_d(rightNBT);
            itemStack.func_77979_a(1);
            player.field_71071_by.func_70441_a(leftPotara);
            player.field_71071_by.func_70441_a(rightPotara);
        }
        return itemStack;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (!(target instanceof EntityPlayer)) {
            return false;
        }
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_74764_b("Side")) {
            return false;
        }
        NBTTagCompound potara = stack.func_77978_p();
        boolean rightSide = potara.func_74779_i("Side").equals("RIGHT");
        String hash = potara.func_74764_b("Hash") ? potara.func_74779_i("Hash") : "";
        int tier = stack.func_77960_j();
        FusionHandler.requestFusion(player, (EntityPlayer)target, rightSide, hash, tier);
        return true;
    }

    private String generateUniqueCode() {
        StringBuilder uniqueCode = new StringBuilder();
        Random random = new Random();
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for (int i = 0; i < 6; ++i) {
            uniqueCode.append(characters.charAt(random.nextInt(characters.length())));
        }
        return uniqueCode.toString();
    }

    public static String getHash(ItemStack stack) {
        NBTTagCompound potara = stack.func_77978_p();
        return potara.func_74764_b("Hash") ? potara.func_74779_i("Hash") : "";
    }

    public static boolean isRightSide(ItemStack itemStack) {
        return itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("Side") && itemStack.func_77978_p().func_74779_i("Side").equals("RIGHT");
    }

    public static boolean isSplit(ItemStack itemStack) {
        return itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("Side");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        NBTTagCompound compound = itemStack.func_77978_p();
        if (compound != null && compound.func_74764_b("Side")) {
            par3List.add(StatCollector.func_74837_a((String)("\u00a7eSide: \u00a76" + compound.func_74779_i("Side")), (Object[])new Object[0]));
            if (compound.func_74764_b("Hash")) {
                par3List.add(StatCollector.func_74837_a((String)("\u00a77Hash: \u00a78" + compound.func_74779_i("Hash")), (Object[])new Object[0]));
            }
        } else {
            par3List.add(StatCollector.func_74837_a((String)"\u00a7eRight click to split into pairs", (Object[])new Object[0]));
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        int meta = stack.func_77952_i();
        return this.getArmorTextureByMeta(meta);
    }

    public String getArmorTextureByMeta(int meta) {
        return "npcdbc:textures/armor/dbcvanity/potara_" + meta + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int par3) {
        if (!ItemPotara.isSplit(itemStack)) {
            return ModelPotara.BOTH_EARS;
        }
        if (ItemPotara.isRightSide(itemStack)) {
            return ModelPotara.RIGHT_EAR;
        }
        return ModelPotara.LEFT_EAR;
    }
}

