/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.form;

import JinRyuu.JRMCore.JRMCoreH;
import java.util.HashMap;
import kamkeel.npcdbc.api.form.IForm;
import kamkeel.npcdbc.api.form.IFormMasteryLinkData;
import kamkeel.npcdbc.controllers.FormController;
import kamkeel.npcdbc.data.form.FormMastery;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FormMasteryLinkData
implements IFormMasteryLinkData {
    public FormMastery parent;
    public HashMap<Integer, LinkData> masteryLinks = new HashMap();

    public FormMasteryLinkData(FormMastery formMastery) {
        this.parent = formMastery;
    }

    public void saveToNBT(NBTTagCompound compound) {
        NBTTagCompound masteryLinksNBT = new NBTTagCompound();
        for (int i = 0; i < JRMCoreH.Races.length; ++i) {
            LinkData data = this.masteryLinks.get(i);
            if (data == null) continue;
            masteryLinksNBT.func_74782_a("" + i, (NBTBase)data.writeCompound());
        }
        compound.func_74782_a("masteryLinkData", (NBTBase)masteryLinksNBT);
    }

    public void loadFromNBT(NBTTagCompound compound) {
        if (!compound.func_74764_b("masteryLinkData")) {
            return;
        }
        NBTTagCompound masteryLinksNBT = compound.func_74775_l("masteryLinkData");
        for (int i = 0; i < JRMCoreH.Races.length; ++i) {
            if (!masteryLinksNBT.func_74764_b("" + i)) continue;
            LinkData data = LinkData.loadFromNBT(masteryLinksNBT.func_74775_l("" + i));
            this.masteryLinks.put(i, data);
        }
    }

    @Override
    public boolean hasLinkData(int race) {
        return this.masteryLinks.get(race) != null;
    }

    @Override
    public boolean isCustomFormLink(int race) {
        return this.hasLinkData(race) && this.masteryLinks.get((Object)Integer.valueOf((int)race)).isCustomLink;
    }

    @Override
    public int getFormID(int race) {
        LinkData linkData = this.masteryLinks.get(race);
        return linkData != null ? this.masteryLinks.get((Object)Integer.valueOf((int)race)).formID : -1;
    }

    @Override
    public IForm getForm(int race) {
        LinkData linkData = this.masteryLinks.get(race);
        return linkData != null && linkData.isCustomLink ? FormController.getInstance().get(linkData.formID) : null;
    }

    @Override
    public void setCustomFormLink(int formID, int race) {
        this.masteryLinks.put(race, new LinkData(formID, true));
    }

    @Override
    public void setCustomFormLink(IForm form, int race) {
        if (form == null) {
            this.removeLinkData(race);
            return;
        }
        this.masteryLinks.put(race, new LinkData(form.getID(), true));
    }

    @Override
    public void setDBCFormLink(int formID, int race) {
        if (formID == -1) {
            this.removeLinkData(race);
            return;
        }
        this.masteryLinks.put(race, new LinkData(formID, false));
    }

    @Override
    public void setMasteryLink(int formID, int race, boolean isCustomFormLink) {
        if (formID == -1) {
            this.removeLinkData(race);
            return;
        }
        this.masteryLinks.put(race, new LinkData(formID, isCustomFormLink));
    }

    @Override
    public void removeLinkData(int race) {
        this.masteryLinks.remove(race);
    }

    @Override
    public void removeAllLinkData() {
        this.masteryLinks.clear();
    }

    public static class LinkData {
        public int formID;
        public boolean isCustomLink;

        public LinkData(int formID, boolean isCustomLink) {
            this.formID = formID;
            this.isCustomLink = isCustomLink;
        }

        public NBTTagCompound writeCompound() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("formID", this.formID);
            compound.func_74757_a("isCustom", this.isCustomLink);
            return compound;
        }

        public static LinkData loadFromNBT(NBTTagCompound compound) {
            int formID = compound.func_74762_e("formID");
            boolean isCustom = compound.func_74767_n("isCustom");
            return new LinkData(formID, isCustom);
        }
    }
}

