/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.form;

import kamkeel.npcdbc.api.form.IFormMastery;
import kamkeel.npcdbc.api.form.IFormMasteryLinkData;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormMasteryLinkData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.util.ValueUtil;

public class FormMastery
implements IFormMastery {
    private final Form parent;
    public FormMasteryLinkData masteryLink = new FormMasteryLinkData(this);
    public float maxLevel = 100.0f;
    public float instantTransformationUnlockLevel = -1.0f;
    public float attributeMultiFlat = 1.0f;
    public float attributeMultiPerLevel = 0.01f;
    public float attributeMultiMinOrMax = 1.5f;
    public float updateGain = 0.01f;
    public float updateMultiDivPlus = 100.0f;
    public float updateMindBonusFlat = 1.0f;
    public float updateMindBonusPerMind = 0.001f;
    public float updateMindBonusMax = 5.0f;
    public float attackGain = 0.03f;
    public float attackMultiDivPlus = 100.0f;
    public float attackMindBonusFlat = 1.0f;
    public float attackMindBonusPerMind = 0.001f;
    public float attackMindBonusMax = 5.0f;
    public float damagedGain = 0.03f;
    public float damagedMultiDivPlus = 100.0f;
    public float damagedMindBonusFlat = 1.0f;
    public float damagedMindBonusPerMind = 0.001f;
    public float damagedMindBonusMax = 5.0f;
    public float fireKiGain = 0.03f;
    public float fireKiMultiDivPlus = 100.0f;
    public float fireKiMindBonusFlat = 1.0f;
    public float fireKiMindBonusPerMind = 0.001f;
    public float fireKiMindBonusMax = 5.0f;
    public float healthRequirement = 100.0f;
    public float healthRequirementMultiFlat = 1.0f;
    public float healthRequirementMultiPerLevel = 0.01f;
    public float healthRequirementMultiMinOrMax = 5.0f;
    public float kiDrain = 1.0f;
    public int kiDrainTimer = 100;
    public float kiDrainMultiFlat = 1.0f;
    public float kiDrainMultiPerLevel = -0.01f;
    public float kiDrainMultiMinOrMax = 0.1f;
    public int maxHeat = 0;
    public float heatMultiFlat = 1.0f;
    public float heatMultiPerLevel = -0.01f;
    public float heatMultiMinOrMax = 0.0f;
    public int painTime = 0;
    public float painMultiFlat = 1.0f;
    public float painMultiPerLevel = -0.01f;
    public float painMultiMinOrMax = 0.0f;
    public float dodgeChance = 0.0f;
    public float dodgeMultiFlat = 1.0f;
    public float dodgeMultiPerLevel = 0.01f;
    public float dodgeMultiMinOrMax = 2.0f;
    public float damageNegation = 0.0f;
    public float damageNegationMultiFlat = 1.0f;
    public float damageNegationMultiPerLevel = 0.01f;
    public float damageNegationMultiMinOrMax = 2.0f;
    public float movementSpeed = 1.0f;
    public float movementSpeedMultiFlat = 1.0f;
    public float movementSpeedMultiPerLevel = 0.01f;
    public float movementSpeedMultiMinOrMax = 1.5f;
    public float tailCutChance = 100.0f;
    public float tailCutChanceMultiFlat = 1.0f;
    public float tailCutChanceMultiPerLevel = -0.01f;
    public float tailCutChanceMultiMinOrMax = 0.0f;
    public boolean powerPointEnabled;
    public int powerPointCost = 100;
    public int powerPointGrowth = 0;
    public float powerPointMultiNormal = 1.0f;
    public float powerPointMultiBasedOnPoints = -1.0f;
    public float powerPointCostMultiFlat = 1.0f;
    public float powerPointCostPerLevel = -0.01f;
    public float powerPointCostMinOrMax = 0.0f;
    public boolean absorptionEnabled;
    public float absorptionMulti = 1.0f;
    public boolean destroyerEnabled = false;
    public float destroyerKiDamage = 0.8f;
    public float destroyerKiDamageMultiFlat = 1.0f;
    public float destroyerKiDamageMultiPerLevel = 0.01f;
    public float destroyerKiDamageMultiMinOrMax = 1.5f;

    public FormMastery(Form parent) {
        this.parent = parent;
    }

    @Override
    public int getPainTime() {
        return this.painTime;
    }

    @Override
    public void setPainTime(int painTime) {
        this.painTime = painTime;
    }

    @Override
    public boolean hasPainTime() {
        return this.painTime > 0;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    @Override
    public void setMaxHeat(int maxHeat) {
        this.maxHeat = maxHeat;
    }

    @Override
    public boolean hasHeat() {
        return this.maxHeat > 1;
    }

    @Override
    public float getDamageNegation() {
        return this.damageNegation;
    }

    @Override
    public void setDamageNegation(float damageNegation) {
        this.damageNegation = damageNegation;
    }

    @Override
    public boolean hasDamageNegation() {
        return this.damageNegation > 0.0f;
    }

    @Override
    public float getDodgeChance() {
        return this.dodgeChance;
    }

    @Override
    public void setDodgeChance(float dodgeChance) {
        this.dodgeChance = dodgeChance;
    }

    @Override
    public boolean hasDodge() {
        return this.dodgeChance > 0.0f;
    }

    @Override
    public float getKiDrain() {
        return this.kiDrain;
    }

    @Override
    public void setKiDrain(float kiDrain) {
        this.kiDrain = kiDrain;
    }

    @Override
    public boolean hasKiDrain() {
        return this.kiDrain != 0.0f;
    }

    @Override
    public int getKiDrainTimer() {
        return this.kiDrainTimer;
    }

    @Override
    public void setKiDrainTimer(int timeInTicks) {
        this.kiDrainTimer = timeInTicks;
    }

    @Override
    public float getHealthRequirement() {
        return this.healthRequirement;
    }

    @Override
    public void setHealthRequirement(float healthRequirementInPercent) {
        this.healthRequirement = ValueUtil.clamp((float)healthRequirementInPercent, (float)1.0f, (float)100.0f);
    }

    @Override
    public float getMulti(String type, String type1) {
        switch (type.toLowerCase()) {
            case "attribute": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.attributeMultiFlat;
                    }
                    case "perlevel": {
                        return this.attributeMultiPerLevel;
                    }
                    case "minormax": {
                        return this.attributeMultiMinOrMax;
                    }
                }
            }
            case "kidrain": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.kiDrainMultiFlat;
                    }
                    case "perlevel": {
                        return this.kiDrainMultiPerLevel;
                    }
                    case "minormax": {
                        return this.kiDrainMultiMinOrMax;
                    }
                }
            }
            case "heat": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.heatMultiFlat;
                    }
                    case "perlevel": {
                        return this.heatMultiPerLevel;
                    }
                    case "minormax": {
                        return this.heatMultiMinOrMax;
                    }
                }
            }
            case "pain": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.painMultiFlat;
                    }
                    case "perlevel": {
                        return this.painMultiPerLevel;
                    }
                    case "minormax": {
                        return this.painMultiMinOrMax;
                    }
                }
            }
            case "healthrequirement": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.healthRequirementMultiFlat;
                    }
                    case "perlevel": {
                        return this.healthRequirementMultiPerLevel;
                    }
                    case "minormax": {
                        return this.healthRequirementMultiMinOrMax;
                    }
                }
            }
            case "dodge": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.dodgeMultiFlat;
                    }
                    case "perlevel": {
                        return this.dodgeMultiPerLevel;
                    }
                    case "minormax": {
                        return this.dodgeMultiMinOrMax;
                    }
                }
            }
            case "damagenegation": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.damageNegationMultiFlat;
                    }
                    case "perlevel": {
                        return this.damageNegationMultiPerLevel;
                    }
                    case "minormax": {
                        return this.damageNegationMultiMinOrMax;
                    }
                }
            }
            case "movementspeed": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.movementSpeedMultiFlat;
                    }
                    case "perlevel": {
                        return this.movementSpeedMultiPerLevel;
                    }
                    case "minormax": {
                        return this.movementSpeedMultiMinOrMax;
                    }
                }
            }
            case "tailcutchance": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.tailCutChanceMultiFlat;
                    }
                    case "perlevel": {
                        return this.tailCutChanceMultiPerLevel;
                    }
                    case "minormax": {
                        return this.tailCutChanceMultiMinOrMax;
                    }
                }
            }
            case "ppcost": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.powerPointCostMultiFlat;
                    }
                    case "perlevel": {
                        return this.powerPointCostPerLevel;
                    }
                    case "minormax": {
                        return this.powerPointCostMinOrMax;
                    }
                }
            }
            case "destroyerkidamage": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        return this.destroyerKiDamageMultiFlat;
                    }
                    case "perlevel": {
                        return this.destroyerKiDamageMultiPerLevel;
                    }
                    case "minormax": {
                        return this.destroyerKiDamageMultiMinOrMax;
                    }
                }
            }
        }
        return 1.0f;
    }

    @Override
    public void setMulti(String type, String type1, float value) {
        switch (type.toLowerCase()) {
            case "attribute": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.attributeMultiFlat = value;
                        break;
                    }
                    case "perlevel": {
                        this.attributeMultiPerLevel = value;
                        break;
                    }
                    case "minormax": {
                        this.attributeMultiMinOrMax = value;
                    }
                }
                break;
            }
            case "kidrain": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.kiDrainMultiFlat = value;
                        break;
                    }
                    case "perlevel": {
                        this.kiDrainMultiPerLevel = value;
                        break;
                    }
                    case "minormax": {
                        this.kiDrainMultiMinOrMax = value;
                    }
                }
                break;
            }
            case "heat": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.heatMultiFlat = value;
                        break;
                    }
                    case "perlevel": {
                        this.heatMultiPerLevel = value;
                        break;
                    }
                    case "minormax": {
                        this.heatMultiMinOrMax = value;
                    }
                }
                break;
            }
            case "pain": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.painMultiFlat = value;
                        break;
                    }
                    case "perlevel": {
                        this.painMultiPerLevel = value;
                        break;
                    }
                    case "minormax": {
                        this.painMultiMinOrMax = value;
                    }
                }
                break;
            }
            case "healthrequirement": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.healthRequirementMultiFlat = value;
                        break;
                    }
                    case "perlevel": {
                        this.healthRequirementMultiPerLevel = value;
                        break;
                    }
                    case "minormax": {
                        this.healthRequirementMultiMinOrMax = value;
                    }
                }
                break;
            }
            case "dodge": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.dodgeMultiFlat = value;
                        break;
                    }
                    case "perlevel": {
                        this.dodgeMultiPerLevel = value;
                        break;
                    }
                    case "minormax": {
                        this.dodgeMultiMinOrMax = value;
                    }
                }
                break;
            }
            case "damagenegation": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.damageNegationMultiFlat = value;
                        break;
                    }
                    case "perlevel": {
                        this.damageNegationMultiPerLevel = value;
                        break;
                    }
                    case "minormax": {
                        this.damageNegationMultiMinOrMax = value;
                    }
                }
            }
            case "movementspeed": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.movementSpeedMultiFlat = value;
                        break;
                    }
                    case "perlevel": {
                        this.movementSpeedMultiPerLevel = value;
                        break;
                    }
                    case "minormax": {
                        this.movementSpeedMultiMinOrMax = value;
                    }
                }
            }
            case "tailcutchance": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.tailCutChanceMultiFlat = value;
                        break;
                    }
                    case "perlevel": {
                        this.tailCutChanceMultiPerLevel = value;
                        break;
                    }
                    case "minormax": {
                        this.tailCutChanceMultiMinOrMax = value;
                    }
                }
            }
            case "ppcost": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.powerPointCostMultiFlat = value;
                    }
                    case "perlevel": {
                        this.powerPointCostPerLevel = value;
                    }
                    case "minormax": {
                        this.powerPointCostMinOrMax = value;
                    }
                }
            }
            case "destroyerkidamage": {
                switch (type1.toLowerCase()) {
                    case "flat": {
                        this.destroyerKiDamageMultiFlat = value;
                    }
                    case "perlevel": {
                        this.destroyerKiDamageMultiPerLevel = value;
                    }
                    case "minormax": {
                        this.destroyerKiDamageMultiMinOrMax = value;
                    }
                }
            }
        }
    }

    @Override
    public float getGain(String eventType, String type) {
        switch (eventType.toLowerCase()) {
            case "update": {
                switch (type.toLowerCase()) {
                    case "gain": {
                        return this.updateGain;
                    }
                    case "multidivplus": {
                        return this.updateMultiDivPlus;
                    }
                    case "flat": {
                        return this.updateMindBonusFlat;
                    }
                    case "permind": {
                        return this.updateMindBonusPerMind;
                    }
                    case "max": {
                        return this.updateMindBonusMax;
                    }
                }
            }
            case "attack": {
                switch (type.toLowerCase()) {
                    case "gain": {
                        return this.attackGain;
                    }
                    case "multidivplus": {
                        return this.attackMultiDivPlus;
                    }
                    case "flat": {
                        return this.attackMindBonusFlat;
                    }
                    case "permind": {
                        return this.attackMindBonusPerMind;
                    }
                    case "max": {
                        return this.attackMindBonusMax;
                    }
                }
            }
            case "damaged": {
                switch (type.toLowerCase()) {
                    case "gain": {
                        return this.damagedGain;
                    }
                    case "multidivplus": {
                        return this.damagedMultiDivPlus;
                    }
                    case "flat": {
                        return this.damagedMindBonusFlat;
                    }
                    case "permind": {
                        return this.damagedMindBonusPerMind;
                    }
                    case "max": {
                        return this.damagedMindBonusMax;
                    }
                }
            }
            case "fireki": {
                switch (type.toLowerCase()) {
                    case "gain": {
                        return this.fireKiGain;
                    }
                    case "multidivplus": {
                        return this.fireKiMultiDivPlus;
                    }
                    case "flat": {
                        return this.fireKiMindBonusFlat;
                    }
                    case "permind": {
                        return this.fireKiMindBonusPerMind;
                    }
                    case "max": {
                        return this.fireKiMindBonusMax;
                    }
                }
            }
        }
        return 1.0f;
    }

    @Override
    public void setGain(String eventType, String type, float value) {
        block6 : switch (eventType.toLowerCase()) {
            case "update": {
                switch (type.toLowerCase()) {
                    case "gain": {
                        this.updateGain = value;
                        break;
                    }
                    case "multidivplus": {
                        this.updateMultiDivPlus = value;
                        break;
                    }
                    case "flat": {
                        this.updateMindBonusFlat = value;
                        break;
                    }
                    case "permind": {
                        this.updateMindBonusPerMind = value;
                        break;
                    }
                    case "max": {
                        this.updateMindBonusMax = value;
                    }
                }
                break;
            }
            case "attack": {
                switch (type.toLowerCase()) {
                    case "gain": {
                        this.attackGain = value;
                        break;
                    }
                    case "multidivplus": {
                        this.attackMultiDivPlus = value;
                        break;
                    }
                    case "flat": {
                        this.attackMindBonusFlat = value;
                        break;
                    }
                    case "permind": {
                        this.attackMindBonusPerMind = value;
                        break;
                    }
                    case "max": {
                        this.attackMindBonusMax = value;
                    }
                }
                break;
            }
            case "damaged": {
                switch (type.toLowerCase()) {
                    case "gain": {
                        this.damagedGain = value;
                        break;
                    }
                    case "multidivplus": {
                        this.damagedMultiDivPlus = value;
                        break;
                    }
                    case "flat": {
                        this.damagedMindBonusFlat = value;
                        break;
                    }
                    case "permind": {
                        this.damagedMindBonusPerMind = value;
                        break;
                    }
                    case "max": {
                        this.damagedMindBonusMax = value;
                    }
                }
                break;
            }
            case "fireki": {
                switch (type.toLowerCase()) {
                    case "gain": {
                        this.fireKiGain = value;
                        break block6;
                    }
                    case "multidivplus": {
                        this.fireKiMultiDivPlus = value;
                        break block6;
                    }
                    case "flat": {
                        this.fireKiMindBonusFlat = value;
                        break block6;
                    }
                    case "permind": {
                        this.fireKiMindBonusPerMind = value;
                        break block6;
                    }
                    case "max": {
                        this.fireKiMindBonusMax = value;
                    }
                }
            }
        }
    }

    @Override
    public float getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public void setMaxLevel(float value) {
        this.maxLevel = value;
    }

    @Override
    public float getInstantTransformationUnlockLevel() {
        return this.instantTransformationUnlockLevel;
    }

    @Override
    public void setInstantTransformationUnlockLevel(float value) {
        this.instantTransformationUnlockLevel = value;
    }

    @Override
    public boolean hasInstantTransformationUnlockLevel() {
        return this.instantTransformationUnlockLevel > -1.0f;
    }

    public boolean canInstantTransform(float curLevel) {
        return curLevel >= this.instantTransformationUnlockLevel;
    }

    public float calculateMulti(String type, float playerLevel) {
        boolean downwards;
        float flat = this.getMulti(type, "flat");
        float perLevel = this.getMulti(type, "perlevel");
        float minOrMax = this.getMulti(type, "minormax");
        float value = perLevel * playerLevel + flat;
        boolean bl = downwards = (double)perLevel < 0.0;
        if (downwards ? value < minOrMax : value > minOrMax) {
            value = minOrMax;
        }
        return value;
    }

    public float calculateGainMindMulti(String type, int playerMind) {
        float max = this.getGain(type, "max");
        if ((double)max <= 0.0) {
            return max;
        }
        float flat = this.getGain(type, "flat");
        float perMind = this.getGain(type, "permind");
        float multi = (float)playerMind * perMind + flat;
        return multi > max ? max : multi;
    }

    public float calculateMultipliedGain(String type, float playerLevel) {
        float gain = this.getGain(type, "gain");
        float multiDivPlus = this.getGain(type, "multidivplus");
        if ((double)multiDivPlus != 0.0 && (double)gain != 0.0) {
            float lossFromLevel = playerLevel / (playerLevel + multiDivPlus);
            return gain - gain * lossFromLevel;
        }
        return gain;
    }

    public float calculateFullGain(String type, float playerLevel, int playerMind) {
        return this.calculateMultipliedGain(type, playerLevel) * this.calculateGainMindMulti(type, playerMind);
    }

    public void readFromNBT(NBTTagCompound compound) {
        NBTTagCompound formMastery = compound.func_74775_l("formMastery");
        this.maxLevel = formMastery.func_74760_g("maxLevel");
        this.instantTransformationUnlockLevel = formMastery.func_74760_g("instantTransformationUnlockLevel");
        this.kiDrain = formMastery.func_74760_g("kiDrain");
        this.kiDrainTimer = formMastery.func_74762_e("kiDrainTimer");
        this.healthRequirement = formMastery.func_74760_g("healthRequirement");
        this.dodgeChance = formMastery.func_74760_g("dodgeChance");
        this.damageNegation = formMastery.func_74760_g("damageNegation");
        this.painTime = formMastery.func_74762_e("painTime");
        this.maxHeat = formMastery.func_74762_e("maxHeat");
        this.movementSpeed = formMastery.func_74760_g("movementSpeed");
        this.tailCutChance = formMastery.func_74760_g("tailCutChance");
        NBTTagCompound attributeMulti = formMastery.func_74775_l("attributeMulti");
        this.attributeMultiFlat = attributeMulti.func_74760_g("flat");
        this.attributeMultiPerLevel = attributeMulti.func_74760_g("perLevel");
        this.attributeMultiMinOrMax = attributeMulti.func_74760_g("max");
        NBTTagCompound kiDrainMulti = formMastery.func_74775_l("kiDrainMulti");
        this.kiDrainMultiFlat = kiDrainMulti.func_74760_g("flat");
        this.kiDrainMultiPerLevel = kiDrainMulti.func_74760_g("perLevel");
        this.kiDrainMultiMinOrMax = kiDrainMulti.func_74760_g("minOrMax");
        NBTTagCompound heatMulti = formMastery.func_74775_l("heatMulti");
        this.heatMultiFlat = heatMulti.func_74760_g("flat");
        this.heatMultiPerLevel = heatMulti.func_74760_g("perLevel");
        this.heatMultiMinOrMax = heatMulti.func_74760_g("minOrMax");
        NBTTagCompound painMulti = formMastery.func_74775_l("painMulti");
        this.painMultiFlat = painMulti.func_74760_g("flat");
        this.painMultiPerLevel = painMulti.func_74760_g("perLevel");
        this.painMultiMinOrMax = painMulti.func_74760_g("minOrMax");
        NBTTagCompound healthRequirementMulti = formMastery.func_74775_l("healthRequirementMulti");
        this.healthRequirementMultiFlat = healthRequirementMulti.func_74760_g("flat");
        this.healthRequirementMultiPerLevel = healthRequirementMulti.func_74760_g("perLevel");
        this.healthRequirementMultiMinOrMax = healthRequirementMulti.func_74760_g("minOrMax");
        NBTTagCompound dodgeMulti = formMastery.func_74775_l("dodgeMulti");
        this.dodgeMultiFlat = dodgeMulti.func_74760_g("flat");
        this.dodgeMultiPerLevel = dodgeMulti.func_74760_g("perLevel");
        this.dodgeMultiMinOrMax = dodgeMulti.func_74760_g("minOrMax");
        NBTTagCompound damageNegationMulti = formMastery.func_74775_l("damageNegationMulti");
        this.damageNegationMultiFlat = damageNegationMulti.func_74760_g("flat");
        this.damageNegationMultiPerLevel = damageNegationMulti.func_74760_g("perLevel");
        this.damageNegationMultiMinOrMax = damageNegationMulti.func_74760_g("minOrMax");
        NBTTagCompound movementSpeedMulti = formMastery.func_74775_l("movementSpeedMulti");
        this.movementSpeedMultiFlat = movementSpeedMulti.func_74760_g("flat");
        this.movementSpeedMultiPerLevel = movementSpeedMulti.func_74760_g("perLevel");
        this.movementSpeedMultiMinOrMax = movementSpeedMulti.func_74760_g("minOrMax");
        NBTTagCompound tailCutChanceMulti = formMastery.func_74775_l("tailCutMulti");
        this.tailCutChanceMultiFlat = tailCutChanceMulti.func_74760_g("flat");
        this.tailCutChanceMultiPerLevel = tailCutChanceMulti.func_74760_g("perLevel");
        this.tailCutChanceMultiMinOrMax = tailCutChanceMulti.func_74760_g("minOrMax");
        if (formMastery.func_74764_b("racialBonuses")) {
            NBTTagCompound racialBonuses = formMastery.func_74775_l("racialBonuses");
            this.absorptionEnabled = racialBonuses.func_74767_n("absorptionEnabled");
            this.absorptionMulti = racialBonuses.func_74760_g("absorptionMulti");
            this.powerPointEnabled = racialBonuses.func_74767_n("powerPointEnabled");
            this.powerPointCost = racialBonuses.func_74762_e("powerPointCost");
            this.powerPointGrowth = racialBonuses.func_74762_e("powerPointGrowth");
            this.powerPointMultiNormal = racialBonuses.func_74760_g("powerPointMultiNormal");
            this.powerPointMultiBasedOnPoints = racialBonuses.func_74760_g("powerPointMultiBasedOnPoints");
            NBTTagCompound powerPointMastery = racialBonuses.func_74775_l("powerPointMastery");
            this.powerPointCostMultiFlat = powerPointMastery.func_74760_g("flat");
            this.powerPointCostPerLevel = powerPointMastery.func_74760_g("perLevel");
            this.powerPointCostMinOrMax = powerPointMastery.func_74760_g("minOrMax");
        }
        if (formMastery.func_74764_b("destroyerConfigs")) {
            NBTTagCompound destroyerConfigs = formMastery.func_74775_l("destroyerConfigs");
            this.destroyerEnabled = destroyerConfigs.func_74767_n("enabled");
            this.destroyerKiDamageMultiFlat = destroyerConfigs.func_74760_g("flat");
            this.destroyerKiDamageMultiPerLevel = destroyerConfigs.func_74760_g("perLevel");
            this.destroyerKiDamageMultiMinOrMax = destroyerConfigs.func_74760_g("minOrMax");
            this.destroyerKiDamage = destroyerConfigs.func_74760_g("damage");
        }
        NBTTagCompound update = formMastery.func_74775_l("update");
        this.updateGain = update.func_74760_g("gain");
        this.updateMultiDivPlus = update.func_74760_g("multiDivPlus");
        this.updateMindBonusFlat = update.func_74760_g("flat");
        this.updateMindBonusPerMind = update.func_74760_g("perMind");
        this.updateMindBonusMax = update.func_74760_g("max");
        NBTTagCompound attack = formMastery.func_74775_l("attack");
        this.attackGain = attack.func_74760_g("gain");
        this.attackMultiDivPlus = attack.func_74760_g("multiDivPlus");
        this.attackMindBonusFlat = attack.func_74760_g("flat");
        this.attackMindBonusPerMind = attack.func_74760_g("perMind");
        this.attackMindBonusMax = attack.func_74760_g("max");
        NBTTagCompound damaged = formMastery.func_74775_l("damaged");
        this.damagedGain = damaged.func_74760_g("gain");
        this.damagedMultiDivPlus = damaged.func_74760_g("multiDivPlus");
        this.damagedMindBonusFlat = damaged.func_74760_g("flat");
        this.damagedMindBonusPerMind = damaged.func_74760_g("perMind");
        this.damagedMindBonusMax = damaged.func_74760_g("max");
        NBTTagCompound fireKi = formMastery.func_74775_l("fireKi");
        this.fireKiGain = fireKi.func_74760_g("gain");
        this.fireKiMultiDivPlus = fireKi.func_74760_g("multiDivPlus");
        this.fireKiMindBonusFlat = fireKi.func_74760_g("flat");
        this.fireKiMindBonusPerMind = fireKi.func_74760_g("perMind");
        this.fireKiMindBonusMax = fireKi.func_74760_g("max");
        this.masteryLink.loadFromNBT(formMastery);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound formMastery = new NBTTagCompound();
        formMastery.func_74776_a("maxLevel", this.maxLevel);
        formMastery.func_74776_a("instantTransformationUnlockLevel", this.instantTransformationUnlockLevel);
        formMastery.func_74776_a("kiDrain", this.kiDrain);
        formMastery.func_74768_a("kiDrainTimer", this.kiDrainTimer);
        formMastery.func_74776_a("healthRequirement", this.healthRequirement);
        formMastery.func_74776_a("dodgeChance", this.dodgeChance);
        formMastery.func_74776_a("damageNegation", this.damageNegation);
        formMastery.func_74768_a("maxHeat", this.maxHeat);
        formMastery.func_74768_a("painTime", this.painTime);
        formMastery.func_74776_a("movementSpeed", this.movementSpeed);
        formMastery.func_74776_a("tailCutChance", this.tailCutChance);
        NBTTagCompound attributeMulti = new NBTTagCompound();
        attributeMulti.func_74776_a("flat", this.attributeMultiFlat);
        attributeMulti.func_74776_a("perLevel", this.attributeMultiPerLevel);
        attributeMulti.func_74776_a("max", this.attributeMultiMinOrMax);
        formMastery.func_74782_a("attributeMulti", (NBTBase)attributeMulti);
        NBTTagCompound kiDrainMulti = new NBTTagCompound();
        kiDrainMulti.func_74776_a("flat", this.kiDrainMultiFlat);
        kiDrainMulti.func_74776_a("perLevel", this.kiDrainMultiPerLevel);
        kiDrainMulti.func_74776_a("minOrMax", this.kiDrainMultiMinOrMax);
        formMastery.func_74782_a("kiDrainMulti", (NBTBase)kiDrainMulti);
        NBTTagCompound heatMulti = new NBTTagCompound();
        heatMulti.func_74776_a("flat", this.heatMultiFlat);
        heatMulti.func_74776_a("perLevel", this.heatMultiPerLevel);
        heatMulti.func_74776_a("minOrMax", this.heatMultiMinOrMax);
        formMastery.func_74782_a("heatMulti", (NBTBase)heatMulti);
        NBTTagCompound painMulti = new NBTTagCompound();
        painMulti.func_74776_a("flat", this.painMultiFlat);
        painMulti.func_74776_a("perLevel", this.painMultiPerLevel);
        painMulti.func_74776_a("minOrMax", this.painMultiMinOrMax);
        formMastery.func_74782_a("painMulti", (NBTBase)painMulti);
        NBTTagCompound healthRequirementMulti = new NBTTagCompound();
        healthRequirementMulti.func_74776_a("flat", this.healthRequirementMultiFlat);
        healthRequirementMulti.func_74776_a("perLevel", this.healthRequirementMultiPerLevel);
        healthRequirementMulti.func_74776_a("minOrMax", this.healthRequirementMultiMinOrMax);
        formMastery.func_74782_a("healthRequirementMulti", (NBTBase)healthRequirementMulti);
        NBTTagCompound dodgeMulti = new NBTTagCompound();
        dodgeMulti.func_74776_a("flat", this.dodgeMultiFlat);
        dodgeMulti.func_74776_a("perLevel", this.dodgeMultiPerLevel);
        dodgeMulti.func_74776_a("minOrMax", this.dodgeMultiMinOrMax);
        formMastery.func_74782_a("dodgeMulti", (NBTBase)dodgeMulti);
        NBTTagCompound damageNegationMulti = new NBTTagCompound();
        damageNegationMulti.func_74776_a("flat", this.damageNegationMultiFlat);
        damageNegationMulti.func_74776_a("perLevel", this.damageNegationMultiPerLevel);
        damageNegationMulti.func_74776_a("minOrMax", this.damageNegationMultiMinOrMax);
        formMastery.func_74782_a("damageNegationMulti", (NBTBase)damageNegationMulti);
        NBTTagCompound movementSpeedMulti = new NBTTagCompound();
        movementSpeedMulti.func_74776_a("flat", this.movementSpeedMultiFlat);
        movementSpeedMulti.func_74776_a("perLevel", this.movementSpeedMultiPerLevel);
        movementSpeedMulti.func_74776_a("minOrMax", this.movementSpeedMultiMinOrMax);
        formMastery.func_74782_a("movementSpeedMulti", (NBTBase)movementSpeedMulti);
        NBTTagCompound tailCutChanceMulti = new NBTTagCompound();
        tailCutChanceMulti.func_74776_a("flat", this.tailCutChanceMultiFlat);
        tailCutChanceMulti.func_74776_a("perLevel", this.tailCutChanceMultiPerLevel);
        tailCutChanceMulti.func_74776_a("minOrMax", this.tailCutChanceMultiMinOrMax);
        formMastery.func_74782_a("tailCutMulti", (NBTBase)tailCutChanceMulti);
        NBTTagCompound racialBonuses = new NBTTagCompound();
        racialBonuses.func_74757_a("powerPointEnabled", this.powerPointEnabled);
        racialBonuses.func_74768_a("powerPointCost", this.powerPointCost);
        racialBonuses.func_74768_a("powerPointGrowth", this.powerPointGrowth);
        racialBonuses.func_74776_a("powerPointMultiNormal", this.powerPointMultiNormal);
        racialBonuses.func_74776_a("powerPointMultiBasedOnPoints", this.powerPointMultiBasedOnPoints);
        racialBonuses.func_74757_a("absorptionEnabled", this.absorptionEnabled);
        racialBonuses.func_74776_a("absorptionMulti", this.absorptionMulti);
        NBTTagCompound powerPointMastery = new NBTTagCompound();
        powerPointMastery.func_74776_a("flat", this.powerPointCostMultiFlat);
        powerPointMastery.func_74776_a("perLevel", this.powerPointCostPerLevel);
        powerPointMastery.func_74776_a("minOrMax", this.powerPointCostMinOrMax);
        racialBonuses.func_74782_a("powerPointMastery", (NBTBase)powerPointMastery);
        formMastery.func_74782_a("racialBonuses", (NBTBase)racialBonuses);
        NBTTagCompound destroyerConfigs = new NBTTagCompound();
        destroyerConfigs.func_74757_a("enabled", this.destroyerEnabled);
        destroyerConfigs.func_74776_a("flat", this.destroyerKiDamageMultiFlat);
        destroyerConfigs.func_74776_a("perLevel", this.destroyerKiDamageMultiPerLevel);
        destroyerConfigs.func_74776_a("minOrMax", this.destroyerKiDamageMultiMinOrMax);
        destroyerConfigs.func_74776_a("damage", this.destroyerKiDamage);
        formMastery.func_74782_a("destroyerConfigs", (NBTBase)destroyerConfigs);
        NBTTagCompound update = new NBTTagCompound();
        update.func_74776_a("gain", this.updateGain);
        update.func_74776_a("multiDivPlus", this.updateMultiDivPlus);
        update.func_74776_a("flat", this.updateMindBonusFlat);
        update.func_74776_a("perMind", this.updateMindBonusPerMind);
        update.func_74776_a("max", this.updateMindBonusMax);
        formMastery.func_74782_a("update", (NBTBase)update);
        NBTTagCompound attack = new NBTTagCompound();
        attack.func_74776_a("gain", this.attackGain);
        attack.func_74776_a("multiDivPlus", this.attackMultiDivPlus);
        attack.func_74776_a("flat", this.attackMindBonusFlat);
        attack.func_74776_a("perMind", this.attackMindBonusPerMind);
        attack.func_74776_a("max", this.attackMindBonusMax);
        formMastery.func_74782_a("attack", (NBTBase)attack);
        NBTTagCompound damaged = new NBTTagCompound();
        damaged.func_74776_a("gain", this.damagedGain);
        damaged.func_74776_a("multiDivPlus", this.damagedMultiDivPlus);
        damaged.func_74776_a("flat", this.damagedMindBonusFlat);
        damaged.func_74776_a("perMind", this.damagedMindBonusPerMind);
        damaged.func_74776_a("max", this.damagedMindBonusMax);
        formMastery.func_74782_a("damaged", (NBTBase)damaged);
        NBTTagCompound fireKi = new NBTTagCompound();
        fireKi.func_74776_a("gain", this.fireKiGain);
        fireKi.func_74776_a("multiDivPlus", this.fireKiMultiDivPlus);
        fireKi.func_74776_a("flat", this.fireKiMindBonusFlat);
        fireKi.func_74776_a("perMind", this.fireKiMindBonusPerMind);
        fireKi.func_74776_a("max", this.fireKiMindBonusMax);
        formMastery.func_74782_a("fireKi", (NBTBase)fireKi);
        compound.func_74782_a("formMastery", (NBTBase)formMastery);
        this.masteryLink.saveToNBT(formMastery);
        return compound;
    }

    @Override
    public IFormMastery save() {
        if (this.parent != null) {
            this.parent.save();
        }
        return this;
    }

    @Override
    public void setPowerPointCost(int cost) {
        if (cost < 0) {
            cost = 0;
        }
        this.powerPointCost = cost;
    }

    @Override
    public void setPowerPointGrowth(int growth) {
        if (growth < 0) {
            growth = 0;
        }
        this.powerPointGrowth = growth;
    }

    @Override
    public void setPowerPointMultiNormal(float multi) {
        if (multi < 0.0f) {
            multi = 0.0f;
        }
        this.powerPointMultiNormal = multi;
    }

    @Override
    public void setPowerPointMultiBasedOnPoints(float multi) {
        if (multi < 0.0f) {
            multi = 0.0f;
        }
        this.powerPointMultiBasedOnPoints = multi;
    }

    @Override
    public void setAbsorptionMulti(float multi) {
        if (multi < 0.0f) {
            multi = 0.0f;
        }
        this.absorptionMulti = multi;
    }

    @Override
    public int getPowerPointCost() {
        return this.powerPointCost;
    }

    @Override
    public int getPowerPointGrowth() {
        return this.powerPointGrowth;
    }

    @Override
    public float getPowerPointMultiNormal() {
        return this.powerPointMultiNormal;
    }

    @Override
    public float getPowerPointMultiBasedOnPoints() {
        return this.powerPointMultiBasedOnPoints;
    }

    @Override
    public float getAbsorptionMulti() {
        return this.absorptionMulti;
    }

    @Override
    public void setDestroyerOn(boolean isOn) {
        this.destroyerEnabled = isOn;
    }

    @Override
    public boolean isDestroyerOn() {
        return this.destroyerEnabled;
    }

    @Override
    public void setDestroyerEnergyDamage(float energyDamage) {
        this.destroyerKiDamage = Math.max(energyDamage, 0.0f);
    }

    @Override
    public float getDestroyerEnergyDamage() {
        return this.destroyerKiDamage;
    }

    @Override
    public boolean isAbsorptionBoostEnabled() {
        return this.absorptionEnabled;
    }

    @Override
    public boolean isPowerPointBoostEnabled() {
        return this.powerPointEnabled;
    }

    @Override
    public IFormMasteryLinkData getMasteryLinks() {
        return this.masteryLink;
    }
}

