/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.effects.types;

import kamkeel.npcdbc.config.ConfigDBCEffects;
import kamkeel.npcdbc.controllers.BonusController;
import kamkeel.npcdbc.controllers.DBCEffectController;
import kamkeel.npcdbc.data.PlayerBonus;
import kamkeel.npcdbc.data.effects.AddonEffect;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.controllers.data.PlayerEffect;
import noppes.npcs.scripted.event.player.PlayerEvent;

public class HumanSpirit
extends AddonEffect {
    public HumanSpirit() {
        this.name = "HumanSpirit";
        this.langName = "effect.humanspirit";
        this.id = 14;
        this.iconX = 224;
        this.iconY = 0;
        this.length = ConfigDBCEffects.HumanSpiritLength;
    }

    public void onAdded(EntityPlayer player, PlayerEffect playerEffect) {
        PlayerBonus humanSpiritBonus = new PlayerBonus(this.name, 0);
        humanSpiritBonus.constituion = (float)ConfigDBCEffects.HumanSpiritConBoostPercent / 100.0f;
        humanSpiritBonus.dexterity = (float)ConfigDBCEffects.HumanSpiritDexBoostPercent / 100.0f;
        BonusController.getInstance().applyBonus(player, humanSpiritBonus);
    }

    public void onRemoved(EntityPlayer player, PlayerEffect playerEffect, PlayerEvent.EffectEvent.ExpirationType type) {
        BonusController.getInstance().removeBonus(player, this.name);
        if (ConfigDBCEffects.EXHAUST_HUMANSPIRIT) {
            DBCEffectController.getInstance().applyEffect(player, 13, ConfigDBCEffects.EXHAUST_HUMANSPIRIT_TIME * 60);
        }
    }
}

